/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.sounds;

import com.minecolonies.coremod.sounds.AbstractWorkerSounds;
import com.minecolonies.coremod.sounds.ModSoundEvents;
import com.minecolonies.coremod.util.SoundUtils;
import java.util.Random;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public final class FishermanSounds
extends AbstractWorkerSounds {
    private static final int NUMBER_OF_SOUNDS = 2;
    private static final Random rand = new Random();

    @Override
    public void playSound(World worldIn, BlockPos position, boolean isFemale, double saturation) {
        switch (rand.nextInt(3)) {
            case 1: {
                SoundEvent generalPhrases = isFemale ? Female.generalPhrases : Male.generalPhrases;
                SoundUtils.playSoundAtCitizenWithChance(worldIn, position, generalPhrases, this.getPhraseChance());
                break;
            }
            case 2: {
                SoundEvent noises = isFemale ? Female.noises : Male.noises;
                SoundUtils.playSoundAtCitizenWithChance(worldIn, position, noises, this.getBasicSoundChance());
                break;
            }
        }
    }

    @Override
    public String getWorkerString() {
        return "Fisherman";
    }

    @Override
    public void playInteractionSound(World world, BlockPos position, boolean female) {
    }

    public static final class Male {
        public static final SoundEvent generalPhrases = ModSoundEvents.getSoundID("mob.fisherman.male.generalphrases");
        public static final SoundEvent noises = ModSoundEvents.getSoundID("mob.fisherman.male.noise");
        public static final SoundEvent iGotOne = ModSoundEvents.getSoundID("mob.fisherman.male.igotOne");
        public static final SoundEvent needFishingRod = ModSoundEvents.getSoundID("mob.fisherman.male.needfishingrod");
        public static final SoundEvent offToBed = ModSoundEvents.getSoundID("mob.fisherman.male.offtobed");
        public static final SoundEvent badWeather = ModSoundEvents.getSoundID("mob.fisherman.male.badweather");

        private Male() {
        }
    }

    public static final class Female {
        public static final SoundEvent generalPhrases = ModSoundEvents.getSoundID("mob.fisherman.female.generalphrases");
        public static final SoundEvent noises = ModSoundEvents.getSoundID("mob.fisherman.female.noise");
        public static final SoundEvent iGotOne = ModSoundEvents.getSoundID("mob.fisherman.female.igotone");
        public static final SoundEvent needFishingRod = ModSoundEvents.getSoundID("mob.fisherman.female.needfishingrod");
        public static final SoundEvent offToBed = ModSoundEvents.getSoundID("mob.fisherman.female.offtobed");
        public static final SoundEvent badWeather = ModSoundEvents.getSoundID("mob.fisherman.female.badweather");

        private Female() {
        }
    }
}

