/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.sounds;

import com.minecolonies.coremod.sounds.AbstractWorkerSounds;
import com.minecolonies.coremod.sounds.ModSoundEvents;
import com.minecolonies.coremod.util.SoundUtils;
import java.util.Random;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public final class DeliverymanSounds
extends AbstractWorkerSounds {
    private static final int NUMBER_OF_SOUNDS = 3;
    private static final Random rand = new Random();

    @Override
    public void playSound(World worldIn, BlockPos position, boolean isFemale, double saturation) {
        if (!isFemale) {
            return;
        }
        switch (rand.nextInt(4)) {
            case 1: {
                SoundEvent noises = Female.noises;
                SoundUtils.playSoundAtCitizenWithChance(worldIn, position, noises, this.getBasicSoundChance());
                break;
            }
            case 2: {
                this.playSaturationSound(worldIn, position, isFemale, saturation);
                break;
            }
            default: {
                SoundEvent generalPhrases = Female.generalPhrases;
                SoundUtils.playSoundAtCitizenWithChance(worldIn, position, generalPhrases, this.getPhraseChance());
            }
        }
    }

    @Override
    public String getWorkerString() {
        return "Deliveryman";
    }

    @Override
    public void playInteractionSound(World world, BlockPos position, boolean female) {
    }

    public void playSaturationSound(World worldIn, BlockPos position, boolean isFemale, double saturation) {
        if (!isFemale) {
            return;
        }
        SoundEvent saturationFeedback = saturation < 3.0 ? Female.saturationVeryLow : (saturation < 5.0 ? Female.saturationLow : Female.saturationHigh);
        SoundUtils.playSoundAtCitizenWithChance(worldIn, position, saturationFeedback, this.getBasicSoundChance());
    }

    public static final class Male {
        private Male() {
        }
    }

    public static final class Female {
        public static final SoundEvent generalPhrases = ModSoundEvents.getSoundID("mob.deliveryman.female.generalphrases");
        public static final SoundEvent noises = ModSoundEvents.getSoundID("mob.deliveryman.female.noise");
        public static final SoundEvent hostile = ModSoundEvents.getSoundID("mob.deliveryman.female.hostile");
        public static final SoundEvent offToBed = ModSoundEvents.getSoundID("mob.deliveryman.female.offtobed");
        public static final SoundEvent badWeather = ModSoundEvents.getSoundID("mob.deliveryman.female.badweather");
        public static final SoundEvent saturationVeryLow = ModSoundEvents.getSoundID("mob.deliveryman.female.saturationverylow");
        public static final SoundEvent saturationLow = ModSoundEvents.getSoundID("mob.deliveryman.female.saturationlow");
        public static final SoundEvent saturationHigh = ModSoundEvents.getSoundID("mob.deliveryman.female.saturationhigh");

        private Female() {
        }
    }
}

