/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.proxy;

import com.minecolonies.api.configuration.ConfigurationHandler;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.blocks.ModBlocks;
import com.minecolonies.coremod.client.gui.WindowBuildTool;
import com.minecolonies.coremod.colony.CitizenDataView;
import com.minecolonies.coremod.entity.EntityCitizen;
import com.minecolonies.coremod.entity.EntityFishHook;
import com.minecolonies.coremod.entity.ai.mobs.barbarians.EntityArcherBarbarian;
import com.minecolonies.coremod.entity.ai.mobs.barbarians.EntityBarbarian;
import com.minecolonies.coremod.entity.ai.mobs.barbarians.EntityChiefBarbarian;
import com.minecolonies.coremod.entity.ai.mobs.util.BarbarianSpawnUtils;
import com.minecolonies.coremod.event.EventHandler;
import com.minecolonies.coremod.event.FMLEventHandler;
import com.minecolonies.coremod.inventory.GuiHandler;
import com.minecolonies.coremod.items.ModItems;
import com.minecolonies.coremod.proxy.IProxy;
import com.minecolonies.coremod.sounds.ModSoundEvents;
import com.minecolonies.coremod.tileentities.ScarecrowTileEntity;
import com.minecolonies.coremod.tileentities.TileEntityColonyBuilding;
import com.minecolonies.coremod.tileentities.TileEntityInfoPoster;
import com.minecolonies.coremod.tileentities.TileEntityRack;
import com.minecolonies.coremod.tileentities.TileEntityWareHouse;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Mod.EventBusSubscriber
public class CommonProxy
implements IProxy {
    private static final int PRIMARY_COLOR = 5;
    private static final int SECONDARY_COLOR = 700;
    private static final Map<String, NBTTagCompound> playerPropertiesData = new HashMap<String, NBTTagCompound>();
    private int nextEntityId = 0;

    public static void storeEntityData(String name, NBTTagCompound compound) {
        playerPropertiesData.put(name, compound);
    }

    public static NBTTagCompound getEntityData(String name) {
        return playerPropertiesData.remove(name);
    }

    @SubscribeEvent
    public static void registerBlocks(@NotNull RegistryEvent.Register<Block> event) {
        ModBlocks.init((IForgeRegistry<Block>)event.getRegistry());
    }

    @SubscribeEvent
    public static void registerItems(@NotNull RegistryEvent.Register<Item> event) {
        ModItems.init((IForgeRegistry<Item>)event.getRegistry());
        ModBlocks.registerItemBlock((IForgeRegistry<Item>)event.getRegistry());
    }

    @Override
    public boolean isClient() {
        return false;
    }

    @Override
    public void registerTileEntities() {
        GameRegistry.registerTileEntity(TileEntityColonyBuilding.class, (String)"minecolonies.ColonyBuilding");
        GameRegistry.registerTileEntity(ScarecrowTileEntity.class, (String)"minecolonies.Scarecrow");
        GameRegistry.registerTileEntity(TileEntityWareHouse.class, (String)"minecolonies.WareHouse");
        GameRegistry.registerTileEntity(TileEntityRack.class, (String)"minecolonies.rack");
        GameRegistry.registerTileEntity(TileEntityInfoPoster.class, (String)"minecolonies.InfoPoster");
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)MineColonies.instance, (IGuiHandler)new GuiHandler());
    }

    @Override
    public void registerEvents() {
        MinecraftForge.EVENT_BUS.register((Object)new EventHandler());
        MinecraftForge.EVENT_BUS.register((Object)new FMLEventHandler());
        MinecraftForge.EVENT_BUS.register((Object)new ConfigurationHandler());
    }

    @Override
    public void registerEntities() {
        EntityRegistry.registerModEntity(EntityCitizen.class, (String)"Citizen", (int)this.getNextEntityId(), (Object)MineColonies.instance, (int)256, (int)2, (boolean)true);
        EntityRegistry.registerModEntity(EntityFishHook.class, (String)"Fishhook", (int)this.getNextEntityId(), (Object)MineColonies.instance, (int)256, (int)5, (boolean)true);
        EntityRegistry.registerModEntity(EntityBarbarian.class, (String)"Barbarian", (int)this.getNextEntityId(), (Object)MineColonies.instance, (int)256, (int)2, (boolean)true);
        EntityRegistry.registerModEntity(EntityArcherBarbarian.class, (String)"ArcherBarbarian", (int)this.getNextEntityId(), (Object)MineColonies.instance, (int)256, (int)2, (boolean)true);
        EntityRegistry.registerModEntity(EntityChiefBarbarian.class, (String)"ChiefBarbarian", (int)this.getNextEntityId(), (Object)MineColonies.instance, (int)256, (int)2, (boolean)true);
        LootTableList.func_186375_a((ResourceLocation)BarbarianSpawnUtils.BarbarianLootTable);
        LootTableList.func_186375_a((ResourceLocation)BarbarianSpawnUtils.ArcherLootTable);
        LootTableList.func_186375_a((ResourceLocation)BarbarianSpawnUtils.ChiefLootTable);
        EntityRegistry.registerEgg(EntityBarbarian.class, (int)5, (int)700);
        EntityRegistry.registerEgg(EntityArcherBarbarian.class, (int)5, (int)700);
        EntityRegistry.registerEgg(EntityChiefBarbarian.class, (int)5, (int)700);
    }

    @Override
    public void registerEntityRendering() {
    }

    @Override
    public void registerSounds() {
        ModSoundEvents.registerSounds();
    }

    @Override
    public void registerTileEntityRendering() {
    }

    @Override
    public void showCitizenWindow(CitizenDataView citizen) {
    }

    @Override
    public void openBuildToolWindow(BlockPos pos) {
    }

    @Override
    public void openBuildToolWindow(BlockPos pos, String structureName, int rotation, WindowBuildTool.FreeMode mode) {
    }

    @Override
    public void openClipBoardWindow(int ColonyId) {
    }

    @Override
    public void registerRenderer() {
    }

    @Override
    public File getSchematicsFolder() {
        return null;
    }

    @Override
    @Nullable
    public World getWorldFromMessage(@NotNull MessageContext context) {
        return context.getServerHandler().field_147369_b.func_71121_q();
    }

    @Override
    @Nullable
    public World getWorld(int dimension) {
        return FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(dimension);
    }

    private int getNextEntityId() {
        return this.nextEntityId++;
    }
}

