/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.placementhandlers;

import com.google.common.reflect.TypeToken;
import com.minecolonies.api.colony.requestsystem.requestable.IDeliverable;
import com.minecolonies.api.colony.requestsystem.requestable.Stack;
import com.minecolonies.api.util.BlockUtils;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.coremod.blocks.BlockMinecoloniesRack;
import com.minecolonies.coremod.blocks.BlockSolidSubstitution;
import com.minecolonies.coremod.blocks.BlockWaypoint;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.ColonyManager;
import com.minecolonies.coremod.colony.buildings.BuildingWareHouse;
import com.minecolonies.coremod.entity.EntityCitizen;
import com.minecolonies.coremod.entity.ai.basic.AbstractEntityAIStructure;
import com.minecolonies.coremod.placementhandlers.IPlacementHandler;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAir;
import net.minecraft.block.BlockBed;
import net.minecraft.block.BlockChest;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockDoublePlant;
import net.minecraft.block.BlockDragonEgg;
import net.minecraft.block.BlockEndPortal;
import net.minecraft.block.BlockFire;
import net.minecraft.block.BlockFlowerPot;
import net.minecraft.block.BlockGrassPath;
import net.minecraft.block.BlockMobSpawner;
import net.minecraft.block.BlockPortal;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemDoor;
import net.minecraft.item.ItemFlintAndSteel;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PlacementHandlers {
    public static final List<IPlacementHandler> handlers = new ArrayList<IPlacementHandler>();

    private PlacementHandlers() {
    }

    public static boolean checkForListInInvAndRequest(@NotNull AbstractEntityAIStructure<?> placer, List<ItemStack> itemList) {
        List<ItemStack> foundStacks = InventoryUtils.filterItemHandler((IItemHandler)new InvWrapper((IInventory)placer.getWorker().getInventoryCitizen()), itemStack -> itemList.stream().anyMatch(targetStack -> ItemStackUtils.compareItemStacksIgnoreStackSize(itemStack, targetStack)));
        itemList.removeIf(itemStack -> ItemStackUtils.isEmpty(itemStack) != false || foundStacks.stream().anyMatch(targetStack -> ItemStackUtils.compareItemStacksIgnoreStackSize(itemStack, targetStack)));
        for (ItemStack placedStack : itemList) {
            if (ItemStackUtils.isEmpty(placedStack).booleanValue()) {
                return true;
            }
            if (!placer.getOwnBuilding().getOpenRequestsOfTypeFiltered(placer.getWorker().getCitizenData(), TypeToken.of(IDeliverable.class), r -> ((IDeliverable)r.getRequest()).matches(placedStack)).isEmpty()) continue;
            Stack stackRequest = new Stack(placer.getTotalAmount(placedStack));
            placer.getWorker().getCitizenData().createRequest(stackRequest);
            return true;
        }
        return false;
    }

    static {
        handlers.add(new AirPlacementHandler());
        handlers.add(new FireplacementHandler());
        handlers.add(new GrassPlacementHandler());
        handlers.add(new DoorPlacementHandler());
        handlers.add(new BedPlacementHandler());
        handlers.add(new DoublePlantPlacementHandler());
        handlers.add(new SpecialBlockPlacementAttemptHandler());
        handlers.add(new FlowerPotPlacementHandler());
        handlers.add(new BlockGrassPathPlacementHandler());
        handlers.add(new StairBlockPlacementHandler());
        handlers.add(new BlockSolidSubstitutionPlacementHandler());
        handlers.add(new ChestPlacementHandler());
        handlers.add(new WayPointBlockPlacementHandler());
        handlers.add(new RackPlacementHandler());
        handlers.add(new GeneralBlockPlacementHandler());
    }

    public static class RackPlacementHandler
    implements IPlacementHandler {
        @Override
        public Object handle(@NotNull World world, @NotNull BlockPos pos, @NotNull IBlockState blockState, @Nullable AbstractEntityAIStructure<?> placer, boolean infiniteResources, boolean complete) {
            TileEntity entity;
            if (!(blockState.func_177230_c() instanceof BlockMinecoloniesRack)) {
                return IPlacementHandler.ActionProcessingResult.IGNORE;
            }
            if (placer != null && !infiniteResources) {
                ArrayList<ItemStack> itemList = new ArrayList<ItemStack>();
                itemList.add(BlockUtils.getItemStackFromBlockState(blockState));
                for (ItemStack stack : placer.getItemsFromTileEntity()) {
                    if (ItemStackUtils.isEmpty(stack).booleanValue()) continue;
                    itemList.add(stack);
                }
                if (PlacementHandlers.checkForListInInvAndRequest(placer, itemList)) {
                    return IPlacementHandler.ActionProcessingResult.DENY;
                }
            }
            if ((entity = world.func_175625_s(pos)) instanceof TileEntityChest) {
                BuildingWareHouse.handleBuildingOverChest(pos, (TileEntityChest)entity, world);
            } else if (!world.func_180501_a(pos, blockState, 3)) {
                return IPlacementHandler.ActionProcessingResult.DENY;
            }
            return blockState;
        }
    }

    public static class ChestPlacementHandler
    implements IPlacementHandler {
        @Override
        public Object handle(@NotNull World world, @NotNull BlockPos pos, @NotNull IBlockState blockState, @Nullable AbstractEntityAIStructure<?> placer, boolean infiniteResources, boolean complete) {
            TileEntity entity;
            if (!(blockState.func_177230_c() instanceof BlockChest)) {
                return IPlacementHandler.ActionProcessingResult.IGNORE;
            }
            if (placer != null && !infiniteResources) {
                ArrayList<ItemStack> itemList = new ArrayList<ItemStack>();
                itemList.add(BlockUtils.getItemStackFromBlockState(blockState));
                itemList.addAll(placer.getItemsFromTileEntity());
                itemList.removeIf(ItemStackUtils::isEmpty);
                if (PlacementHandlers.checkForListInInvAndRequest(placer, itemList)) {
                    return IPlacementHandler.ActionProcessingResult.DENY;
                }
            }
            if ((entity = world.func_175625_s(pos)) instanceof TileEntityChest) {
                BuildingWareHouse.handleBuildingOverChest(pos, (TileEntityChest)entity, world);
            } else if (!world.func_180501_a(pos, blockState, 3)) {
                return IPlacementHandler.ActionProcessingResult.DENY;
            }
            return blockState;
        }
    }

    public static class WayPointBlockPlacementHandler
    implements IPlacementHandler {
        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public Object handle(@NotNull World world, @NotNull BlockPos pos, @NotNull IBlockState blockState, @Nullable AbstractEntityAIStructure<?> placer, boolean infiniteResources, boolean complete) {
            if (!(blockState.func_177230_c() instanceof BlockWaypoint)) {
                return IPlacementHandler.ActionProcessingResult.IGNORE;
            }
            if (placer == null) {
                Colony colony = ColonyManager.getClosestColony(world, pos);
                if (colony == null || complete) return IPlacementHandler.ActionProcessingResult.IGNORE;
                colony.addWayPoint(pos, Blocks.field_150350_a.func_176223_P());
            } else {
                placer.handleBuildingOverBlock(pos);
                placer.addWayPoint(pos);
            }
            world.func_175698_g(pos);
            return blockState;
        }
    }

    public static class GeneralBlockPlacementHandler
    implements IPlacementHandler {
        @Override
        public Object handle(@NotNull World world, @NotNull BlockPos pos, @NotNull IBlockState blockState, @Nullable AbstractEntityAIStructure<?> placer, boolean infiniteResources, boolean complete) {
            if (world.func_180495_p(pos).equals(blockState)) {
                return IPlacementHandler.ActionProcessingResult.ACCEPT;
            }
            if (placer != null && !infiniteResources) {
                ArrayList<ItemStack> itemList = new ArrayList<ItemStack>();
                itemList.add(BlockUtils.getItemStackFromBlockState(blockState));
                itemList.addAll(placer.getItemsFromTileEntity());
                itemList.removeIf(ItemStackUtils::isEmpty);
                if (PlacementHandlers.checkForListInInvAndRequest(placer, itemList)) {
                    return IPlacementHandler.ActionProcessingResult.DENY;
                }
                placer.handleBuildingOverBlock(pos);
            }
            if (!world.func_180501_a(pos, blockState, 3)) {
                return IPlacementHandler.ActionProcessingResult.DENY;
            }
            if (placer != null) {
                placer.handleTileEntityPlacement(pos);
            }
            return blockState;
        }
    }

    public static class BlockSolidSubstitutionPlacementHandler
    implements IPlacementHandler {
        @Override
        public Object handle(@NotNull World world, @NotNull BlockPos pos, @NotNull IBlockState blockState, @Nullable AbstractEntityAIStructure<?> placer, boolean infiniteResources, boolean complete) {
            if (!(blockState.func_177230_c() instanceof BlockSolidSubstitution)) {
                return IPlacementHandler.ActionProcessingResult.IGNORE;
            }
            IBlockState newBlockState = BlockUtils.getSubstitutionBlockAtWorld(world, pos);
            if (placer != null && !infiniteResources) {
                ArrayList<ItemStack> itemList = new ArrayList<ItemStack>();
                itemList.add(BlockUtils.getItemStackFromBlockState(newBlockState));
                if (PlacementHandlers.checkForListInInvAndRequest(placer, itemList)) {
                    return IPlacementHandler.ActionProcessingResult.DENY;
                }
                placer.handleBuildingOverBlock(pos);
            }
            if (complete ? !world.func_180501_a(pos, blockState, 3) : !world.func_180501_a(pos, newBlockState, 3)) {
                return IPlacementHandler.ActionProcessingResult.DENY;
            }
            return newBlockState;
        }
    }

    public static class StairBlockPlacementHandler
    implements IPlacementHandler {
        @Override
        public Object handle(@NotNull World world, @NotNull BlockPos pos, @NotNull IBlockState blockState, @Nullable AbstractEntityAIStructure<?> placer, boolean infiniteResources, boolean complete) {
            if (blockState.func_177230_c() instanceof BlockStairs && world.func_180495_p(pos).func_177230_c() instanceof BlockStairs && world.func_180495_p(pos).func_177229_b((IProperty)BlockStairs.field_176309_a) == blockState.func_177229_b((IProperty)BlockStairs.field_176309_a) && blockState.func_177230_c() == world.func_180495_p(pos).func_177230_c()) {
                return IPlacementHandler.ActionProcessingResult.ACCEPT;
            }
            return IPlacementHandler.ActionProcessingResult.IGNORE;
        }
    }

    public static class BlockGrassPathPlacementHandler
    implements IPlacementHandler {
        @Override
        public Object handle(@NotNull World world, @NotNull BlockPos pos, @NotNull IBlockState blockState, @Nullable AbstractEntityAIStructure<?> placer, boolean infiniteResources, boolean complete) {
            if (!(blockState.func_177230_c() instanceof BlockGrassPath)) {
                return IPlacementHandler.ActionProcessingResult.IGNORE;
            }
            if (placer != null && !infiniteResources) {
                ItemStack placedStack = placer.getTotalAmount(new ItemStack(Blocks.field_150346_d, 1));
                if (!placer.holdEfficientTool(blockState.func_177230_c())) {
                    return IPlacementHandler.ActionProcessingResult.DENY;
                }
                ArrayList<ItemStack> itemList = new ArrayList<ItemStack>();
                itemList.add(placedStack);
                if (PlacementHandlers.checkForListInInvAndRequest(placer, itemList)) {
                    return IPlacementHandler.ActionProcessingResult.DENY;
                }
                placer.handleBuildingOverBlock(pos);
            }
            if (!world.func_180501_a(pos, Blocks.field_185774_da.func_176223_P(), 3)) {
                return IPlacementHandler.ActionProcessingResult.DENY;
            }
            return Blocks.field_150346_d.func_176223_P();
        }
    }

    public static class AirPlacementHandler
    implements IPlacementHandler {
        @Override
        public Object handle(@NotNull World world, @NotNull BlockPos pos, @NotNull IBlockState blockState, @Nullable AbstractEntityAIStructure<?> placer, boolean infiniteResources, boolean complete) {
            if (blockState.func_177230_c() instanceof BlockAir) {
                if (placer != null) {
                    List entityList;
                    placer.getWorker().func_184201_a(EntityEquipmentSlot.MAINHAND, ItemStackUtils.EMPTY);
                    if (placer.getEntityInfo() == null && !(entityList = world.func_175647_a(Entity.class, new AxisAlignedBB(pos), entity -> !(entity instanceof EntityLiving) && !(entity instanceof EntityItem))).isEmpty()) {
                        for (Entity entity2 : entityList) {
                            entity2.func_70097_a(DamageSource.field_82728_o, Float.MAX_VALUE);
                        }
                    }
                    placer.handleBuildingOverBlock(pos);
                }
                world.func_175698_g(pos);
                return IPlacementHandler.ActionProcessingResult.ACCEPT;
            }
            return IPlacementHandler.ActionProcessingResult.IGNORE;
        }
    }

    public static class FlowerPotPlacementHandler
    implements IPlacementHandler {
        @Override
        public Object handle(@NotNull World world, @NotNull BlockPos pos, @NotNull IBlockState blockState, @Nullable AbstractEntityAIStructure<?> placer, boolean infiniteResources, boolean complete) {
            if (!(blockState.func_177230_c() instanceof BlockFlowerPot)) {
                return IPlacementHandler.ActionProcessingResult.IGNORE;
            }
            if (placer != null) {
                if (!infiniteResources) {
                    ArrayList<ItemStack> itemList = new ArrayList<ItemStack>();
                    itemList.add(BlockUtils.getItemStackFromBlockState(blockState));
                    itemList.addAll(placer.getItemsFromTileEntity());
                    itemList.removeIf(ItemStackUtils::isEmpty);
                    if (PlacementHandlers.checkForListInInvAndRequest(placer, itemList)) {
                        return IPlacementHandler.ActionProcessingResult.DENY;
                    }
                }
                placer.handleBuildingOverBlock(pos);
            }
            if (!world.func_180501_a(pos, blockState, 3)) {
                return false;
            }
            if (placer != null) {
                placer.handleTileEntityPlacement(pos);
            }
            return blockState;
        }
    }

    public static class SpecialBlockPlacementAttemptHandler
    implements IPlacementHandler {
        @Override
        public Object handle(@NotNull World world, @NotNull BlockPos pos, @NotNull IBlockState blockState, @Nullable AbstractEntityAIStructure<?> placer, boolean infiniteResources, boolean complete) {
            if (blockState instanceof BlockEndPortal || blockState instanceof BlockMobSpawner || blockState instanceof BlockDragonEgg || blockState instanceof BlockPortal) {
                return IPlacementHandler.ActionProcessingResult.ACCEPT;
            }
            return IPlacementHandler.ActionProcessingResult.IGNORE;
        }
    }

    public static class DoublePlantPlacementHandler
    implements IPlacementHandler {
        @Override
        public Object handle(@NotNull World world, @NotNull BlockPos pos, @NotNull IBlockState blockState, @Nullable AbstractEntityAIStructure<?> placer, boolean infiniteResources, boolean complete) {
            if (!(blockState.func_177230_c() instanceof BlockDoublePlant)) {
                return IPlacementHandler.ActionProcessingResult.IGNORE;
            }
            if (placer != null && !infiniteResources) {
                ArrayList<ItemStack> itemList = new ArrayList<ItemStack>();
                itemList.add(placer.getTotalAmount(BlockUtils.getItemStackFromBlockState(blockState)));
                if (PlacementHandlers.checkForListInInvAndRequest(placer, itemList)) {
                    return IPlacementHandler.ActionProcessingResult.DENY;
                }
            }
            if (((BlockDoublePlant.EnumBlockHalf)blockState.func_177229_b((IProperty)BlockDoublePlant.field_176492_b)).equals((Object)BlockDoublePlant.EnumBlockHalf.LOWER)) {
                if (placer != null) {
                    placer.handleBuildingOverBlock(pos);
                }
                world.func_180501_a(pos, blockState.func_177226_a((IProperty)BlockDoublePlant.field_176492_b, (Comparable)BlockDoublePlant.EnumBlockHalf.LOWER), 3);
                world.func_180501_a(pos.func_177984_a(), blockState.func_177226_a((IProperty)BlockDoublePlant.field_176492_b, (Comparable)BlockDoublePlant.EnumBlockHalf.UPPER), 3);
                return blockState;
            }
            return IPlacementHandler.ActionProcessingResult.ACCEPT;
        }
    }

    public static class BedPlacementHandler
    implements IPlacementHandler {
        @Override
        public Object handle(@NotNull World world, @NotNull BlockPos pos, @NotNull IBlockState blockState, @Nullable AbstractEntityAIStructure<?> placer, boolean infiniteResources, boolean complete) {
            if (!(blockState.func_177230_c() instanceof BlockBed)) {
                return IPlacementHandler.ActionProcessingResult.IGNORE;
            }
            if (placer != null && !infiniteResources) {
                ArrayList<ItemStack> itemList = new ArrayList<ItemStack>();
                itemList.add(placer.getTotalAmount(BlockUtils.getItemStackFromBlockState(blockState)));
                if (PlacementHandlers.checkForListInInvAndRequest(placer, itemList)) {
                    return IPlacementHandler.ActionProcessingResult.DENY;
                }
            }
            EnumFacing facing = (EnumFacing)blockState.func_177229_b((IProperty)BlockBed.field_185512_D);
            if (blockState.func_177229_b((IProperty)BlockBed.field_176472_a) == BlockBed.EnumPartType.FOOT) {
                if (placer != null) {
                    placer.handleBuildingOverBlock(pos);
                }
                world.func_180501_a(pos.func_177972_a(facing), blockState.func_177226_a((IProperty)BlockBed.field_176472_a, (Comparable)BlockBed.EnumPartType.HEAD), 3);
                world.func_180501_a(pos, blockState.func_177226_a((IProperty)BlockBed.field_176472_a, (Comparable)BlockBed.EnumPartType.FOOT), 3);
                return blockState;
            }
            return IPlacementHandler.ActionProcessingResult.ACCEPT;
        }
    }

    public static class DoorPlacementHandler
    implements IPlacementHandler {
        @Override
        public Object handle(@NotNull World world, @NotNull BlockPos pos, @NotNull IBlockState blockState, @Nullable AbstractEntityAIStructure<?> placer, boolean infiniteResources, boolean complete) {
            if (!(blockState.func_177230_c() instanceof BlockDoor)) {
                return IPlacementHandler.ActionProcessingResult.IGNORE;
            }
            if (placer != null && !infiniteResources) {
                ArrayList<ItemStack> itemList = new ArrayList<ItemStack>();
                itemList.add(placer.getTotalAmount(BlockUtils.getItemStackFromBlockState(blockState)));
                if (PlacementHandlers.checkForListInInvAndRequest(placer, itemList)) {
                    return IPlacementHandler.ActionProcessingResult.DENY;
                }
            }
            if (((BlockDoor.EnumDoorHalf)blockState.func_177229_b((IProperty)BlockDoor.field_176523_O)).equals((Object)BlockDoor.EnumDoorHalf.LOWER)) {
                if (placer != null) {
                    placer.handleBuildingOverBlock(pos);
                }
                ItemDoor.func_179235_a((World)world, (BlockPos)pos, (EnumFacing)((EnumFacing)blockState.func_177229_b((IProperty)BlockDoor.field_176520_a)), (Block)blockState.func_177230_c(), (boolean)false);
            }
            return blockState;
        }
    }

    public static class GrassPlacementHandler
    implements IPlacementHandler {
        @Override
        public Object handle(@NotNull World world, @NotNull BlockPos pos, @NotNull IBlockState blockState, @Nullable AbstractEntityAIStructure<?> placer, boolean infiniteResources, boolean complete) {
            if (blockState.func_177230_c() != Blocks.field_150349_c) {
                return IPlacementHandler.ActionProcessingResult.IGNORE;
            }
            if (placer != null && !infiniteResources) {
                ArrayList<ItemStack> itemList = new ArrayList<ItemStack>();
                itemList.add(placer.getTotalAmount(placer.getTotalAmount(new ItemStack(Blocks.field_150346_d))));
                if (PlacementHandlers.checkForListInInvAndRequest(placer, itemList)) {
                    return IPlacementHandler.ActionProcessingResult.DENY;
                }
                placer.handleBuildingOverBlock(pos);
                if (!world.func_180501_a(pos, Blocks.field_150346_d.func_176223_P(), 3)) {
                    return IPlacementHandler.ActionProcessingResult.DENY;
                }
            } else if (!world.func_180501_a(pos, Blocks.field_150349_c.func_176223_P(), 3)) {
                return IPlacementHandler.ActionProcessingResult.DENY;
            }
            return Blocks.field_150346_d.func_176223_P();
        }
    }

    public static class FireplacementHandler
    implements IPlacementHandler {
        @Override
        public Object handle(@NotNull World world, @NotNull BlockPos pos, @NotNull IBlockState blockState, @Nullable AbstractEntityAIStructure<?> placer, boolean infiniteResources, boolean complete) {
            if (!(blockState.func_177230_c() instanceof BlockFire)) {
                return IPlacementHandler.ActionProcessingResult.IGNORE;
            }
            if (placer != null) {
                if (!infiniteResources) {
                    ItemStack item;
                    EntityCitizen citizen = placer.getWorker();
                    int slot = InventoryUtils.findFirstSlotInItemHandlerNotEmptyWith((IItemHandler)new InvWrapper((IInventory)citizen.getInventoryCitizen()), s -> s.func_77973_b() == Items.field_151033_d);
                    if (slot == -1) {
                        ItemStack tool = new ItemStack(Items.field_151033_d, 1);
                        List<ItemStack> foundStacks = InventoryUtils.filterItemHandler((IItemHandler)new InvWrapper((IInventory)placer.getWorker().getInventoryCitizen()), arg_0 -> ((ItemStack)tool).func_185136_b(arg_0));
                        if (foundStacks.isEmpty()) {
                            if (citizen.getWorkBuilding().getOpenRequestsOfTypeFiltered(citizen.getCitizenData(), TypeToken.of(Stack.class), s -> ((Stack)s.getRequest()).getStack().func_77973_b() == Items.field_151033_d).isEmpty()) {
                                Stack stack = new Stack(new ItemStack(Items.field_151033_d, 1)).setMatchMeta(false).setMatchNBT(false);
                                placer.getWorker().getCitizenData().createRequest(stack);
                            }
                            return IPlacementHandler.ActionProcessingResult.DENY;
                        }
                    }
                    ItemStack itemStack = item = slot == -1 ? ItemStackUtils.EMPTY : citizen.getInventoryCitizen().func_70301_a(slot);
                    if (ItemStackUtils.isEmpty(item).booleanValue() || !(item.func_77973_b() instanceof ItemFlintAndSteel)) {
                        return IPlacementHandler.ActionProcessingResult.DENY;
                    }
                    citizen.func_184201_a(EntityEquipmentSlot.MAINHAND, item);
                    item.func_77972_a(1, (EntityLivingBase)citizen);
                }
                placer.handleBuildingOverBlock(pos);
            }
            world.func_180501_a(pos, blockState, 3);
            return IPlacementHandler.ActionProcessingResult.ACCEPT;
        }
    }
}

