/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages;

import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.Log;
import com.minecolonies.coremod.colony.CitizenData;
import com.minecolonies.coremod.colony.CitizenDataView;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.ColonyManager;
import com.minecolonies.coremod.entity.EntityCitizen;
import com.minecolonies.coremod.network.messages.AbstractMessage;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;

public class TransferItemsToCitizenRequestMessage
extends AbstractMessage<TransferItemsToCitizenRequestMessage, IMessage> {
    private int citizenId;
    private int colonyId;
    private ItemStack itemStack;
    private int quantity;

    public TransferItemsToCitizenRequestMessage() {
    }

    public TransferItemsToCitizenRequestMessage(@NotNull CitizenDataView citizenDataView, ItemStack itemStack, int quantity, int colonyId) {
        this.colonyId = colonyId;
        this.citizenId = citizenDataView.getId();
        this.itemStack = itemStack;
        this.quantity = quantity;
    }

    public void fromBytes(@NotNull ByteBuf buf) {
        this.colonyId = buf.readInt();
        this.citizenId = buf.readInt();
        this.itemStack = ByteBufUtils.readItemStack((ByteBuf)buf);
        this.quantity = buf.readInt();
    }

    public void toBytes(@NotNull ByteBuf buf) {
        buf.writeInt(this.colonyId);
        buf.writeInt(this.citizenId);
        ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)this.itemStack);
        buf.writeInt(this.quantity);
    }

    @Override
    public void messageOnServerThread(TransferItemsToCitizenRequestMessage message, EntityPlayerMP player) {
        Colony colony = ColonyManager.getColony(message.colonyId);
        if (colony == null) {
            Log.getLogger().warn("TransferItemsRequestMessage colony is null");
            return;
        }
        CitizenData citizenData = colony.getCitizenManager().getCitizen(message.citizenId);
        if (citizenData == null) {
            Log.getLogger().warn("TransferItemsRequestMessage citizenData is null");
            return;
        }
        EntityCitizen citizen = citizenData.getCitizenEntity();
        if (citizen == null) {
            Log.getLogger().warn("TransferItemsRequestMessage entity citizen is null");
            return;
        }
        boolean isCreative = player.field_71075_bZ.field_75098_d;
        if (message.quantity <= 0 && !isCreative) {
            Log.getLogger().warn("TransferItemsRequestMessage quantity below 0");
            return;
        }
        Item item = message.itemStack.func_77973_b();
        int amountToTake = isCreative ? message.quantity : Math.min(message.quantity, InventoryUtils.getItemCountInItemHandler((IItemHandler)new InvWrapper((IInventory)player.field_71071_by), item, message.itemStack.func_77952_i()));
        ItemStack itemStackToTake = message.itemStack.func_77946_l();
        ItemStackUtils.setSize(itemStackToTake, message.quantity);
        ItemStack remainingItemStack = InventoryUtils.addItemStackToItemHandlerWithResult((IItemHandler)new InvWrapper((IInventory)citizen.getInventoryCitizen()), itemStackToTake);
        if (!isCreative) {
            ItemStack itemsTaken;
            for (int amountToRemoveFromPlayer = amountToTake - ItemStackUtils.getSize(remainingItemStack); amountToRemoveFromPlayer > 0; amountToRemoveFromPlayer -= ItemStackUtils.getSize(itemsTaken)) {
                int slot = InventoryUtils.findFirstSlotInItemHandlerWith((IItemHandler)new InvWrapper((IInventory)player.field_71071_by), item, message.itemStack.func_77952_i());
                itemsTaken = player.field_71071_by.func_70298_a(slot, amountToRemoveFromPlayer);
            }
        }
    }
}

