/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages;

import com.minecolonies.api.configuration.Configurations;
import com.minecolonies.api.util.Log;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.colony.Structures;
import com.minecolonies.coremod.util.ClientStructureWrapper;
import com.minecolonies.structures.helpers.Structure;
import io.netty.buffer.ByteBuf;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SchematicSaveMessage
implements IMessage,
IMessageHandler<SchematicSaveMessage, IMessage> {
    private static final int MAX_TOTAL_SIZE = Short.MAX_VALUE;
    private byte[] data = null;

    public SchematicSaveMessage() {
    }

    public SchematicSaveMessage(byte[] data) {
        this.data = (byte[])data.clone();
    }

    public void fromBytes(@NotNull ByteBuf buf) {
        int length = buf.readInt();
        byte[] compressedData = new byte[length];
        buf.readBytes(compressedData);
        this.data = Structure.uncompress(compressedData);
    }

    public void toBytes(@NotNull ByteBuf buf) {
        byte[] compressedData = Structure.compress(this.data);
        if (compressedData != null) {
            buf.capacity(compressedData.length + buf.writerIndex());
            int maxSize = 32763;
            if (compressedData.length > 32763) {
                buf.writeInt(0);
                if (MineColonies.isClient()) {
                    ClientStructureWrapper.sendMessageSchematicTooBig(32763);
                } else {
                    Log.getLogger().error("SchematicSaveMessage: schematic size too big, can not be bigger than 32763 bytes");
                }
            } else {
                buf.writeInt(compressedData.length);
                buf.writeBytes(compressedData);
            }
        }
    }

    @Nullable
    public IMessage onMessage(@NotNull SchematicSaveMessage message, MessageContext ctx) {
        boolean schematicSent;
        if (!MineColonies.isClient() && !Configurations.Gameplay.allowPlayerSchematics) {
            Log.getLogger().info("SchematicSaveMessage: custom schematic is not allowed on this server.");
            if (ctx.side.isServer()) {
                ctx.getServerHandler().field_147369_b.func_145747_a((ITextComponent)new TextComponentString("The server does not allow custom schematic!"));
            }
            return null;
        }
        if (message.data == null) {
            Log.getLogger().error("Received empty schematic file");
            schematicSent = false;
        } else {
            schematicSent = Structures.handleSaveSchematicMessage(message.data);
        }
        if (ctx.side.isServer()) {
            if (schematicSent) {
                ctx.getServerHandler().field_147369_b.func_145747_a((ITextComponent)new TextComponentString("Schematic successfully sent!"));
            } else {
                ctx.getServerHandler().field_147369_b.func_145747_a((ITextComponent)new TextComponentString("Failed to send the Schematic!"));
            }
        }
        return null;
    }
}

