/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages;

import com.minecolonies.api.util.Log;
import com.minecolonies.coremod.util.ClientStructureWrapper;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import java.io.DataInput;
import java.io.IOException;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTSizeTracker;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SaveScanMessage
implements IMessage,
IMessageHandler<SaveScanMessage, IMessage> {
    private NBTTagCompound nbttagcompound;
    private long currentMillis;

    public SaveScanMessage() {
    }

    public SaveScanMessage(NBTTagCompound nbttagcompound, long currentMillis) {
        this.currentMillis = currentMillis;
        this.nbttagcompound = nbttagcompound;
    }

    public void fromBytes(@NotNull ByteBuf buf) {
        PacketBuffer buffer = new PacketBuffer(buf);
        int i = buffer.readerIndex();
        byte b0 = buffer.readByte();
        if (b0 != 0) {
            buffer.readerIndex(i);
            try (ByteBufInputStream stream = new ByteBufInputStream((ByteBuf)buffer);){
                this.nbttagcompound = CompressedStreamTools.func_152456_a((DataInput)stream, (NBTSizeTracker)NBTSizeTracker.field_152451_a);
            }
            catch (RuntimeException e) {
                Log.getLogger().info("Structure too big to be processed", (Throwable)e);
            }
            catch (IOException e) {
                Log.getLogger().info("Problem at retrieving structure on server.", (Throwable)e);
            }
        }
        this.currentMillis = buf.readLong();
    }

    public void toBytes(@NotNull ByteBuf buf) {
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.nbttagcompound);
        buf.writeLong(this.currentMillis);
    }

    @Nullable
    public IMessage onMessage(@NotNull SaveScanMessage message, MessageContext ctx) {
        if (message.nbttagcompound != null) {
            ClientStructureWrapper.handleSaveScanMessage(message.nbttagcompound, message.currentMillis);
        }
        return null;
    }
}

