/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages;

import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.LanguageHandler;
import com.minecolonies.api.util.Log;
import com.minecolonies.coremod.colony.CitizenData;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.ColonyManager;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingWorker;
import com.minecolonies.coremod.entity.EntityCitizen;
import com.minecolonies.coremod.network.messages.AbstractMessage;
import com.minecolonies.coremod.util.TeleportHelper;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.jetbrains.annotations.NotNull;

public class RecallCitizenMessage
extends AbstractMessage<RecallCitizenMessage, IMessage> {
    private int colonyId;
    private BlockPos buildingId;

    public RecallCitizenMessage() {
    }

    public RecallCitizenMessage(@NotNull AbstractBuildingWorker.View building) {
        this.colonyId = building.getColony().getID();
        this.buildingId = building.getID();
    }

    public void fromBytes(@NotNull ByteBuf buf) {
        this.colonyId = buf.readInt();
        this.buildingId = BlockPosUtil.readFromByteBuf(buf);
    }

    public void toBytes(@NotNull ByteBuf buf) {
        buf.writeInt(this.colonyId);
        BlockPosUtil.writeToByteBuf(buf, this.buildingId);
    }

    @Override
    public void messageOnServerThread(RecallCitizenMessage message, EntityPlayerMP player) {
        Colony colony = ColonyManager.getColony(message.colonyId);
        if (colony != null) {
            if (!colony.getPermissions().hasPermission((EntityPlayer)player, Action.MANAGE_HUTS)) {
                return;
            }
            AbstractBuildingWorker building = colony.getBuildingManager().getBuilding(message.buildingId, AbstractBuildingWorker.class);
            if (building != null) {
                for (int i = 0; i < building.getWorkerEntities().size(); ++i) {
                    EntityCitizen citizen = building.getWorkerEntities().get(i);
                    if (citizen == null) {
                        CitizenData citizenData = building.getWorker().get(i);
                        if (citizenData != null) {
                            Log.getLogger().warn(String.format("Citizen #%d:%d has gone AWOL, respawning them!", colony.getID(), citizenData.getId()));
                            colony.getCitizenManager().spawnCitizen(citizenData, colony.getWorld());
                            citizen = citizenData.getCitizenEntity();
                        } else {
                            Log.getLogger().warn("Citizen is AWOL and citizenData is null!");
                            return;
                        }
                    }
                    BlockPos loc = building.getLocation();
                    if (TeleportHelper.teleportCitizen(citizen, colony.getWorld(), loc)) continue;
                    LanguageHandler.sendPlayerMessage((EntityPlayer)player, "com.minecolonies.coremod.workerHuts.recallFail", new Object[0]);
                }
            }
        }
    }
}

