/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages;

import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.CompatibilityUtils;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.ColonyManager;
import com.minecolonies.coremod.entity.EntityCitizen;
import com.minecolonies.coremod.inventory.GuiHandler;
import com.minecolonies.coremod.network.messages.AbstractMessage;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.StringUtils;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.jetbrains.annotations.NotNull;

public class OpenInventoryMessage
extends AbstractMessage<OpenInventoryMessage, IMessage> {
    private String name;
    private InventoryType inventoryType;
    private int entityID;
    private BlockPos tePos;
    private int colonyId;

    public OpenInventoryMessage() {
    }

    public OpenInventoryMessage(@NotNull String name, @NotNull int id) {
        this.inventoryType = InventoryType.INVENTORY_CITIZEN;
        this.name = name;
        this.entityID = id;
    }

    public OpenInventoryMessage(@NotNull BlockPos pos) {
        this.inventoryType = InventoryType.INVENTORY_CHEST;
        this.name = "";
        this.tePos = pos;
    }

    public OpenInventoryMessage(BlockPos field, int colonyId) {
        this.inventoryType = InventoryType.INVENTORY_FIELD;
        this.name = "field";
        this.tePos = field;
        this.colonyId = colonyId;
    }

    public void fromBytes(@NotNull ByteBuf buf) {
        this.inventoryType = InventoryType.values()[buf.readInt()];
        this.name = ByteBufUtils.readUTF8String((ByteBuf)buf);
        switch (this.inventoryType) {
            case INVENTORY_CITIZEN: {
                this.entityID = buf.readInt();
                break;
            }
            case INVENTORY_CHEST: {
                this.tePos = BlockPosUtil.readFromByteBuf(buf);
                break;
            }
            case INVENTORY_FIELD: {
                this.colonyId = buf.readInt();
                this.tePos = BlockPosUtil.readFromByteBuf(buf);
            }
        }
    }

    public void toBytes(@NotNull ByteBuf buf) {
        buf.writeInt(this.inventoryType.ordinal());
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.name);
        switch (this.inventoryType) {
            case INVENTORY_CITIZEN: {
                buf.writeInt(this.entityID);
                break;
            }
            case INVENTORY_CHEST: {
                BlockPosUtil.writeToByteBuf(buf, this.tePos);
                break;
            }
            case INVENTORY_FIELD: {
                buf.writeInt(this.colonyId);
                BlockPosUtil.writeToByteBuf(buf, this.tePos);
            }
        }
    }

    @Override
    public void messageOnServerThread(OpenInventoryMessage message, EntityPlayerMP player) {
        switch (message.inventoryType) {
            case INVENTORY_CITIZEN: {
                OpenInventoryMessage.doCitizenInventory(message, player);
                break;
            }
            case INVENTORY_CHEST: {
                OpenInventoryMessage.doHutInventory(message, player);
                break;
            }
            case INVENTORY_FIELD: {
                OpenInventoryMessage.doFieldInventory(message, player);
                break;
            }
        }
    }

    private static void doCitizenInventory(OpenInventoryMessage message, EntityPlayerMP player) {
        EntityCitizen citizen = (EntityCitizen)CompatibilityUtils.getWorld((Entity)player).func_73045_a(message.entityID);
        if (citizen != null && OpenInventoryMessage.checkPermissions(citizen.getColony(), player)) {
            if (!StringUtils.func_151246_b((String)message.name)) {
                citizen.getInventoryCitizen().setCustomName(message.name);
            }
            player.openGui((Object)MineColonies.instance, GuiHandler.ID.CITIZEN_INVENTORY.ordinal(), player.field_70170_p, citizen.getColony().getID(), citizen.getCitizenData().getId(), 0);
        }
    }

    private static void doHutInventory(OpenInventoryMessage message, EntityPlayerMP player) {
        if (OpenInventoryMessage.checkPermissions(ColonyManager.getClosestColony(player.func_130014_f_(), message.tePos), player)) {
            TileEntityChest chest = (TileEntityChest)BlockPosUtil.getTileEntity(CompatibilityUtils.getWorld((Entity)player), message.tePos);
            if (!StringUtils.func_151246_b((String)message.name)) {
                chest.func_145976_a(message.name);
            }
            player.openGui((Object)MineColonies.instance, GuiHandler.ID.BUILDING_INVENTORY.ordinal(), player.field_70170_p, chest.func_174877_v().func_177958_n(), chest.func_174877_v().func_177956_o(), chest.func_174877_v().func_177952_p());
        }
    }

    private static void doFieldInventory(OpenInventoryMessage message, EntityPlayerMP player) {
        if (OpenInventoryMessage.checkPermissions(ColonyManager.getClosestColony(player.func_130014_f_(), message.tePos), player)) {
            if (!StringUtils.func_151246_b((String)message.name)) {
                // empty if block
            }
            player.openGui((Object)MineColonies.instance, GuiHandler.ID.BUILDING_INVENTORY.ordinal(), player.func_130014_f_(), player.func_180425_c().func_177958_n(), player.func_180425_c().func_177956_o(), player.func_180425_c().func_177952_p());
        }
    }

    private static boolean checkPermissions(Colony colony, EntityPlayerMP player) {
        return colony.getPermissions().hasPermission((EntityPlayer)player, Action.MANAGE_HUTS);
    }

    private static enum InventoryType {
        INVENTORY_CITIZEN,
        INVENTORY_CHEST,
        INVENTORY_FIELD;

    }
}

