/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages;

import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.ColonyManager;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingGuards;
import com.minecolonies.coremod.network.messages.AbstractMessage;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.jetbrains.annotations.NotNull;

public class GuardTaskMessage
extends AbstractMessage<GuardTaskMessage, IMessage> {
    private int colonyId;
    private BlockPos buildingId;
    private int job;
    private boolean assignmentMode;
    private boolean patrollingMode;
    private boolean retrieval;
    private int task;

    public GuardTaskMessage() {
    }

    public GuardTaskMessage(@NotNull AbstractBuildingGuards.View building, int job, boolean assignmentMode, boolean patrollingMode, boolean retrieval, int task) {
        this.colonyId = building.getColony().getID();
        this.buildingId = building.getID();
        this.job = job;
        this.assignmentMode = assignmentMode;
        this.patrollingMode = patrollingMode;
        this.retrieval = retrieval;
        this.task = task;
    }

    public void fromBytes(@NotNull ByteBuf buf) {
        this.colonyId = buf.readInt();
        this.buildingId = BlockPosUtil.readFromByteBuf(buf);
        this.job = buf.readInt();
        this.assignmentMode = buf.readBoolean();
        this.patrollingMode = buf.readBoolean();
        this.retrieval = buf.readBoolean();
        this.task = buf.readInt();
    }

    public void toBytes(@NotNull ByteBuf buf) {
        buf.writeInt(this.colonyId);
        BlockPosUtil.writeToByteBuf(buf, this.buildingId);
        buf.writeInt(this.job);
        buf.writeBoolean(this.assignmentMode);
        buf.writeBoolean(this.patrollingMode);
        buf.writeBoolean(this.retrieval);
        buf.writeInt(this.task);
    }

    @Override
    public void messageOnServerThread(GuardTaskMessage message, EntityPlayerMP player) {
        Colony colony = ColonyManager.getColony(message.colonyId);
        if (colony != null) {
            if (!colony.getPermissions().hasPermission((EntityPlayer)player, Action.MANAGE_HUTS)) {
                return;
            }
            AbstractBuildingGuards building = colony.getBuildingManager().getBuilding(message.buildingId, AbstractBuildingGuards.class);
            if (building != null) {
                if (message.job != -1) {
                    building.setJob(AbstractBuildingGuards.GuardJob.values()[message.job]);
                }
                building.setAssignManually(message.assignmentMode);
                building.setPatrolManually(message.patrollingMode);
                building.setRetrieveOnLowHealth(message.retrieval);
                building.setTask(AbstractBuildingGuards.Task.values()[message.task]);
                if (building.getTask().equals((Object)AbstractBuildingGuards.Task.FOLLOW)) {
                    building.setPlayerToFollow((EntityPlayer)player);
                }
            }
        }
    }
}

