/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages;

import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.coremod.colony.ColonyManager;
import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ColonyViewBuildingViewMessage
implements IMessage,
IMessageHandler<ColonyViewBuildingViewMessage, IMessage> {
    private int colonyId;
    private BlockPos buildingId;
    private ByteBuf buildingData;

    public ColonyViewBuildingViewMessage() {
    }

    public ColonyViewBuildingViewMessage(@NotNull AbstractBuilding building) {
        this.colonyId = building.getColony().getID();
        this.buildingId = building.getID();
        this.buildingData = Unpooled.buffer();
        building.serializeToView(this.buildingData);
    }

    public void fromBytes(@NotNull ByteBuf buf) {
        this.colonyId = buf.readInt();
        this.buildingId = BlockPosUtil.readFromByteBuf(buf);
        this.buildingData = Unpooled.buffer((int)buf.readableBytes());
        buf.readBytes(this.buildingData, buf.readableBytes());
    }

    public void toBytes(@NotNull ByteBuf buf) {
        buf.writeInt(this.colonyId);
        BlockPosUtil.writeToByteBuf(buf, this.buildingId);
        buf.writeBytes(this.buildingData);
    }

    @Nullable
    public IMessage onMessage(@NotNull ColonyViewBuildingViewMessage message, MessageContext ctx) {
        return ColonyManager.handleColonyBuildingViewMessage(message.colonyId, message.buildingId, message.buildingData);
    }
}

