/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages;

import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.LanguageHandler;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.ColonyManager;
import com.minecolonies.coremod.colony.ColonyView;
import com.minecolonies.coremod.network.messages.AbstractMessage;
import io.netty.buffer.ByteBuf;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.jetbrains.annotations.NotNull;

public class ChangeFreeToInteractBlockMessage
extends AbstractMessage<ChangeFreeToInteractBlockMessage, IMessage> {
    private int colonyId;
    private BlockPos pos = new BlockPos(0, 0, 0);
    private Block block = Blocks.field_150346_d;
    private MessageType type;
    private MessageMode mode;

    public ChangeFreeToInteractBlockMessage() {
    }

    public ChangeFreeToInteractBlockMessage(@NotNull ColonyView colony, @NotNull Block block, @NotNull MessageType type) {
        this.colonyId = colony.getID();
        this.pos = new BlockPos(0, 0, 0);
        this.block = block;
        this.type = type;
        this.mode = MessageMode.BLOCK;
    }

    public ChangeFreeToInteractBlockMessage(@NotNull ColonyView colony, @NotNull BlockPos pos, @NotNull MessageType type) {
        this.colonyId = colony.getID();
        this.pos = pos;
        this.block = Blocks.field_150346_d;
        this.type = type;
        this.mode = MessageMode.LOCATION;
    }

    public void fromBytes(@NotNull ByteBuf buf) {
        this.colonyId = buf.readInt();
        this.block = Block.func_149684_b((String)ByteBufUtils.readUTF8String((ByteBuf)buf));
        this.pos = BlockPosUtil.readFromByteBuf(buf);
        this.type = MessageType.values()[buf.readInt()];
        this.mode = MessageMode.values()[buf.readInt()];
    }

    public void toBytes(@NotNull ByteBuf buf) {
        buf.writeInt(this.colonyId);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.block.getRegistryName().toString());
        BlockPosUtil.writeToByteBuf(buf, this.pos);
        buf.writeInt(this.type.ordinal());
        buf.writeInt(this.mode.ordinal());
    }

    @Override
    public void messageOnServerThread(ChangeFreeToInteractBlockMessage message, EntityPlayerMP player) {
        Colony colony = ColonyManager.getColony(message.colonyId);
        if (colony != null) {
            if (!colony.getPermissions().hasPermission((EntityPlayer)player, Action.EDIT_PERMISSIONS)) {
                LanguageHandler.sendPlayerMessage((EntityPlayer)player, "com.minecolonies.coremod.item.permissionscepter.permission.deny", new Object[0]);
                return;
            }
            if (message.type == MessageType.ADD_BLOCK) {
                switch (message.mode) {
                    case LOCATION: {
                        colony.addFreePosition(message.pos);
                        LanguageHandler.sendPlayerMessage((EntityPlayer)player, "com.minecolonies.coremod.item.permissionscepter.addposition.success", message.pos.func_177958_n(), message.pos.func_177956_o(), message.pos.func_177952_p());
                        break;
                    }
                    case BLOCK: {
                        colony.addFreeBlock(message.block);
                        LanguageHandler.sendPlayerMessage((EntityPlayer)player, "com.minecolonies.coremod.item.permissionscepter.addblock.success", message.block.getRegistryName());
                        break;
                    }
                }
            } else {
                switch (message.mode) {
                    case LOCATION: {
                        colony.removeFreePosition(message.pos);
                        LanguageHandler.sendPlayerMessage((EntityPlayer)player, "com.minecolonies.coremod.item.permissionscepter.removelocation.success", message.pos.func_177958_n(), message.pos.func_177956_o(), message.pos.func_177952_p());
                        break;
                    }
                    case BLOCK: {
                        colony.removeFreeBlock(message.block);
                        LanguageHandler.sendPlayerMessage((EntityPlayer)player, "com.minecolonies.coremod.item.permissionscepter.removeblock.success", message.block.getRegistryName());
                        break;
                    }
                }
            }
        }
    }

    public static enum MessageMode {
        LOCATION,
        BLOCK;

    }

    public static enum MessageType {
        REMOVE_BLOCK,
        ADD_BLOCK;

    }
}

