/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages;

import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.api.configuration.Configurations;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.BlockUtils;
import com.minecolonies.api.util.CompatibilityUtils;
import com.minecolonies.api.util.LanguageHandler;
import com.minecolonies.api.util.Log;
import com.minecolonies.coremod.blocks.AbstractBlockHut;
import com.minecolonies.coremod.blocks.BlockHutTownHall;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.ColonyManager;
import com.minecolonies.coremod.colony.StructureName;
import com.minecolonies.coremod.colony.Structures;
import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import com.minecolonies.coremod.colony.workorders.WorkOrderBuildDecoration;
import com.minecolonies.coremod.event.EventHandler;
import com.minecolonies.coremod.network.messages.AbstractMessage;
import io.netty.buffer.ByteBuf;
import java.util.Locale;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAir;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Mirror;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.jetbrains.annotations.NotNull;

public class BuildToolPlaceMessage
extends AbstractMessage<BuildToolPlaceMessage, IMessage> {
    private static final String NO_HUT_IN_INVENTORY = "com.minecolonies.coremod.gui.buildtool.nohutininventory";
    private String structureName;
    private String workOrderName;
    private int rotation;
    private BlockPos pos;
    private boolean isHut;
    private boolean mirror;

    public BuildToolPlaceMessage() {
    }

    public BuildToolPlaceMessage(String structureName, String workOrderName, BlockPos pos, int rotation, boolean isHut, Mirror mirror) {
        this.structureName = structureName;
        this.workOrderName = workOrderName;
        this.pos = pos;
        this.rotation = rotation;
        this.isHut = isHut;
        this.mirror = mirror == Mirror.FRONT_BACK;
    }

    public void fromBytes(@NotNull ByteBuf buf) {
        this.structureName = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.workOrderName = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.pos = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
        this.rotation = buf.readInt();
        this.isHut = buf.readBoolean();
        this.mirror = buf.readBoolean();
    }

    public void toBytes(@NotNull ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.structureName);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.workOrderName);
        buf.writeInt(this.pos.func_177958_n());
        buf.writeInt(this.pos.func_177956_o());
        buf.writeInt(this.pos.func_177952_p());
        buf.writeInt(this.rotation);
        buf.writeBoolean(this.isHut);
        buf.writeBoolean(this.mirror);
    }

    @Override
    public void messageOnServerThread(BuildToolPlaceMessage message, EntityPlayerMP player) {
        StructureName sn = new StructureName(message.structureName);
        if (!Structures.hasMD5(sn)) {
            player.func_145747_a((ITextComponent)new TextComponentString("Can not build " + message.workOrderName + ": schematic missing!"));
            return;
        }
        if (message.isHut) {
            BuildToolPlaceMessage.handleHut(CompatibilityUtils.getWorld((Entity)player), (EntityPlayer)player, sn, message.rotation, message.pos, message.mirror);
        } else {
            BuildToolPlaceMessage.handleDecoration(CompatibilityUtils.getWorld((Entity)player), (EntityPlayer)player, sn, message.workOrderName, message.rotation, message.pos, message.mirror);
        }
    }

    private static void handleHut(@NotNull World world, @NotNull EntityPlayer player, StructureName sn, int rotation, @NotNull BlockPos buildPos, boolean mirror) {
        String hut = sn.getSection();
        Block block = Block.func_149684_b((String)("minecolonies:blockHut" + hut));
        Colony tempColony = ColonyManager.getClosestColony(world, buildPos);
        if (!(tempColony == null || tempColony.getPermissions().hasPermission(player, Action.MANAGE_HUTS) || block instanceof BlockHutTownHall && BlockPosUtil.getDistance2D(tempColony.getCenter(), buildPos) >= (long)(Configurations.Gameplay.workingRangeTownHall * 2 + Configurations.Gameplay.townHallPadding))) {
            return;
        }
        if (block instanceof BlockAir) {
            block = Block.func_149684_b((String)("minecolonies" + (":blockHut" + hut).toLowerCase(Locale.ENGLISH)));
        }
        if (block != null && player.field_71071_by.func_70431_c(new ItemStack(block))) {
            if (EventHandler.onBlockHutPlaced(world, player, block, buildPos)) {
                world.func_175655_b(buildPos, true);
                world.func_175656_a(buildPos, block.func_176223_P().func_185907_a(BlockUtils.getRotation(rotation)));
                ((AbstractBlockHut)block).onBlockPlacedByBuildTool(world, buildPos, world.func_180495_p(buildPos), (EntityLivingBase)player, null, mirror, sn.getStyle());
                player.field_71071_by.func_174925_a(Item.func_150898_a((Block)block), -1, 1, null);
                BuildToolPlaceMessage.setupBuilding(world, player, sn, rotation, buildPos, mirror);
            }
        } else {
            LanguageHandler.sendPlayerMessage(player, NO_HUT_IN_INVENTORY, new Object[0]);
        }
    }

    private static void handleDecoration(@NotNull World world, @NotNull EntityPlayer player, StructureName sn, String workOrderName, int rotation, @NotNull BlockPos buildPos, boolean mirror) {
        Colony colony = ColonyManager.getColony(world, buildPos);
        if (colony != null && colony.getPermissions().hasPermission(player, Action.PLACE_HUTS)) {
            colony.getWorkManager().addWorkOrder(new WorkOrderBuildDecoration(sn.toString(), workOrderName, rotation, buildPos, mirror));
        } else {
            Log.getLogger().error("handleDecoration: Could not build " + sn);
        }
    }

    private static void setupBuilding(@NotNull World world, @NotNull EntityPlayer player, StructureName sn, int rotation, @NotNull BlockPos buildPos, boolean mirror) {
        AbstractBuilding building = ColonyManager.getBuilding(world, buildPos);
        if (building == null) {
            Log.getLogger().error("BuildTool: building is null!");
        } else {
            if (building.getTileEntity() != null) {
                Colony colony = ColonyManager.getColony(world, buildPos);
                if (colony == null) {
                    Log.getLogger().info("No colony for " + player.func_70005_c_());
                } else {
                    building.getTileEntity().setColony(colony);
                }
            }
            building.setStyle(sn.getStyle());
            building.setRotation(rotation);
            if (mirror) {
                building.setMirror();
            }
        }
    }
}

