/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.items;

import com.minecolonies.api.util.BlockUtils;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.client.gui.WindowBuildTool;
import com.minecolonies.coremod.colony.ColonyManager;
import com.minecolonies.coremod.creativetab.ModCreativeTabs;
import com.minecolonies.coremod.items.AbstractItemMinecolonies;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemSupplyChestDeployer
extends AbstractItemMinecolonies {
    private static final String SUPPLY_SHIP_STRUCTURE_NAME = "schematics/SupplyShip";
    private static final int OFFSET_DISTANCE = 14;
    private static final int OFFSET_LEFT = 5;
    private static final int OFFSET_Y = -2;
    private static final int SCAN_HEIGHT = 7;

    public ItemSupplyChestDeployer() {
        super("supplyChestDeployer");
        super.func_77637_a(ModCreativeTabs.MINECOLONIES);
        this.func_77625_d(1);
    }

    public EnumActionResult func_180614_a(ItemStack stack, EntityPlayer playerIn, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (worldIn.field_72995_K) {
            this.placeSupplyShip(pos, playerIn.func_174811_aO());
        }
        return EnumActionResult.FAIL;
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack itemStackIn, World worldIn, EntityPlayer playerIn, EnumHand hand) {
        ItemStack stack = playerIn.func_184586_b(hand);
        if (worldIn.field_72995_K) {
            this.placeSupplyShip(null, playerIn.func_174811_aO());
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)stack);
    }

    private void placeSupplyShip(@Nullable BlockPos pos, @NotNull EnumFacing direction) {
        int rotations;
        BlockPos tempPos;
        if (pos == null) {
            MineColonies.proxy.openBuildToolWindow(null, SUPPLY_SHIP_STRUCTURE_NAME, 0, null);
            return;
        }
        switch (direction) {
            case SOUTH: {
                tempPos = pos.func_177982_a(5, -2, 14);
                rotations = 3;
                break;
            }
            case NORTH: {
                tempPos = pos.func_177982_a(-5, -2, -14);
                rotations = 1;
                break;
            }
            case EAST: {
                tempPos = pos.func_177982_a(14, -2, -5);
                rotations = 2;
                break;
            }
            default: {
                tempPos = pos.func_177982_a(-14, -2, 5);
                rotations = 0;
            }
        }
        MineColonies.proxy.openBuildToolWindow(tempPos, SUPPLY_SHIP_STRUCTURE_NAME, rotations, WindowBuildTool.FreeMode.SUPPLYSHIP);
    }

    @NotNull
    public static boolean canShipBePlaced(@NotNull World world, @NotNull BlockPos pos, BlockPos size) {
        int x;
        int z;
        for (z = pos.func_177952_p() - size.func_177952_p() / 2 + 1; z < pos.func_177952_p() + size.func_177952_p() / 2 + 1; ++z) {
            for (x = pos.func_177958_n() - size.func_177958_n() / 2 + 1; x < pos.func_177958_n() + size.func_177958_n() / 2 + 1; ++x) {
                if (ItemSupplyChestDeployer.checkIfWaterAndNotInColony(world, new BlockPos(x, pos.func_177956_o() + 2, z))) continue;
                return false;
            }
        }
        for (z = pos.func_177952_p() - size.func_177952_p() / 2 + 1; z < pos.func_177952_p() + size.func_177952_p() / 2 + 1; ++z) {
            for (x = pos.func_177958_n() - size.func_177958_n() / 2 + 1; x < pos.func_177958_n() + size.func_177958_n() / 2 + 1; ++x) {
                if (world.func_175623_d(new BlockPos(x, pos.func_177956_o() + 7, z))) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean checkIfWaterAndNotInColony(World world, BlockPos pos) {
        return BlockUtils.isWater(world.func_180495_p(pos)) && ItemSupplyChestDeployer.notInAnyColony(world, pos);
    }

    private static boolean notInAnyColony(World world, BlockPos pos) {
        return !ColonyManager.isCoordinateInAnyColony(world, pos);
    }
}

