/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.items;

import com.minecolonies.coremod.creativetab.ModCreativeTabs;
import com.minecolonies.coremod.entity.ai.mobs.barbarians.AbstractEntityBarbarian;
import com.minecolonies.coremod.entity.ai.mobs.util.BarbarianUtils;
import java.util.stream.Stream;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

public class ItemChiefSword
extends ItemSword {
    private static final String ITEM_NAME = "chiefsword";
    private static final Potion LEVITATION_EFFECT = Potion.func_188412_a((int)25);
    private static final Potion GLOW_EFFECT = Potion.func_188412_a((int)24);
    private static final int GLOW_EFFECT_DURATION = 30;
    private static final int GLOW_EFFECT_MULTIPLIER = 20;
    private static final int GLOW_EFFECT_DISTANCE = 30;
    private static final int LEVITATION_EFFECT_DURATION = 20;
    private static final int LEVITATION_EFFECT_MULTIPLIER = 3;

    public ItemChiefSword() {
        super(Item.ToolMaterial.GOLD);
        super.func_77655_b("minecolonies".toLowerCase() + "." + ITEM_NAME);
        this.setRegistryName(ITEM_NAME);
        super.func_77637_a(ModCreativeTabs.MINECOLONIES);
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (entityIn instanceof EntityPlayer && isSelected) {
            Stream barbarians = BarbarianUtils.getBarbariansCloseToEntity(entityIn, 30.0).stream();
            barbarians.forEach(entity -> entity.func_70690_d(new PotionEffect(GLOW_EFFECT, 30, 20)));
        }
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase target, @NotNull EntityLivingBase attacker) {
        if (attacker instanceof EntityPlayer && target instanceof AbstractEntityBarbarian) {
            target.func_70690_d(new PotionEffect(LEVITATION_EFFECT, 20, 3));
        }
        return super.func_77644_a(stack, target, attacker);
    }

    public final String getName() {
        return ITEM_NAME;
    }
}

