/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.inventory;

import com.minecolonies.coremod.inventory.ContainerRack;
import com.minecolonies.coremod.tileentities.TileEntityRack;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;

@SideOnly(value=Side.CLIENT)
public class GuiRack
extends GuiContainer {
    private static final ResourceLocation CHEST_GUI_TEXTURE = new ResourceLocation("minecolonies", "textures/gui/generic_108.png");
    private static final String LOCATION = "textures/gui/gui%s.png";
    private static final int SLOTS_EACH_ROW = 9;
    private static final int TEXTURE_SIZE = 350;
    private static final int SLOT_OFFSET = 18;
    private static final int GOOD_SIZE = 8;
    private static final int SIZE_MULTIPLIER = 3;
    private static final int Y_OFFSET = 114;
    private static final int TEXTURE_HEIGHT = 96;
    private static final int TEXTURE_OFFSET = 235;
    private static final int EXTRA_OFFSET = 56;
    private static final int EXTRA_HEIGHT = 50;
    private final IItemHandler jointChestInventory;
    private final int inventoryRows;

    public GuiRack(InventoryPlayer parInventoryPlayer, TileEntityRack tileEntity, TileEntityRack neighborRack, World world, BlockPos location) {
        super((Container)new ContainerRack(tileEntity, neighborRack, parInventoryPlayer));
        this.jointChestInventory = neighborRack != null ? (tileEntity.isMain() ? new CombinedInvWrapper(new IItemHandlerModifiable[]{tileEntity.getInventory(), neighborRack.getInventory()}) : new CombinedInvWrapper(new IItemHandlerModifiable[]{neighborRack.getInventory(), tileEntity.getInventory()})) : tileEntity.getInventory();
        this.inventoryRows = this.jointChestInventory.getSlots() / 9;
        this.field_146291_p = false;
        this.field_147000_g = 114 + Math.min(9, this.inventoryRows) * 18;
        if (this.inventoryRows > 8) {
            this.field_146999_f += (this.inventoryRows - 9) * 10;
        }
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(GuiRack.getCorrectTextureForSlots(this.inventoryRows));
        int i = (this.field_146294_l - this.field_146999_f) / 2;
        int j = (this.field_146295_m - this.field_147000_g) / 2;
        if (this.inventoryRows < 9) {
            GuiRack.func_146110_a((int)i, (int)j, (float)0.0f, (float)0.0f, (int)this.field_146999_f, (int)(this.inventoryRows * 18 + 18 - 1), (float)350.0f, (float)350.0f);
            GuiRack.func_146110_a((int)i, (int)(j + this.inventoryRows * 18 + 18 - 1), (float)0.0f, (float)235.0f, (int)this.field_146999_f, (int)96, (float)350.0f, (float)350.0f);
        } else {
            int textureOffset = 179;
            GuiRack.func_146110_a((int)i, (int)j, (float)0.0f, (float)0.0f, (int)(this.field_146999_f * 3 / 2), (int)(this.inventoryRows * 18 + 18 - 1), (float)350.0f, (float)350.0f);
            GuiRack.func_146110_a((int)i, (int)(j + Math.min(9, this.inventoryRows) * 18 + 18 - 1), (float)0.0f, (float)179.0f, (int)(this.field_146999_f * 3 / 2), (int)146, (float)350.0f, (float)350.0f);
        }
    }

    private static ResourceLocation getCorrectTextureForSlots(int inventoryRows) {
        if (inventoryRows <= 8) {
            return CHEST_GUI_TEXTURE;
        }
        return new ResourceLocation("minecolonies", String.format(LOCATION, Integer.toString(inventoryRows * 9)));
    }
}

