/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.inventory;

import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.coremod.tileentities.TileEntityRack;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.SlotItemHandler;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ContainerRack
extends Container {
    private final IItemHandler inventory;
    private final TileEntityRack rack;
    private final TileEntityRack neighborRack;
    private final int inventorySize;

    public ContainerRack(@NotNull TileEntityRack tileEntityRack, @Nullable TileEntityRack neighborRack, InventoryPlayer playerInventory) {
        int i;
        this.inventory = neighborRack != null ? (tileEntityRack.isMain() ? new CombinedInvWrapper(new IItemHandlerModifiable[]{tileEntityRack.getInventory(), neighborRack.getInventory()}) : new CombinedInvWrapper(new IItemHandlerModifiable[]{neighborRack.getInventory(), tileEntityRack.getInventory()})) : tileEntityRack.getInventory();
        this.rack = tileEntityRack;
        this.neighborRack = neighborRack;
        this.inventorySize = this.inventory.getSlots() / 9;
        int size = this.inventory.getSlots();
        int columns = this.inventorySize <= 8 ? 9 : size / 8 + 1;
        int extraOffset = this.inventorySize <= 8 ? 0 : 2;
        int index = 0;
        for (int j = 0; j < Math.min(this.inventorySize, 8); ++j) {
            for (int k = 0; k < columns; ++k) {
                if (index >= size) continue;
                this.func_75146_a((Slot)new SlotItemHandler(this.inventory, index, 8 + k * 18, 18 + j * 18));
                ++index;
            }
        }
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_75146_a(new Slot((IInventory)playerInventory, j + i * 9 + 9, 8 + j * 18, 30 + extraOffset + 18 * Math.min(this.inventorySize, 8) + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.func_75146_a(new Slot((IInventory)playerInventory, i, 8 + i * 18, 88 + extraOffset + 18 * Math.min(this.inventorySize, 8)));
        }
    }

    protected final Slot func_75146_a(Slot slotToAdd) {
        return super.func_75146_a(slotToAdd);
    }

    public ItemStack func_82846_b(EntityPlayer playerIn, int index) {
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot == null || !slot.func_75216_d()) {
            return ItemStackUtils.EMPTY;
        }
        ItemStack stackCopy = slot.func_75211_c().func_77946_l();
        int maxIndex = this.inventorySize * 9;
        if (index < maxIndex ? !this.func_75135_a(stackCopy, maxIndex, this.field_75151_b.size(), true) : !this.func_75135_a(stackCopy, 0, maxIndex, false)) {
            return ItemStackUtils.EMPTY;
        }
        if (ItemStackUtils.getSize(stackCopy) == 0) {
            slot.func_75215_d(ItemStackUtils.EMPTY);
        } else {
            slot.func_75218_e();
        }
        this.rack.updateItemStorage();
        if (this.neighborRack != null) {
            this.neighborRack.updateItemStorage();
        }
        return stackCopy;
    }

    public boolean func_75145_c(EntityPlayer playerIn) {
        return true;
    }
}

