/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.event;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.api.configuration.Configurations;
import com.minecolonies.api.util.LanguageHandler;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.MathUtils;
import com.minecolonies.coremod.blocks.AbstractBlockHut;
import com.minecolonies.coremod.blocks.BlockHutField;
import com.minecolonies.coremod.blocks.BlockHutTownHall;
import com.minecolonies.coremod.blocks.BlockHutWareHouse;
import com.minecolonies.coremod.colony.ColonyManager;
import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSilverfish;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;

public class EventHandler {
    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onDebugOverlay(RenderGameOverlayEvent.Text event) {
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            Minecraft mc = Minecraft.func_71410_x();
            if (mc.field_71474_y.field_74330_P) {
                WorldClient world = mc.field_71441_e;
                EntityPlayerSP player = mc.field_71439_g;
                IColony colony = ColonyManager.getIColony((World)world, player.func_180425_c());
                double minDistance = ColonyManager.getMinimumDistanceBetweenTownHalls();
                if (colony == null) {
                    colony = ColonyManager.getClosestIColony((World)world, player.func_180425_c());
                    if (colony == null || Math.sqrt(colony.getDistanceSquared(player.func_180425_c())) > 2.0 * minDistance) {
                        event.getLeft().add(LanguageHandler.format("com.minecolonies.coremod.gui.debugScreen.noCloseColony", new Object[0]));
                        return;
                    }
                    event.getLeft().add(LanguageHandler.format("com.minecolonies.coremod.gui.debugScreen.nextColony", (int)Math.sqrt(colony.getDistanceSquared(player.func_180425_c())), minDistance));
                    return;
                }
                event.getLeft().add(colony.getName() + " : " + LanguageHandler.format("com.minecolonies.coremod.gui.debugScreen.blocksFromCenter", (int)Math.sqrt(colony.getDistanceSquared(player.func_180425_c()))));
            }
        }
    }

    @SubscribeEvent
    public void onBlockBreak(@NotNull BlockEvent.BreakEvent event) {
        World world = event.getWorld();
        if (!world.field_72995_K && event.getState().func_177230_c() instanceof AbstractBlockHut) {
            AbstractBuilding building = ColonyManager.getBuilding(world, event.getPos());
            if (building == null) {
                return;
            }
            if (!building.getColony().getPermissions().hasPermission(event.getPlayer(), Action.BREAK_HUTS)) {
                event.setCanceled(true);
                return;
            }
            building.destroy();
        }
    }

    @SubscribeEvent
    public void onPlayerInteract(@NotNull PlayerInteractEvent.RightClickBlock event) {
        EntityPlayer player = event.getEntityPlayer();
        World world = event.getWorld();
        if (event.getHand() == EnumHand.MAIN_HAND && !event.getWorld().field_72995_K) {
            if (EventHandler.playerRightClickInteract(player, world, event.getPos()) && world.func_180495_p(event.getPos()).func_177230_c() instanceof AbstractBlockHut) {
                IColony colony = ColonyManager.getIColony(world, event.getPos());
                if (colony != null && !colony.getPermissions().hasPermission(player, Action.ACCESS_HUTS)) {
                    event.setCanceled(true);
                }
                return;
            }
            if (event.getEntityPlayer() != null && "pmardle".equalsIgnoreCase(event.getEntityPlayer().func_70005_c_()) && event.getItemStack() != null && Block.func_149634_a((Item)event.getItemStack().func_77973_b()) instanceof BlockSilverfish) {
                LanguageHandler.sendPlayerMessage(event.getEntityPlayer(), "Stop that you twat!!!", new Object[0]);
                event.setCanceled(true);
            }
            if (player.func_184614_ca() == null || player.func_184614_ca().func_77973_b() == null) {
                return;
            }
            EventHandler.handleEventCancellation((PlayerInteractEvent)event, player);
        }
    }

    private static boolean playerRightClickInteract(@NotNull EntityPlayer player, World world, BlockPos pos) {
        return !player.func_70093_af() || player.func_184614_ca() == null || player.func_184614_ca().func_77973_b() == null || player.func_184614_ca().func_77973_b().doesSneakBypassUse(player.func_184614_ca(), (IBlockAccess)world, pos, player);
    }

    private static void handleEventCancellation(@NotNull PlayerInteractEvent event, @NotNull EntityPlayer player) {
        Block heldBlock = Block.func_149634_a((Item)player.func_184614_ca().func_77973_b());
        if (heldBlock instanceof AbstractBlockHut || heldBlock instanceof BlockHutField) {
            event.setCanceled(!EventHandler.onBlockHutPlaced(event.getWorld(), player, heldBlock, event.getPos().func_177972_a(event.getFace())));
        }
    }

    public static boolean onBlockHutPlaced(@NotNull World world, @NotNull EntityPlayer player, Block block, BlockPos pos) {
        if (block instanceof BlockHutTownHall) {
            return EventHandler.onTownHallPlaced(world, player, pos);
        }
        if (block instanceof BlockHutWareHouse) {
            return EventHandler.onWareHousePlaced(world, player, pos);
        }
        return EventHandler.onBlockHutPlaced(world, player, pos);
    }

    static boolean onTownHallPlaced(@NotNull World world, @NotNull EntityPlayer player, BlockPos pos) {
        IColony colony = ColonyManager.getIColonyByOwner(world, player);
        if (colony != null) {
            return EventHandler.canOwnerPlaceTownHallHere(world, player, colony, pos);
        }
        colony = ColonyManager.getClosestIColony(world, pos);
        if (colony == null) {
            return true;
        }
        return EventHandler.canPlayerPlaceTownHallHere(world, player, pos, colony);
    }

    private static boolean onWareHousePlaced(World world, EntityPlayer player, BlockPos pos) {
        if (EventHandler.onBlockHutPlaced(world, player, pos)) {
            IColony colony = ColonyManager.getClosestIColony(world, pos);
            if (!(colony == null || Configurations.Gameplay.limitToOneWareHousePerColony && colony.hasWarehouse())) {
                return true;
            }
            LanguageHandler.sendPlayerMessage(player, "tile.blockHut.warehouse.limit", new Object[0]);
        }
        return false;
    }

    private static boolean onBlockHutPlaced(World world, @NotNull EntityPlayer player, BlockPos pos) {
        IColony colony = ColonyManager.getIColony(world, pos);
        if (colony == null) {
            if (ColonyManager.getIColonyByOwner(world, player) == null) {
                LanguageHandler.sendPlayerMessage(player, "tile.blockHut.messageNoTownHall", new Object[0]);
            } else {
                LanguageHandler.sendPlayerMessage(player, "tile.blockHut.messageTooFarFromTownHall", new Object[0]);
            }
            return false;
        }
        if (!colony.getPermissions().hasPermission(player, Action.PLACE_HUTS)) {
            LanguageHandler.sendPlayerMessage(player, "tile.blockHut.messageNoPermission", colony.getName());
            return false;
        }
        return true;
    }

    private static boolean canOwnerPlaceTownHallHere(World world, @NotNull EntityPlayer player, @NotNull IColony colony, BlockPos pos) {
        if (!colony.isCoordInColony(world, pos) || colony.hasTownHall()) {
            LanguageHandler.sendPlayerMessage(player, "tile.blockHutTownHall.messagePlacedAlready", new Object[0]);
            return false;
        }
        IColony currentColony = ColonyManager.getIColony(world, pos);
        if (currentColony != colony) {
            LanguageHandler.sendPlayerMessage(player, "tile.blockHutTownhall.messageTooFar", new Object[0]);
            return false;
        }
        return true;
    }

    private static boolean canPlayerPlaceTownHallHere(@NotNull World world, @NotNull EntityPlayer player, BlockPos pos, @NotNull IColony closestColony) {
        if (closestColony.isCoordInColony(world, pos)) {
            if (closestColony.hasTownHall() || !closestColony.getPermissions().isColonyMember(player)) {
                Log.getLogger().info("Can't place at: " + pos.func_177958_n() + "." + pos.func_177956_o() + "." + pos.func_177952_p() + ". Because of townhall of: " + closestColony.getName() + " at " + closestColony.getCenter().func_177958_n() + "." + closestColony.getCenter().func_177956_o() + "." + closestColony.getCenter().func_177952_p());
                LanguageHandler.sendPlayerMessage(player, "tile.blockHutTownHall.messageTooClose", new Object[0]);
                return false;
            }
            if (!closestColony.getPermissions().hasPermission(player, Action.PLACE_HUTS)) {
                LanguageHandler.sendPlayerMessage(player, "tile.blockHut.messageNoPermissionPlace", closestColony.getName());
                return false;
            }
            return true;
        }
        if ((double)closestColony.getDistanceSquared(pos) <= MathUtils.square(ColonyManager.getMinimumDistanceBetweenTownHalls())) {
            Log.getLogger().info("Can't place at: " + pos.func_177958_n() + "." + pos.func_177956_o() + "." + pos.func_177952_p() + ". Because of townhall of: " + closestColony.getName() + " at " + closestColony.getCenter().func_177958_n() + "." + closestColony.getCenter().func_177956_o() + "." + closestColony.getCenter().func_177952_p());
            LanguageHandler.sendPlayerMessage(player, "tile.blockHutTownHall.messageTooClose", new Object[0]);
            return false;
        }
        if (Configurations.Gameplay.protectVillages && world.func_175714_ae().func_176056_a(pos, Configurations.Gameplay.workingRangeTownHall) != null) {
            Log.getLogger().warn("Village close by!");
            return false;
        }
        return true;
    }

    @SubscribeEvent
    public void onWorldLoad(@NotNull WorldEvent.Load event) {
        ColonyManager.onWorldLoad(event.getWorld());
    }

    @SubscribeEvent
    public void onWorldUnload(@NotNull WorldEvent.Unload event) {
        ColonyManager.onWorldUnload(event.getWorld());
    }
}

