/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.event;

import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.coremod.colony.CitizenDataView;
import com.minecolonies.coremod.colony.ColonyManager;
import com.minecolonies.coremod.colony.ColonyView;
import com.minecolonies.coremod.entity.EntityCitizen;
import com.minecolonies.coremod.entity.pathfinding.Pathfinding;
import com.minecolonies.coremod.util.RenderUtils;
import com.minecolonies.structures.helpers.Settings;
import com.minecolonies.structures.helpers.Structure;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.jetbrains.annotations.NotNull;

public class ClientEventHandler {
    private static final List<BlockPos> colonyBorder = new ArrayList<BlockPos>();
    private static final int SECONDS_TO_SHOW = 5;
    private CitizenDataView citizen = null;
    private double ticksPassed = 0.0;

    @SubscribeEvent
    public void renderWorldLastEvent(@NotNull RenderWorldLastEvent event) {
        Pathfinding.debugDraw(event.getPartialTicks());
        Structure structure = Settings.instance.getActiveStructure();
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (structure != null) {
            BlockPos position = Settings.instance.getPosition();
            if (Settings.instance.getStructureName().contains("infrastructure")) {
                RenderUtils.renderWayPoints(position, world, event.getPartialTicks());
            } else {
                RenderUtils.renderColonyBorder(position, world, event.getPartialTicks(), (EntityPlayer)player, colonyBorder);
            }
            return;
        }
        if (this.citizen != null) {
            Entity entityCitizen = world.func_73045_a(this.citizen.getEntityId());
            if (entityCitizen instanceof EntityCitizen) {
                RenderUtils.renderSigns(world, event.getPartialTicks(), this.citizen, (EntityPlayer)player, entityCitizen.func_180425_c());
                this.ticksPassed += (double)event.getPartialTicks();
                if (this.ticksPassed > 100.0) {
                    this.ticksPassed = 0.0;
                    this.citizen = null;
                }
            } else {
                this.citizen = null;
                this.ticksPassed = 0.0;
            }
            return;
        }
        ColonyView colony = ColonyManager.getClosestColonyView((World)world, player.func_180425_c());
        if (colony != null && player != null && colony.getPermissions().hasPermission((EntityPlayer)player, Action.ACCESS_HUTS)) {
            for (CitizenDataView citizenDataView : new ArrayList<CitizenDataView>(colony.getCitizens().values())) {
                Entity entityCitizen = world.func_73045_a(citizenDataView.getEntityId());
                if (!(entityCitizen instanceof EntityCitizen) || !(entityCitizen.func_180425_c().func_177951_i((Vec3i)player.func_180425_c()) <= 2.0)) continue;
                RenderUtils.renderSigns(world, event.getPartialTicks(), citizenDataView, (EntityPlayer)player, entityCitizen.func_180425_c());
                this.citizen = citizenDataView;
                return;
            }
        }
        colonyBorder.clear();
    }
}

