/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.pathfinding;

import com.minecolonies.api.configuration.Configurations;
import com.minecolonies.api.util.Log;
import com.minecolonies.coremod.entity.pathfinding.AbstractPathJob;
import com.minecolonies.coremod.entity.pathfinding.Node;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.pathfinding.Path;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;

public final class Pathfinding {
    private static final BlockingQueue<Runnable> jobQueue = new LinkedBlockingDeque<Runnable>();
    private static final ThreadPoolExecutor executor = new ThreadPoolExecutor(1, Configurations.Pathfinding.pathfindingMaxThreadCount, 10L, TimeUnit.SECONDS, jobQueue);

    private Pathfinding() {
    }

    public static Future<Path> enqueue(@NotNull AbstractPathJob job) {
        return executor.submit(job);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SideOnly(value=Side.CLIENT)
    public static void debugDraw(double frame) {
        Set<Node> debugNodesPath;
        Set<Node> debugNodesVisited;
        Set<Node> debugNodesNotVisited;
        if (AbstractPathJob.lastDebugNodesNotVisited == null) {
            return;
        }
        Entity entity = Minecraft.func_71410_x().func_175606_aa();
        double dx = entity.field_70142_S + (entity.field_70165_t - entity.field_70142_S) * frame;
        double dy = entity.field_70137_T + (entity.field_70163_u - entity.field_70137_T) * frame;
        double dz = entity.field_70136_U + (entity.field_70161_v - entity.field_70136_U) * frame;
        GlStateManager.func_179094_E();
        GlStateManager.func_179123_a();
        GlStateManager.func_179137_b((double)(-dx), (double)(-dy), (double)(-dz));
        GlStateManager.func_179090_x();
        GlStateManager.func_179084_k();
        GlStateManager.func_179140_f();
        GlStateManager.func_179089_o();
        GlStateManager.func_179126_j();
        Iterator<Node> iterator = AbstractPathJob.debugNodeMonitor;
        synchronized (iterator) {
            debugNodesNotVisited = AbstractPathJob.lastDebugNodesNotVisited;
            debugNodesVisited = AbstractPathJob.lastDebugNodesVisited;
            debugNodesPath = AbstractPathJob.lastDebugNodesPath;
        }
        try {
            for (Node n : debugNodesNotVisited) {
                Pathfinding.debugDrawNode(n, 1.0f, 0.0f, 0.0f);
            }
            for (Node n : debugNodesVisited) {
                Pathfinding.debugDrawNode(n, 0.0f, 0.0f, 1.0f);
            }
            for (Node n : debugNodesPath) {
                Pathfinding.debugDrawNode(n, 0.0f, 1.0f, 0.0f);
            }
        }
        catch (ConcurrentModificationException exc) {
            Log.getLogger().catching((Throwable)exc);
        }
        GlStateManager.func_179099_b();
        GlStateManager.func_179121_F();
    }

    @SideOnly(value=Side.CLIENT)
    private static void debugDrawNode(@NotNull Node n, float r, float g, float b) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)((double)n.pos.func_177958_n() + 0.375), (double)((double)n.pos.func_177956_o() + 0.375), (double)((double)n.pos.func_177952_p() + 0.375));
        Entity entity = Minecraft.func_71410_x().func_175606_aa();
        double dx = (double)n.pos.func_177958_n() - entity.field_70165_t;
        double dy = (double)n.pos.func_177956_o() - entity.field_70163_u;
        double dz = (double)n.pos.func_177952_p() - entity.field_70161_v;
        if (Math.sqrt(dx * dx + dy * dy + dz * dz) <= 5.0) {
            Pathfinding.renderDebugText(n);
        }
        GlStateManager.func_179139_a((double)0.25, (double)0.25, (double)0.25);
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer vertexBuffer = tessellator.func_178180_c();
        vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        GlStateManager.func_179124_c((float)r, (float)g, (float)b);
        vertexBuffer.func_181662_b(1.0, 0.0, 0.0).func_181675_d();
        vertexBuffer.func_181662_b(1.0, 1.0, 0.0).func_181675_d();
        vertexBuffer.func_181662_b(1.0, 1.0, 1.0).func_181675_d();
        vertexBuffer.func_181662_b(1.0, 0.0, 1.0).func_181675_d();
        vertexBuffer.func_181662_b(0.0, 0.0, 1.0).func_181675_d();
        vertexBuffer.func_181662_b(0.0, 1.0, 1.0).func_181675_d();
        vertexBuffer.func_181662_b(0.0, 1.0, 0.0).func_181675_d();
        vertexBuffer.func_181662_b(0.0, 0.0, 0.0).func_181675_d();
        vertexBuffer.func_181662_b(0.0, 0.0, 0.0).func_181675_d();
        vertexBuffer.func_181662_b(0.0, 1.0, 0.0).func_181675_d();
        vertexBuffer.func_181662_b(1.0, 1.0, 0.0).func_181675_d();
        vertexBuffer.func_181662_b(1.0, 0.0, 0.0).func_181675_d();
        vertexBuffer.func_181662_b(1.0, 0.0, 1.0).func_181675_d();
        vertexBuffer.func_181662_b(1.0, 1.0, 1.0).func_181675_d();
        vertexBuffer.func_181662_b(0.0, 1.0, 1.0).func_181675_d();
        vertexBuffer.func_181662_b(0.0, 0.0, 1.0).func_181675_d();
        vertexBuffer.func_181662_b(1.0, 1.0, 1.0).func_181675_d();
        vertexBuffer.func_181662_b(1.0, 1.0, 0.0).func_181675_d();
        vertexBuffer.func_181662_b(0.0, 1.0, 0.0).func_181675_d();
        vertexBuffer.func_181662_b(0.0, 1.0, 1.0).func_181675_d();
        vertexBuffer.func_181662_b(0.0, 0.0, 1.0).func_181675_d();
        vertexBuffer.func_181662_b(0.0, 0.0, 0.0).func_181675_d();
        vertexBuffer.func_181662_b(1.0, 0.0, 0.0).func_181675_d();
        vertexBuffer.func_181662_b(1.0, 0.0, 1.0).func_181675_d();
        tessellator.func_78381_a();
        if (n.parent != null) {
            double pdx = (double)(n.parent.pos.func_177958_n() - n.pos.func_177958_n()) + 0.125;
            double pdy = (double)(n.parent.pos.func_177956_o() - n.pos.func_177956_o()) + 0.125;
            double pdz = (double)(n.parent.pos.func_177952_p() - n.pos.func_177952_p()) + 0.125;
            vertexBuffer.func_181668_a(1, DefaultVertexFormats.field_181706_f);
            vertexBuffer.func_181662_b(0.5, 0.5, 0.5).func_181666_a(0.75f, 0.75f, 0.75f, 1.0f).func_181675_d();
            vertexBuffer.func_181662_b(pdx / 0.25, pdy / 0.25, pdz / 0.25).func_181666_a(0.75f, 0.75f, 0.75f, 1.0f).func_181675_d();
            tessellator.func_78381_a();
        }
        GlStateManager.func_179121_F();
    }

    @SideOnly(value=Side.CLIENT)
    private static void renderDebugText(@NotNull Node n) {
        String s1 = String.format("F: %.3f [%d]", n.getCost(), n.getCounterAdded());
        String s2 = String.format("G: %.3f [%d]", n.getScore(), n.getCounterVisited());
        FontRenderer fontrenderer = Minecraft.func_71410_x().field_71466_p;
        GlStateManager.func_179123_a();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)0.0f, (float)0.75f, (float)0.0f);
        GlStateManager.func_187432_a((float)0.0f, (float)1.0f, (float)0.0f);
        RenderManager renderManager = Minecraft.func_71410_x().func_175598_ae();
        GlStateManager.func_179114_b((float)(-renderManager.field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)renderManager.field_78732_j, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179152_a((float)-0.014f, (float)-0.014f, (float)0.014f);
        GlStateManager.func_179109_b((float)0.0f, (float)18.0f, (float)0.0f);
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179097_i();
        GlStateManager.func_179147_l();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179090_x();
        int i = Math.max(fontrenderer.func_78256_a(s1), fontrenderer.func_78256_a(s2)) / 2;
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer vertexBuffer = tessellator.func_178180_c();
        vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        vertexBuffer.func_181662_b((double)(-i - 1), -5.0, 0.0).func_181666_a(0.0f, 0.0f, 0.0f, 0.25f).func_181675_d();
        vertexBuffer.func_181662_b((double)(-i - 1), 12.0, 0.0).func_181666_a(0.0f, 0.0f, 0.0f, 0.25f).func_181675_d();
        vertexBuffer.func_181662_b((double)(i + 1), 12.0, 0.0).func_181666_a(0.0f, 0.0f, 0.0f, 0.25f).func_181675_d();
        vertexBuffer.func_181662_b((double)(i + 1), -5.0, 0.0).func_181666_a(0.0f, 0.0f, 0.0f, 0.25f).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179098_w();
        GlStateManager.func_179109_b((float)0.0f, (float)-5.0f, (float)0.0f);
        fontrenderer.func_78276_b(s1, -fontrenderer.func_78256_a(s1) / 2, 0, -1);
        GlStateManager.func_179109_b((float)0.0f, (float)8.0f, (float)0.0f);
        fontrenderer.func_78276_b(s2, -fontrenderer.func_78256_a(s2) / 2, 0, -1);
        GlStateManager.func_179126_j();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179109_b((float)0.0f, (float)-8.0f, (float)0.0f);
        fontrenderer.func_78276_b(s1, -fontrenderer.func_78256_a(s1) / 2, 0, -1);
        GlStateManager.func_179109_b((float)0.0f, (float)8.0f, (float)0.0f);
        fontrenderer.func_78276_b(s2, -fontrenderer.func_78256_a(s2) / 2, 0, -1);
        GlStateManager.func_179121_F();
        GlStateManager.func_179099_b();
    }
}

