/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.util;

import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;

public class RecipeStorage {
    private final List<ItemStack> input;
    private final ItemStack primaryOutput;
    private final List<ItemStack> secondaryOutput;
    private final int gridSize;

    public RecipeStorage(List<ItemStack> input, int gridSize, ItemStack primaryOutput, ItemStack ... secondaryOutput) {
        this.input = Collections.unmodifiableList(input);
        this.primaryOutput = primaryOutput;
        this.secondaryOutput = Collections.unmodifiableList(Arrays.asList(secondaryOutput));
        this.gridSize = gridSize;
    }

    public List<ItemStack> getInput() {
        return this.input;
    }

    public List<ItemStack> getSecondaryOutput() {
        return this.secondaryOutput;
    }

    public ItemStack getPrimaryOutput() {
        return this.primaryOutput;
    }

    public int getGridSize() {
        return this.gridSize;
    }

    public boolean canFullFillRecipe(IItemHandler ... inventories) {
        for (ItemStack stack : this.input) {
            int amountNeeded = ItemStackUtils.getSize(stack);
            boolean hasStack = false;
            for (IItemHandler handler : inventories) {
                hasStack = InventoryUtils.hasItemInItemHandler(handler, itemStack -> ItemStackUtils.isEmpty(itemStack) == false && itemStack.func_77969_a(stack));
                if (!hasStack) continue;
                int count = InventoryUtils.getItemCountInItemHandler(handler, itemStack -> ItemStackUtils.isEmpty(itemStack) == false && itemStack.func_77969_a(stack));
                if (count >= amountNeeded) break;
                hasStack = false;
                amountNeeded -= count;
            }
            if (hasStack) continue;
            return false;
        }
        return true;
    }
}

