/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.mobs.util;

import com.minecolonies.api.configuration.Configurations;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.LanguageHandler;
import com.minecolonies.coremod.colony.CitizenData;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.entity.ai.mobs.util.BarbarianSpawnUtils;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

public final class MobEventsUtils {
    private static final String BARBARIAN = "minecolonies.Barbarian";
    private static final String ARCHER = "minecolonies.ArcherBarbarian";
    private static final String CHIEF = "minecolonies.ChiefBarbarian";
    private static final int MAX_SIZE = Configurations.Gameplay.maxBarbarianHordeSize;
    private static final double BARBARIANS_MULTIPLIER = 0.5;
    private static final double ARCHER_BARBARIANS_MULTIPLIER = 0.25;
    private static final double CHIEF_BARBARIANS_MULTIPLIER = 0.1;
    private static final int PREFERRED_MAX_HORDE_SIZE = 40;
    private static final int PREFERRED_MAX_BARBARIANS = 22;
    private static final int PREFERRED_MAX_ARCHERS = 16;
    private static final int PREFERRED_MAX_CHIEFS = 2;
    private static final int MIN_CITIZENS_FOR_RAID = 5;
    private static final int NUMBER_OF_CITIZENS_NEEDED = 5;
    private static final int SMALL_HORDE_MESSAGE_ID = 1;
    private static final int MEDIUM_HORDE_MESSAGE_ID = 2;
    private static final int BIG_HORDE_MESSAGE_ID = 3;
    private static final int HUGE_HORDE_MESSAGE_ID = 4;
    private static final int SMALL_HORDE_SIZE = 5;
    private static final int MEDIUM_HORDE_SIZE = 10;
    private static final int BIG_HORDE_SIZE = 20;
    private static final int SPAWN_MODIFIER = 3;
    private static int numberOfBarbarians = 0;
    private static int numberOfArchers = 0;
    private static int numberOfChiefs = 0;

    private MobEventsUtils() {
    }

    public static void barbarianEvent(World world, Colony colony) {
        if (world == null || !colony.isCanHaveBarbEvents()) {
            return;
        }
        int horde = MobEventsUtils.numberOfSpawns(colony);
        if (horde == 0) {
            return;
        }
        BlockPos targetSpawnPoint = MobEventsUtils.calculateSpawnLocation(world, colony);
        if (targetSpawnPoint.equals((Object)colony.getCenter())) {
            return;
        }
        if (Configurations.Gameplay.enableInDevelopmentFeatures) {
            LanguageHandler.sendPlayersMessage(colony.getMessageEntityPlayers(), "Horde Spawn Point: " + targetSpawnPoint, new Object[0]);
        }
        int raidNumber = 4;
        if (horde < 5) {
            raidNumber = 1;
        } else if (horde < 10) {
            raidNumber = 2;
        } else if (horde < 20) {
            raidNumber = 3;
        }
        LanguageHandler.sendPlayersMessage(colony.getMessageEntityPlayers(), "event.minecolonies.raidMessage" + raidNumber, new Object[0]);
        BarbarianSpawnUtils.spawn(BARBARIAN, numberOfBarbarians, targetSpawnPoint, world);
        BarbarianSpawnUtils.spawn(ARCHER, numberOfArchers, targetSpawnPoint, world);
        BarbarianSpawnUtils.spawn(CHIEF, numberOfChiefs, targetSpawnPoint, world);
    }

    private static int numberOfSpawns(Colony colony) {
        if (colony.getCitizenManager().getCitizens().size() < 5) {
            return 0;
        }
        int raidLevel = MobEventsUtils.getColonyRaidLevel(colony);
        numberOfBarbarians = (int)(0.5 * (double)raidLevel / 3.0);
        int hordeTotal = numberOfBarbarians + (numberOfArchers = (int)(0.25 * (double)raidLevel / 3.0)) + (numberOfChiefs = (int)(0.1 * (double)raidLevel / 3.0));
        if (hordeTotal > 40 && MAX_SIZE == 40) {
            numberOfBarbarians = 22;
            numberOfArchers = 16;
            numberOfChiefs = 2;
        } else if (hordeTotal > MAX_SIZE) {
            numberOfBarbarians = MobEventsUtils.equalizeBarbarianSpawns(hordeTotal, numberOfBarbarians);
            hordeTotal = numberOfArchers + numberOfBarbarians + numberOfChiefs;
            numberOfArchers = MobEventsUtils.equalizeBarbarianSpawns(hordeTotal, numberOfArchers);
            hordeTotal = numberOfArchers + numberOfBarbarians + numberOfChiefs;
            numberOfChiefs = MobEventsUtils.equalizeBarbarianSpawns(hordeTotal, numberOfChiefs);
        }
        return hordeTotal;
    }

    private static BlockPos calculateSpawnLocation(World world, @NotNull Colony colony) {
        Random random = new Random();
        BlockPos pos = colony.getBarbManager().getRandomOutsiderInDirection(random.nextInt(2) < 1 ? EnumFacing.EAST : EnumFacing.WEST, random.nextInt(2) < 1 ? EnumFacing.NORTH : EnumFacing.SOUTH);
        if (pos.equals((Object)colony.getCenter())) {
            return colony.getCenter();
        }
        return BlockPosUtil.findLand(pos, world);
    }

    public static int getColonyRaidLevel(Colony colony) {
        int levels = 0;
        ArrayList<CitizenData> citizensList = new ArrayList<CitizenData>();
        citizensList.addAll(colony.getCitizenManager().getCitizens());
        for (CitizenData citizen : citizensList) {
            levels += citizen.getLevel();
        }
        return levels;
    }

    private static int equalizeBarbarianSpawns(int total, int numberOf) {
        int returnValue = numberOf;
        if (total > MAX_SIZE) {
            returnValue = total - MAX_SIZE;
            if (returnValue < 0) {
                return 0;
            }
            return returnValue;
        }
        return returnValue;
    }

    public static boolean isItTimeToRaid(World world, Colony colony) {
        if (colony.getCitizenManager().getCitizens().size() < 5) {
            return false;
        }
        if (world.func_72935_r() && !colony.isHasRaidBeenCalculated()) {
            colony.getBarbManager().setHasRaidBeenCalculated(true);
            if (!colony.hasWillRaidTonight()) {
                boolean raid = MobEventsUtils.raidThisNight(world);
                if (Configurations.Gameplay.enableInDevelopmentFeatures) {
                    LanguageHandler.sendPlayersMessage(colony.getMessageEntityPlayers(), "Will raid tonight: " + raid, new Object[0]);
                }
                colony.getBarbManager().setWillRaidTonight(raid);
            }
            return false;
        }
        if (colony.hasWillRaidTonight() && !world.func_72935_r() && colony.isHasRaidBeenCalculated()) {
            colony.getBarbManager().setHasRaidBeenCalculated(false);
            colony.getBarbManager().setWillRaidTonight(false);
            if (Configurations.Gameplay.enableInDevelopmentFeatures) {
                LanguageHandler.sendPlayersMessage(colony.getMessageEntityPlayers(), "Night reached: raiding", new Object[0]);
            }
            return true;
        }
        if (!world.func_72935_r() && colony.isHasRaidBeenCalculated()) {
            colony.getBarbManager().setHasRaidBeenCalculated(false);
        }
        return false;
    }

    private static boolean raidThisNight(World world) {
        return world.field_73012_v.nextDouble() < 1.0 / (double)Configurations.Gameplay.averageNumberOfNightsBetweenRaids;
    }
}

