/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.mobs.util;

import com.minecolonies.api.util.CompatibilityUtils;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.entity.EntityCitizen;
import com.minecolonies.coremod.entity.ai.mobs.barbarians.AbstractEntityBarbarian;
import com.minecolonies.coremod.entity.ai.mobs.barbarians.EntityAIAttackArcher;
import com.minecolonies.coremod.entity.ai.mobs.barbarians.EntityAIBarbarianAttackMelee;
import com.minecolonies.coremod.entity.ai.mobs.barbarians.EntityAIWalkToRandomHuts;
import com.minecolonies.coremod.entity.ai.mobs.barbarians.EntityArcherBarbarian;
import com.minecolonies.coremod.entity.ai.mobs.barbarians.EntityBarbarian;
import com.minecolonies.coremod.entity.ai.mobs.barbarians.EntityChiefBarbarian;
import com.minecolonies.coremod.entity.ai.mobs.util.MobEventsUtils;
import com.minecolonies.coremod.items.ModItems;
import java.util.stream.IntStream;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public final class BarbarianSpawnUtils {
    public static final ResourceLocation BarbarianLootTable = new ResourceLocation("minecolonies", "EntityBarbarianDrops");
    public static final ResourceLocation ArcherLootTable = new ResourceLocation("minecolonies", "EntityArcherBarbarianDrops");
    public static final ResourceLocation ChiefLootTable = new ResourceLocation("minecolonies", "EntityChiefBarbarianDrops");
    public static final double ATTACK_DAMAGE = 2.0;
    private static final float WHOLE_CIRCLE = 360.0f;
    private static final int PRIORITY_ZERO = 0;
    private static final int PRIORITY_ONE = 1;
    private static final int PRIORITY_TWO = 2;
    private static final int PRIORITY_THREE = 3;
    private static final int PRIORITY_FOUR = 4;
    private static final int PRIORITY_FIVE = 5;
    private static final double AI_MOVE_SPEED = 2.0;
    private static final float MAX_WATCH_DISTANCE = 8.0f;
    private static final double FOLLOW_RANGE = 35.0;
    private static final double MOVEMENT_SPEED = 0.2;
    private static final double ARMOR = 2.0;
    private static final double BARBARIAN_BASE_HEALTH = 10.0;
    private static final double BARBARIAN_HEALTH_MULTIPLIER = 0.25;

    private BarbarianSpawnUtils() {
    }

    public static void setBarbarianAttributes(AbstractEntityBarbarian barbarian, Colony colony) {
        barbarian.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(35.0);
        barbarian.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.2);
        barbarian.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(2.0);
        barbarian.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(2.0);
        barbarian.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(BarbarianSpawnUtils.getHealthBasedOnRaidLevel(colony));
    }

    private static double getHealthBasedOnRaidLevel(Colony colony) {
        if (colony != null) {
            int raidLevel = (int)((double)MobEventsUtils.getColonyRaidLevel(colony) * 0.25);
            return 10.0 + (double)raidLevel;
        }
        return 10.0;
    }

    public static void setBarbarianAI(AbstractEntityBarbarian barbarian) {
        barbarian.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)barbarian));
        barbarian.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIWalkToRandomHuts((EntityCreature)barbarian, 2.0));
        barbarian.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)barbarian, EntityPlayer.class, true));
        barbarian.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)barbarian, EntityCitizen.class, true));
        barbarian.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)barbarian, EntityPlayer.class, 8.0f));
        if (barbarian instanceof EntityArcherBarbarian) {
            barbarian.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAttackArcher((EntityCreature)barbarian));
        } else {
            barbarian.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIBarbarianAttackMelee(barbarian));
        }
    }

    public static ResourceLocation getBarbarianLootTable(AbstractEntityBarbarian barbarian) {
        if (barbarian instanceof EntityBarbarian) {
            return BarbarianLootTable;
        }
        if (barbarian instanceof EntityArcherBarbarian) {
            return ArcherLootTable;
        }
        if (barbarian instanceof EntityChiefBarbarian) {
            return ChiefLootTable;
        }
        return BarbarianLootTable;
    }

    public static void spawn(String entityToSpawn, int numberOfSpawns, BlockPos spawnLocation, World world) {
        if (spawnLocation != null && entityToSpawn != null && world != null) {
            int x = spawnLocation.func_177958_n();
            int y = spawnLocation.func_177956_o();
            int z = spawnLocation.func_177952_p();
            IntStream.range(0, numberOfSpawns).forEach(theInteger -> {
                AbstractEntityBarbarian entity = (AbstractEntityBarbarian)EntityList.func_188429_b((String)entityToSpawn, (World)world);
                if (entity != null) {
                    BarbarianSpawnUtils.setBarbarianEquipment(entity);
                    entity.func_70012_b(x, y, z, MathHelper.func_76142_g((float)(world.field_73012_v.nextFloat() * 360.0f)), 0.0f);
                    CompatibilityUtils.spawnEntity(world, (Entity)entity);
                }
            });
        }
    }

    public static void setBarbarianEquipment(AbstractEntityBarbarian barbarian) {
        if (barbarian instanceof EntityBarbarian) {
            barbarian.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(Items.field_151049_t));
        } else if (barbarian instanceof EntityArcherBarbarian) {
            barbarian.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack((Item)Items.field_151031_f));
        } else if (barbarian instanceof EntityChiefBarbarian) {
            barbarian.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(ModItems.chiefSword));
            barbarian.func_184201_a(EntityEquipmentSlot.HEAD, new ItemStack((Item)Items.field_151020_U));
            barbarian.func_184201_a(EntityEquipmentSlot.CHEST, new ItemStack((Item)Items.field_151023_V));
            barbarian.func_184201_a(EntityEquipmentSlot.LEGS, new ItemStack((Item)Items.field_151022_W));
            barbarian.func_184201_a(EntityEquipmentSlot.FEET, new ItemStack((Item)Items.field_151029_X));
        }
    }
}

