/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.mobs.barbarians;

import com.minecolonies.api.util.Log;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.ColonyManager;
import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import com.minecolonies.coremod.entity.pathfinding.GeneralEntityWalkToProxy;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

public class EntityAIWalkToRandomHuts
extends EntityAIBase {
    protected final EntityCreature entity;
    protected final World world;
    protected final double speed;
    protected final Colony colony;
    private final com.minecolonies.coremod.entity.pathfinding.PathNavigate newNavigator;
    private BlockPos targetBlock;
    private GeneralEntityWalkToProxy proxy;
    private Field navigatorField;

    public EntityAIWalkToRandomHuts(EntityCreature creatureIn, double speedIn) {
        this.entity = creatureIn;
        this.speed = speedIn;
        this.world = creatureIn.func_130014_f_();
        this.colony = ColonyManager.getClosestColony(this.world, creatureIn.func_180425_c());
        this.newNavigator = new com.minecolonies.coremod.entity.pathfinding.PathNavigate((EntityLiving)this.entity, this.world);
        this.updateNavigatorField();
        this.newNavigator.func_179693_d(true);
        this.newNavigator.func_179691_c(false);
        this.func_75248_a(1);
    }

    private synchronized void updateNavigatorField() {
        if (this.navigatorField == null) {
            Field[] fields;
            for (Field field : fields = EntityLiving.class.getDeclaredFields()) {
                if (!field.getType().equals(PathNavigate.class)) continue;
                field.setAccessible(true);
                this.navigatorField = field;
                break;
            }
        }
        if (this.navigatorField == null) {
            throw new IllegalStateException("Navigator field should not be null, contact developers.");
        }
        try {
            this.navigatorField.set(this.entity, (Object)this.newNavigator);
        }
        catch (IllegalAccessException e) {
            Log.getLogger().error("Navigator error", (Throwable)e);
        }
    }

    public boolean func_75250_a() {
        if (this.targetBlock == null) {
            this.targetBlock = this.getRandomBuilding();
        }
        return this.targetBlock != null;
    }

    public boolean func_75253_b() {
        return !this.entity.func_70661_as().func_75500_f() && this.entity.func_70089_S();
    }

    public void func_75249_e() {
        this.updateNavigatorField();
        if (this.targetBlock != null) {
            if (this.isEntityAtSiteWithMove(this.targetBlock, 2)) {
                this.targetBlock = this.getRandomBuilding();
            }
        } else {
            this.targetBlock = this.getRandomBuilding();
        }
    }

    private boolean isEntityAtSiteWithMove(@NotNull BlockPos site, int range) {
        if (this.proxy == null) {
            this.proxy = new GeneralEntityWalkToProxy((EntityLiving)this.entity);
        }
        return this.proxy.walkToBlock(site, range);
    }

    private BlockPos getRandomBuilding() {
        if (this.colony == null) {
            return null;
        }
        Collection<AbstractBuilding> buildingList = this.colony.getBuildingManager().getBuildings().values();
        Object[] buildingArray = buildingList.toArray();
        if (buildingArray.length != 0) {
            int random = new Random().nextInt(buildingArray.length);
            AbstractBuilding building = (AbstractBuilding)buildingArray[random];
            return building.getLocation();
        }
        return null;
    }

    @Nullable
    protected BlockPos getPosition() {
        this.colony.getBuildingManager().getBuildings();
        return this.colony.getCenter();
    }
}

