/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.minimal;

import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import com.minecolonies.coremod.colony.buildings.BuildingHome;
import com.minecolonies.coremod.entity.EntityCitizen;
import java.util.Iterator;
import net.minecraft.block.BlockBed;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class EntityAISleep
extends EntityAIBase {
    private final EntityCitizen citizen;
    private BlockPos usedBed = null;
    private boolean wokeUp = true;

    public EntityAISleep(EntityCitizen citizen) {
        this.func_75248_a(1);
        this.citizen = citizen;
    }

    public boolean func_75250_a() {
        return this.citizen.getDesiredActivity() == EntityCitizen.DesiredActivity.SLEEP && this.citizen.isAtHome() || !this.wokeUp;
    }

    public boolean func_75253_b() {
        if (this.citizen.getDesiredActivity() == EntityCitizen.DesiredActivity.SLEEP) {
            this.wokeUp = false;
            Colony colony = this.citizen.getColony();
            if (colony == null || colony.getBuildingManager().getBuilding(this.citizen.func_180486_cf()) == null) {
                return true;
            }
            if (this.usedBed == null) {
                AbstractBuilding hut = colony.getBuildingManager().getBuilding(this.citizen.func_180486_cf());
                if (hut instanceof BuildingHome) {
                    Iterator<BlockPos> iterator = ((BuildingHome)hut).getBedList().iterator();
                    while (iterator.hasNext()) {
                        World world = this.citizen.field_70170_p;
                        BlockPos pos = iterator.next();
                        IBlockState worldBlockState = world.func_180495_p(pos);
                        IBlockState state = worldBlockState.func_177230_c().func_176221_a(worldBlockState, (IBlockAccess)world, pos);
                        if (!(state.func_177230_c() instanceof BlockBed) || ((Boolean)state.func_177229_b((IProperty)BlockBed.field_176471_b)).booleanValue() || !((BlockBed.EnumPartType)state.func_177229_b((IProperty)BlockBed.field_176472_a)).equals((Object)BlockBed.EnumPartType.HEAD)) continue;
                        this.usedBed = pos;
                        this.citizen.field_70170_p.func_180501_a(pos, state.func_177226_a((IProperty)BlockBed.field_176471_b, (Comparable)Boolean.valueOf(true)), 3);
                        return true;
                    }
                }
                this.usedBed = this.citizen.func_180486_cf();
            } else {
                BlockPos blockPos = new BlockPos((double)this.usedBed.func_177958_n(), this.citizen.field_70163_u, (double)this.usedBed.func_177952_p());
                if (blockPos.func_177951_i((Vec3i)this.citizen.func_180486_cf()) > 32.0) {
                    this.usedBed = null;
                    return true;
                }
                if (this.citizen.isWorkerAtSiteWithMove(this.usedBed, 1)) {
                    return true;
                }
            }
            return true;
        }
        this.citizen.onWakeUp();
        if (this.usedBed != null) {
            IBlockState state = this.citizen.field_70170_p.func_180495_p(this.usedBed);
            if (state.func_177230_c() instanceof BlockBed) {
                this.citizen.field_70170_p.func_180501_a(this.usedBed, state.func_177226_a((IProperty)BlockBed.field_176471_b, (Comparable)Boolean.valueOf(false)), 3);
            }
            this.usedBed = null;
        }
        this.wokeUp = true;
        return false;
    }

    public void func_75249_e() {
        this.citizen.setStatus(EntityCitizen.Status.SLEEPING);
    }

    public void func_75246_d() {
    }
}

