/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.citizen.smelter;

import com.google.common.reflect.TypeToken;
import com.minecolonies.api.colony.requestsystem.requestable.Burnable;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.coremod.colony.ColonyManager;
import com.minecolonies.coremod.colony.buildings.BuildingSmeltery;
import com.minecolonies.coremod.colony.jobs.JobSmelter;
import com.minecolonies.coremod.colony.requestable.SmeltableOre;
import com.minecolonies.coremod.entity.ai.basic.AbstractEntityAISkill;
import com.minecolonies.coremod.entity.ai.util.AIState;
import com.minecolonies.coremod.entity.ai.util.AITarget;
import java.util.function.Predicate;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;

public class EntityAIWorkSmelter
extends AbstractEntityAISkill<JobSmelter> {
    private static final int STRENGTH_MULTIPLIER = 2;
    private static final int INTELLIGENCE_MULTIPLIER = 1;
    private static final int STANDARD_DELAY = 5;
    private static final int WAIT_AFTER_REQUEST = 400;
    private static final int HIT_DELAY = 20;
    private static final int RESULT_SLOT = 2;
    private static final int ORE_SLOT = 0;
    private static final int FUEL_SLOT = 1;
    private static final int PROGRESS_MULTIPLIER = 50;
    private static final int MAX_LEVEL = 50;
    private static final int HITTING_TIME = 5;
    private static final int CHEST_MAT_AMOUNT = 8;
    private static final int LEGS_MAT_AMOUNT = 7;
    private static final int HEAD_MAT_AMOUNT = 5;
    private static final int FEET_MAT_AMOUNT = 4;
    private static final double BASE_XP_GAIN = 5.0;
    private BlockPos walkTo = null;
    private Predicate<ItemStack> needsCurrently = null;
    private int progress = 0;

    public EntityAIWorkSmelter(@NotNull JobSmelter job) {
        super(job);
        super.registerTargets(new AITarget(AIState.IDLE, AIState.START_WORKING), new AITarget(AIState.START_WORKING, this::startWorking), new AITarget(AIState.SMELTER_GATHERING, this::gatherOreFromBuilding), new AITarget(AIState.SMELTER_SMELT_ORE, this::smeltOre), new AITarget(AIState.SMELTER_RETRIEVE_ORE, this::retrieve), new AITarget(AIState.SMELTER_GET_FIREWOOD, this::getBurnableMaterial), new AITarget(AIState.SMELTER_SMELT_STUFF, this::smeltStuff));
        this.worker.setSkillModifier(2 * this.worker.getCitizenData().getStrength() + 1 * this.worker.getCitizenData().getIntelligence());
        this.worker.func_98053_h(true);
    }

    private AIState smeltStuff() {
        int slot;
        if (this.walkToBuilding()) {
            return this.getState();
        }
        if (ItemStackUtils.isEmpty(this.worker.func_184586_b(EnumHand.MAIN_HAND)).booleanValue()) {
            this.progress = 0;
            if (InventoryUtils.getItemCountInItemHandler((IItemHandler)new InvWrapper((IInventory)this.worker.getInventoryCitizen()), EntityAIWorkSmelter::isSmeltableToolOrWeapon) <= 0) {
                if (this.getOwnBuilding().getCountOfPredicateInHut(EntityAIWorkSmelter::isSmeltableToolOrWeapon, 1, this.world) < 1) {
                    return AIState.START_WORKING;
                }
                InventoryUtils.transferItemStackIntoNextFreeSlotFromProvider(this.getOwnBuilding(), InventoryUtils.findFirstSlotInProviderWith(this.getOwnBuilding(), EntityAIWorkSmelter::isSmeltableToolOrWeapon), (IItemHandler)new InvWrapper((IInventory)this.worker.getInventoryCitizen()));
            }
            if ((slot = InventoryUtils.findFirstSlotInItemHandlerWith((IItemHandler)new InvWrapper((IInventory)this.worker.getInventoryCitizen()), EntityAIWorkSmelter::isSmeltableToolOrWeapon)) == -1) {
                return AIState.START_WORKING;
            }
            this.worker.setHeldItem(slot);
        }
        this.worker.hitBlockWithToolInHand(this.getOwnBuilding().getLocation());
        if (this.progress >= this.getRequiredProgressForMakingRawMaterial()) {
            this.progress = 0;
            slot = InventoryUtils.findFirstSlotInItemHandlerWith((IItemHandler)new InvWrapper((IInventory)this.worker.getInventoryCitizen()), EntityAIWorkSmelter::isSmeltableToolOrWeapon);
            if (slot == -1) {
                this.worker.func_184611_a(EnumHand.MAIN_HAND, ItemStackUtils.EMPTY);
                return AIState.START_WORKING;
            }
            ItemStack stack = new InvWrapper((IInventory)this.worker.getInventoryCitizen()).extractItem(slot, 1, false);
            Tuple<ItemStack, Integer> materialTuple = EntityAIWorkSmelter.getMaterialAndAmount(stack);
            ItemStack material = (ItemStack)materialTuple.func_76341_a();
            if (!ItemStackUtils.isEmpty(material).booleanValue()) {
                material.field_77994_a = (Integer)materialTuple.func_76340_b();
                material.func_77964_b(0);
                new InvWrapper((IInventory)this.worker.getInventoryCitizen()).setStackInSlot(slot, material);
                this.incrementActionsDone();
            } else {
                new InvWrapper((IInventory)this.worker.getInventoryCitizen()).setStackInSlot(slot, stack);
            }
            this.worker.addExperience(5.0);
            this.worker.func_184611_a(EnumHand.MAIN_HAND, ItemStackUtils.EMPTY);
            return AIState.START_WORKING;
        }
        ++this.progress;
        this.setDelay(20);
        return this.getState();
    }

    private static Tuple<ItemStack, Integer> getMaterialAndAmount(ItemStack stack) {
        int amount = 1;
        ItemStack material = ItemStackUtils.EMPTY;
        if (stack.func_77973_b() instanceof ItemSword) {
            material = Item.ToolMaterial.valueOf((String)((ItemSword)stack.func_77973_b()).func_150932_j()).getRepairItemStack();
        } else if (stack.func_77973_b() instanceof ItemTool) {
            material = Item.ToolMaterial.valueOf((String)((ItemTool)stack.func_77973_b()).func_77861_e()).getRepairItemStack();
        } else if (stack.func_77973_b() instanceof ItemArmor) {
            material = new ItemStack(((ItemArmor)stack.func_77973_b()).func_82812_d().func_151685_b());
            EntityEquipmentSlot eq = ((ItemArmor)stack.func_77973_b()).func_185083_B_();
            if (eq == EntityEquipmentSlot.CHEST) {
                amount = 8;
            } else if (eq == EntityEquipmentSlot.LEGS) {
                amount = 7;
            } else if (eq == EntityEquipmentSlot.HEAD) {
                amount = 5;
            } else if (eq == EntityEquipmentSlot.FEET) {
                amount = 4;
            }
        }
        return new Tuple((Object)material, (Object)amount);
    }

    private AIState getBurnableMaterial() {
        if (this.walkTo == null && this.walkToBuilding()) {
            return this.getState();
        }
        if (this.getOwnBuilding().getCountOfPredicateInHut(TileEntityFurnace::func_145954_b, 1, this.world) < 1) {
            if (!this.getOwnBuilding().hasWorkerOpenRequestsOfType(this.worker.getCitizenData(), TypeToken.of(Burnable.class))) {
                this.worker.getCitizenData().createRequestAsync(new Burnable(64));
            }
            this.setDelay(400);
        } else {
            if (this.walkTo == null) {
                BlockPos pos = this.getOwnBuilding().getTileEntity().getPositionOfChestWithItemStack(TileEntityFurnace::func_145954_b);
                if (pos == null) {
                    return AIState.START_WORKING;
                }
                this.walkTo = pos;
            }
            if (this.walkToBlock(this.walkTo)) {
                return this.getState();
            }
            boolean transfered = this.tryTransferFromPosToWorker(this.walkTo, TileEntityFurnace::func_145954_b);
            if (!transfered) {
                this.walkTo = null;
                return AIState.START_WORKING;
            }
            this.walkTo = null;
        }
        return AIState.SMELTER_SMELT_ORE;
    }

    private AIState retrieve() {
        if (this.walkTo == null) {
            return AIState.START_WORKING;
        }
        if (this.walkToBlock(this.walkTo)) {
            return this.getState();
        }
        TileEntity entity = this.world.func_175625_s(this.walkTo);
        if (!(entity instanceof TileEntityFurnace) || ((TileEntityFurnace)entity).func_145950_i() || ItemStackUtils.isEmpty(((TileEntityFurnace)entity).func_70301_a(2)).booleanValue() && ItemStackUtils.isEmpty(((TileEntityFurnace)entity).func_70301_a(0)).booleanValue()) {
            this.walkTo = null;
            return AIState.START_WORKING;
        }
        this.walkTo = null;
        this.gatherOreFromFurnaceWithChance((TileEntityFurnace)entity);
        if (!ItemStackUtils.isEmpty(((TileEntityFurnace)entity).func_70301_a(0)).booleanValue()) {
            if (!InventoryUtils.hasItemInItemHandler((IItemHandler)new InvWrapper((IInventory)this.worker.getInventoryCitizen()), TileEntityFurnace::func_145954_b)) {
                this.walkTo = null;
                return AIState.SMELTER_GET_FIREWOOD;
            }
            InventoryUtils.transferItemStackIntoNextFreeSlotInItemHandlers((IItemHandler)new InvWrapper((IInventory)this.worker.getInventoryCitizen()), InventoryUtils.findFirstSlotInItemHandlerWith((IItemHandler)new InvWrapper((IInventory)this.worker.getInventoryCitizen()), TileEntityFurnace::func_145954_b), (IItemHandler)new InvWrapper((IInventory)((TileEntityFurnace)entity)));
        }
        this.incrementActionsDone();
        this.setDelay(5);
        return AIState.START_WORKING;
    }

    private void gatherOreFromFurnaceWithChance(TileEntityFurnace furnace) {
        ItemStack copyStack;
        ItemStack ingots = new InvWrapper((IInventory)furnace).extractItem(2, 64, false);
        int multiplier = ((BuildingSmeltery)this.getOwnBuilding()).ingotMultiplier(this.worker.getCitizenData().getLevel(), this.worker.getRandom());
        for (int amount = ingots.field_77994_a * multiplier; amount > 0; amount -= copyStack.field_77994_a) {
            copyStack = ingots.func_77946_l();
            copyStack.field_77994_a = amount < ingots.func_77976_d() ? amount : ingots.func_77976_d();
            ItemStack resultStack = InventoryUtils.addItemStackToItemHandlerWithResult((IItemHandler)new InvWrapper((IInventory)this.worker.getInventoryCitizen()), copyStack);
            if (!ItemStackUtils.isEmpty(resultStack).booleanValue()) {
                resultStack.field_77994_a += amount / multiplier;
                new InvWrapper((IInventory)furnace).setStackInSlot(2, resultStack);
                return;
            }
            this.worker.addExperience(5.0);
        }
    }

    private AIState gatherOreFromBuilding() {
        BlockPos pos;
        if (this.needsCurrently == null) {
            this.needsCurrently = EntityAIWorkSmelter::isSmeltableOre;
        }
        if ((pos = this.getOwnBuilding().getTileEntity().getPositionOfChestWithItemStack(this.needsCurrently)) == null) {
            return AIState.START_WORKING;
        }
        if (this.walkToBlock(pos)) {
            return this.getState();
        }
        this.tryTransferFromPosToWorker(pos, this.needsCurrently);
        this.setDelay(5);
        return AIState.START_WORKING;
    }

    private AIState smeltOre() {
        if (((BuildingSmeltery)this.getOwnBuilding()).getFurnaces().isEmpty()) {
            this.chatSpamFilter.talkWithoutSpam("com.minecolonies.coremod.baker.noFurnace", new Object[0]);
            return AIState.START_WORKING;
        }
        if (!(InventoryUtils.hasItemInItemHandler((IItemHandler)new InvWrapper((IInventory)this.worker.getInventoryCitizen()), EntityAIWorkSmelter::isSmeltableOre) || this.walkTo != null && this.world.func_180495_p(this.walkTo).func_177230_c() == Blocks.field_150460_al)) {
            this.walkTo = null;
            this.needsCurrently = EntityAIWorkSmelter::isSmeltableOre;
            return AIState.SMELTER_GATHERING;
        }
        if (this.walkTo == null) {
            for (BlockPos pos : ((BuildingSmeltery)this.getOwnBuilding()).getFurnaces()) {
                TileEntity entity = this.world.func_175625_s(pos);
                if (!ItemStackUtils.isEmpty(((TileEntityFurnace)entity).func_70301_a(0)).booleanValue()) continue;
                this.walkTo = pos;
            }
        }
        if (this.walkTo == null) {
            return AIState.START_WORKING;
        }
        if (this.walkToBlock(this.walkTo)) {
            this.setDelay(2);
            return this.getState();
        }
        TileEntity entity = this.world.func_175625_s(this.walkTo);
        if (entity instanceof TileEntityFurnace) {
            InventoryUtils.transferXOfFirstSlotInItemHandlerWithIntoInItemHandler((IItemHandler)new InvWrapper((IInventory)this.worker.getInventoryCitizen()), EntityAIWorkSmelter::isSmeltableOre, 64, (IItemHandler)new InvWrapper((IInventory)((TileEntityFurnace)entity)), 0);
            if (ItemStackUtils.isEmpty(((TileEntityFurnace)entity).func_70301_a(1)).booleanValue()) {
                if (!InventoryUtils.hasItemInItemHandler((IItemHandler)new InvWrapper((IInventory)this.worker.getInventoryCitizen()), TileEntityFurnace::func_145954_b)) {
                    this.walkTo = null;
                    return AIState.SMELTER_GET_FIREWOOD;
                }
                InventoryUtils.transferXOfFirstSlotInItemHandlerWithIntoInItemHandler((IItemHandler)new InvWrapper((IInventory)this.worker.getInventoryCitizen()), TileEntityFurnace::func_145954_b, 64, (IItemHandler)new InvWrapper((IInventory)((TileEntityFurnace)entity)), 1);
            }
            this.walkTo = null;
            return AIState.START_WORKING;
        }
        this.walkTo = null;
        this.setDelay(5);
        return AIState.SMELTER_SMELT_ORE;
    }

    private BlockPos getPositionOfOvenToRetrieveFrom() {
        for (BlockPos pos : ((BuildingSmeltery)this.getOwnBuilding()).getFurnaces()) {
            TileEntity entity = this.world.func_175625_s(pos);
            if (!(entity instanceof TileEntityFurnace) || ((TileEntityFurnace)entity).func_145950_i() || ItemStackUtils.isEmpty(((TileEntityFurnace)entity).func_70301_a(2)).booleanValue() && ItemStackUtils.isEmpty(((TileEntityFurnace)entity).func_70301_a(0)).booleanValue()) continue;
            this.worker.setLatestStatus(new ITextComponent[]{new TextComponentTranslation("com.minecolonies.coremod.status.retrieving", new Object[0])});
            return pos;
        }
        return null;
    }

    @Override
    protected int getActionsDoneUntilDumping() {
        return 1;
    }

    private AIState startWorking() {
        BlockPos posOfOven = this.getPositionOfOvenToRetrieveFrom();
        if (posOfOven != null) {
            this.walkTo = posOfOven;
            return AIState.SMELTER_RETRIEVE_ORE;
        }
        int amountOfOre = this.getOwnBuilding().getCountOfPredicateInHut(EntityAIWorkSmelter::isSmeltableOre, 1, this.world) + InventoryUtils.getItemCountInItemHandler((IItemHandler)new InvWrapper((IInventory)this.worker.getInventoryCitizen()), EntityAIWorkSmelter::isSmeltableOre);
        if (amountOfOre <= 0) {
            this.worker.setLatestStatus(new ITextComponent[]{new TextComponentTranslation("com.minecolonies.coremod.status.gathering", new Object[0])});
            if (!this.getOwnBuilding().hasWorkerOpenRequestsOfType(this.worker.getCitizenData(), TypeToken.of(SmeltableOre.class))) {
                this.worker.getCitizenData().createRequestAsync(new SmeltableOre(64));
            }
        }
        return this.checkForAdditionalJobs();
    }

    private AIState checkForAdditionalJobs() {
        int amountOfTools = this.getOwnBuilding().getCountOfPredicateInHut(EntityAIWorkSmelter::isSmeltableToolOrWeapon, 1, this.world) + InventoryUtils.getItemCountInItemHandler((IItemHandler)new InvWrapper((IInventory)this.worker.getInventoryCitizen()), EntityAIWorkSmelter::isSmeltableToolOrWeapon);
        for (BlockPos pos : ((BuildingSmeltery)this.getOwnBuilding()).getFurnaces()) {
            TileEntity entity = this.world.func_175625_s(pos);
            if (entity instanceof TileEntityFurnace && !((TileEntityFurnace)entity).func_145950_i()) {
                if (!ItemStackUtils.isEmpty(((TileEntityFurnace)entity).func_70301_a(2)).booleanValue()) {
                    this.walkTo = pos;
                    this.worker.setLatestStatus(new ITextComponent[]{new TextComponentTranslation("com.minecolonies.coremod.status.retrieving", new Object[0])});
                    return AIState.SMELTER_RETRIEVE_ORE;
                }
                if (ItemStackUtils.isEmpty(((TileEntityFurnace)entity).func_70301_a(0)).booleanValue() && ItemStackUtils.isEmpty(((TileEntityFurnace)entity).func_70301_a(1)).booleanValue()) continue;
                this.worker.setLatestStatus(new ITextComponent[]{new TextComponentTranslation("com.minecolonies.coremod.status.cooking", new Object[0])});
                return AIState.SMELTER_SMELT_ORE;
            }
            if (amountOfTools <= 0) continue;
            return AIState.SMELTER_SMELT_STUFF;
        }
        if (amountOfTools > 0) {
            return AIState.SMELTER_SMELT_STUFF;
        }
        this.worker.setLatestStatus(new ITextComponent[]{new TextComponentTranslation("com.minecolonies.coremod.status.idling", new Object[0])});
        this.setDelay(5);
        return AIState.SMELTER_SMELT_ORE;
    }

    private static boolean isSmeltableOre(ItemStack stack) {
        return ItemStackUtils.isEmpty(stack) == false && ItemStackUtils.IS_SMELTABLE.and(itemStack -> itemStack.func_77973_b() instanceof ItemBlock && ColonyManager.getCompatabilityManager().isOre(((ItemBlock)itemStack.func_77973_b()).func_179223_d().func_176223_P())).test(stack);
    }

    private static boolean isSmeltableToolOrWeapon(ItemStack stack) {
        return ItemStackUtils.isEmpty(stack) == false && (stack.func_77973_b() instanceof ItemSword || stack.func_77973_b() instanceof ItemTool || stack.func_77973_b() instanceof ItemArmor) && !stack.func_77973_b().isDamaged(stack);
    }

    private int getRequiredProgressForMakingRawMaterial() {
        return 50 / Math.min(this.worker.getLevel() + 1, 50) * 5;
    }
}

