/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.citizen.miner;

import com.minecolonies.api.util.Vec2i;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.MathHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Node {
    private static final String TAG_X = "idX";
    private static final String TAG_Z = "idZ";
    private static final String TAG_STYLE = "Style";
    private static final String TAG_STATUS = "Status";
    private static final String TAG_PARENTX = "ParentX";
    private static final String TAG_PARENTZ = "ParentZ";
    private static final int DISTANCE_TO_NEXT_NODE = 7;
    private final int x;
    private final int z;
    @Nullable
    private final Vec2i parent;
    @NotNull
    private NodeType style;
    @NotNull
    private NodeStatus status;

    public Node(int x, int z, @Nullable Vec2i parent) {
        this.x = x;
        this.z = z;
        this.style = NodeType.CROSSROAD;
        this.status = NodeStatus.AVAILABLE;
        this.parent = parent;
    }

    @NotNull
    public static Node createFromNBT(@NotNull NBTTagCompound compound) {
        int z;
        int x;
        boolean hasDoubles = compound.func_150297_b(TAG_X, 6);
        if (hasDoubles) {
            x = MathHelper.func_76128_c((double)compound.func_74769_h(TAG_X));
            z = MathHelper.func_76128_c((double)compound.func_74769_h(TAG_Z));
        } else {
            x = compound.func_74762_e(TAG_X);
            z = compound.func_74762_e(TAG_Z);
        }
        NodeType style = NodeType.valueOf(compound.func_74779_i(TAG_STYLE));
        NodeStatus status = NodeStatus.valueOf(compound.func_74779_i(TAG_STATUS));
        Vec2i parent = null;
        if (compound.func_74764_b(TAG_PARENTX)) {
            parent = hasDoubles ? new Vec2i(MathHelper.func_76128_c((double)compound.func_74769_h(TAG_PARENTX)), MathHelper.func_76128_c((double)compound.func_74769_h(TAG_PARENTZ))) : new Vec2i(compound.func_74762_e(TAG_PARENTX), compound.func_74762_e(TAG_PARENTZ));
        }
        Node node = new Node(x, z, parent);
        node.setStyle(style);
        node.setStatus(status);
        return node;
    }

    public void writeToNBT(@NotNull NBTTagCompound compound) {
        compound.func_74768_a(TAG_X, this.x);
        compound.func_74768_a(TAG_Z, this.z);
        compound.func_74778_a(TAG_STYLE, this.style.name());
        compound.func_74778_a(TAG_STATUS, this.status.name());
        if (this.parent != null) {
            compound.func_74768_a(TAG_PARENTX, this.parent.getX());
            compound.func_74768_a(TAG_PARENTZ, this.parent.getZ());
        }
    }

    @NotNull
    public NodeStatus getStatus() {
        return this.status;
    }

    public void setStatus(@NotNull NodeStatus status) {
        this.status = status;
    }

    @Nullable
    public Vec2i getParent() {
        return this.parent;
    }

    @NotNull
    public String toString() {
        return "Node{x=" + this.x + ", z=" + this.z + ", style=" + (Object)((Object)this.style) + ", status=" + (Object)((Object)this.status) + '}';
    }

    @NotNull
    public NodeType getStyle() {
        return this.style;
    }

    public void setStyle(@NotNull NodeType style) {
        this.style = style;
    }

    public Vec2i getNorthNodeCenter() {
        return new Vec2i(this.getX(), this.getZ() - 7);
    }

    public int getX() {
        return this.x;
    }

    public int getZ() {
        return this.z;
    }

    public Vec2i getSouthNodeCenter() {
        return new Vec2i(this.getX(), this.getZ() + 7);
    }

    public Vec2i getEastNodeCenter() {
        return new Vec2i(this.getX() + 7, this.getZ());
    }

    public Vec2i getWestNodeCenter() {
        return new Vec2i(this.getX() - 7, this.getZ());
    }

    public static enum NodeType {
        SHAFT,
        LADDER_BACK,
        TUNNEL,
        CROSSROAD,
        BEND;

    }

    static enum NodeStatus {
        AVAILABLE,
        IN_PROGRESS,
        COMPLETED;

    }
}

