/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.citizen.herders;

import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.coremod.colony.jobs.JobCowboy;
import com.minecolonies.coremod.entity.ai.citizen.herders.AbstractEntityAIHerder;
import com.minecolonies.coremod.entity.ai.util.AIState;
import com.minecolonies.coremod.entity.ai.util.AITarget;
import java.util.List;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;

public class EntityAIWorkCowboy
extends AbstractEntityAIHerder<JobCowboy, EntityCow> {
    private static final int MAX_ANIMALS_PER_LEVEL = 2;

    public EntityAIWorkCowboy(@NotNull JobCowboy job) {
        super(job);
        this.itemsNeeded.add(new ItemStack(Items.field_151133_ar));
        super.registerTargets(new AITarget(AIState.COWBOY_MILK, this::milkCows));
    }

    @Override
    public ItemStack getBreedingItem() {
        return new ItemStack(Items.field_151015_O);
    }

    @Override
    public int getMaxAnimalMultiplier() {
        return 2;
    }

    @Override
    public Class<EntityCow> getAnimalClass() {
        return EntityCow.class;
    }

    @Override
    public AIState decideWhatToDo() {
        AIState result = super.decideWhatToDo();
        boolean hasBucket = InventoryUtils.hasItemInItemHandler((IItemHandler)new InvWrapper((IInventory)this.worker.getInventoryCitizen()), Items.field_151133_ar, 0);
        if (result.equals((Object)AIState.START_WORKING) && hasBucket) {
            return AIState.COWBOY_MILK;
        }
        return result;
    }

    @Override
    @NotNull
    protected List<ItemStack> itemsNiceToHave() {
        List<ItemStack> list = super.itemsNiceToHave();
        list.add(new ItemStack(Items.field_151133_ar, 1));
        return list;
    }

    private AIState milkCows() {
        EntityCow cow;
        this.worker.setLatestStatus(new ITextComponent[]{new TextComponentTranslation("com.minecolonies.coremod.status.cowboy.milking", new Object[0])});
        if (!this.worker.hasItemInInventory(this.getBreedingItem().func_77973_b(), 0) && this.isInHut(new ItemStack(Items.field_151133_ar, 1))) {
            if (!this.walkToBuilding() && this.getOwnBuilding() != null) {
                this.isInTileEntity((TileEntity)this.getOwnBuilding().getTileEntity(), new ItemStack(Items.field_151133_ar, 1));
            } else {
                return AIState.HERDER_DECIDE;
            }
        }
        if ((cow = (EntityCow)this.searchForAnimals().stream().findFirst().orElse(null)) == null) {
            return AIState.HERDER_DECIDE;
        }
        if (!this.walkingToAnimal((EntityAnimal)cow) && this.equipItem(new ItemStack(Items.field_151133_ar, 1))) {
            if (this.worker.getInventoryCitizen().addItemStackToInventory(new ItemStack(Items.field_151117_aB))) {
                this.worker.removeHeldItem();
                this.equipItem(new ItemStack(Items.field_151117_aB));
                InventoryUtils.removeStackFromItemHandler((IItemHandler)new InvWrapper((IInventory)this.worker.getInventoryCitizen()), new ItemStack(Items.field_151133_ar, 1));
            }
            this.incrementActionsDone();
        }
        return AIState.HERDER_DECIDE;
    }
}

