/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.citizen.guard;

import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.api.configuration.Configurations;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.CompatibilityUtils;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.LanguageHandler;
import com.minecolonies.api.util.Log;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingGuards;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingWorker;
import com.minecolonies.coremod.colony.jobs.JobGuard;
import com.minecolonies.coremod.entity.ai.basic.AbstractEntityAIInteract;
import com.minecolonies.coremod.entity.ai.mobs.util.BarbarianUtils;
import com.minecolonies.coremod.entity.ai.util.AIState;
import com.minecolonies.coremod.entity.ai.util.AITarget;
import com.minecolonies.coremod.tileentities.TileEntityColonyBuilding;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractEntityAIGuard
extends AbstractEntityAIInteract<JobGuard> {
    public static final int PATROL_DISTANCE = 40;
    public static final int FOLLOW_RANGE = 10;
    protected static final int START_SEARCH_DISTANCE = 5;
    private static final double MAX_ATTACK_DISTANCE = 20.0;
    private static final int BASE_DELAY = 1;
    private static final int BASE_MAX_ATTACKS = 25;
    private static final double HEIGHT_DETECTION_RANGE = 10.0;
    private static final int MAX_TRIES = 20;
    private static final int PATH_CLOSE = 2;
    private static final int DUMP_BASE = 5;
    private static final int ADDITIONAL_MAX_ATTACKS_PER_LEVEL = 5;
    private static final int SWITCH_TARGET_AFTER_TICKS = 10;
    private static final double LOW_HEALTH = 2.0;
    private static final int LENGTH_RANGE = 10;
    private static final int IN_TEN = 10;
    private static final int UP_DOWN_RANGE = 4;
    private static final int LAST_DIRECTION_CHANCE = 5;
    protected EntityLivingBase targetEntity;
    protected int attacksExecuted = 0;
    protected int currentSearchDistance = 5;
    private int dumpAfterActions = 5;
    private BlockPos currentPathTarget;
    private List<Entity> entityList;
    private BlockPos lastPos = null;
    private int ticksAtSamePos = 0;
    private Tuple<EnumFacing, EnumFacing> lastDirection = null;

    protected AbstractEntityAIGuard(@NotNull JobGuard job) {
        super(job);
        super.registerTargets(new AITarget(this::checkIfExecute, this::getState), new AITarget(AIState.IDLE, () -> AIState.START_WORKING), new AITarget(AIState.START_WORKING, () -> AIState.GUARD_RESTOCK), new AITarget(AIState.GUARD_GATHERING, this::gathering));
    }

    private boolean checkIfExecute() {
        AbstractBuildingWorker building = this.getOwnBuilding();
        if (!(building instanceof AbstractBuildingGuards)) {
            return true;
        }
        if (!((AbstractBuildingGuards)building).shallRetrieveOnLowHealth()) {
            return false;
        }
        if ((double)this.worker.func_110143_aJ() > 2.0) {
            return false;
        }
        this.worker.isWorkerAtSiteWithMove(building.getLocation(), 2);
        return true;
    }

    protected AIState goToBuilding() {
        if (this.walkToBuilding()) {
            return AIState.GUARD_RESTOCK;
        }
        AbstractBuildingWorker workBuilding = this.getOwnBuilding();
        if (workBuilding != null) {
            TileEntityColonyBuilding chest = workBuilding.getTileEntity();
            for (int i = 0; i < workBuilding.getTileEntity().func_70302_i_(); ++i) {
                int emptySlot;
                ItemStack stack = chest.func_70301_a(i);
                if (ItemStackUtils.isEmpty(stack).booleanValue()) continue;
                if (stack.func_77973_b() instanceof ItemArmor && this.worker.func_184582_a(((ItemArmor)stack.func_77973_b()).field_77881_a) == null && (emptySlot = InventoryUtils.findFirstSlotInItemHandlerWith((IItemHandler)new InvWrapper((IInventory)this.worker.getInventoryCitizen()), ItemStackUtils::isEmpty)) != -1) {
                    new InvWrapper((IInventory)this.worker.getInventoryCitizen()).insertItem(emptySlot, stack, false);
                    chest.func_70299_a(i, ItemStackUtils.EMPTY);
                }
                this.dumpAfterActions = 5 * workBuilding.getBuildingLevel();
            }
        }
        this.attacksExecuted = 0;
        return AIState.GUARD_SEARCH_TARGET;
    }

    @Override
    protected int getActionsDoneUntilDumping() {
        return this.dumpAfterActions;
    }

    @Override
    protected void updateRenderMetaData() {
        this.updateArmor();
    }

    protected void updateArmor() {
        this.worker.func_184201_a(EntityEquipmentSlot.CHEST, ItemStackUtils.EMPTY);
        this.worker.func_184201_a(EntityEquipmentSlot.FEET, ItemStackUtils.EMPTY);
        this.worker.func_184201_a(EntityEquipmentSlot.HEAD, ItemStackUtils.EMPTY);
        this.worker.func_184201_a(EntityEquipmentSlot.LEGS, ItemStackUtils.EMPTY);
        for (int i = 0; i < new InvWrapper((IInventory)this.worker.getInventoryCitizen()).getSlots(); ++i) {
            ItemStack stack = this.worker.getInventoryCitizen().func_70301_a(i);
            if (ItemStackUtils.isEmpty(stack).booleanValue()) {
                new InvWrapper((IInventory)this.worker.getInventoryCitizen()).extractItem(i, Integer.MAX_VALUE, false);
                continue;
            }
            if (!(stack.func_77973_b() instanceof ItemArmor) || this.worker.func_184582_a(((ItemArmor)stack.func_77973_b()).field_77881_a) != ItemStackUtils.EMPTY) continue;
            this.worker.func_184201_a(((ItemArmor)stack.func_77973_b()).field_77881_a, stack);
        }
    }

    protected AIState getTarget() {
        if (this.entityList.isEmpty()) {
            return AIState.GUARD_PATROL;
        }
        Entity entity = this.entityList.get(0);
        BlockPos buildingLocation = this.getOwnBuilding().getLocation();
        if (BlockPosUtil.getDistance2D(entity.func_180425_c(), buildingLocation) < (long)((AbstractBuildingGuards)this.getOwnBuilding()).getPatrolDistance()) {
            if (this.worker.func_70635_at().func_75522_a(entity) && this.entityList.get(0).func_70089_S()) {
                if (entity instanceof EntityPlayer) {
                    if (this.worker.getColony() != null && this.worker.getColony().getPermissions().hasPermission((EntityPlayer)entity, Action.GUARDS_ATTACK)) {
                        this.targetEntity = (EntityLivingBase)entity;
                        this.worker.getNavigator().func_75499_g();
                        return AIState.GUARD_HUNT_DOWN_TARGET;
                    }
                    this.entityList.remove(0);
                    this.setDelay(1);
                    return AIState.GUARD_GET_TARGET;
                }
                this.worker.setLatestStatus(new ITextComponent[]{new TextComponentTranslation("com.minecolonies.coremod.status.hunting", new Object[0])});
                this.worker.getNavigator().func_75499_g();
                this.targetEntity = (EntityLivingBase)entity;
                return AIState.GUARD_HUNT_DOWN_TARGET;
            }
            if (!this.entityList.get(0).func_70089_S()) {
                return AIState.GUARD_GATHERING;
            }
        }
        this.entityList.remove(0);
        this.setDelay(1);
        return AIState.GUARD_GET_TARGET;
    }

    protected AIState searchTarget() {
        if (this.huntDownlastAttacker()) {
            this.targetEntity = this.worker.func_110144_aD();
            return AIState.GUARD_HUNT_DOWN_TARGET;
        }
        if (this.targetEntity == null) {
            this.targetEntity = BarbarianUtils.getClosestBarbarianToEntity((Entity)this.worker, this.currentSearchDistance);
        }
        this.entityList = CompatibilityUtils.getWorld((Entity)this.worker).func_72872_a(EntityMob.class, this.getTargetableArea(this.currentSearchDistance));
        this.entityList.addAll(CompatibilityUtils.getWorld((Entity)this.worker).func_72872_a(EntitySlime.class, this.getTargetableArea(this.currentSearchDistance)));
        this.entityList.addAll(CompatibilityUtils.getWorld((Entity)this.worker).func_72872_a(EntityPlayer.class, this.getTargetableArea(this.currentSearchDistance)));
        if (this.targetEntity != null && this.targetEntity.func_70089_S() && this.worker.func_70635_at().func_75522_a((Entity)this.targetEntity)) {
            return AIState.GUARD_HUNT_DOWN_TARGET;
        }
        this.setDelay(1);
        if (this.entityList.isEmpty()) {
            if ((double)this.currentSearchDistance < this.getMaxVision()) {
                this.currentSearchDistance += 5;
            } else {
                this.currentSearchDistance = 5;
                return AIState.GUARD_PATROL;
            }
            return AIState.GUARD_SEARCH_TARGET;
        }
        return AIState.GUARD_GET_TARGET;
    }

    public boolean huntDownlastAttacker() {
        if (this.worker.func_110144_aD() != null && this.worker.func_142013_aG() >= this.worker.field_70173_aa - 50 && this.worker.func_110144_aD().func_70089_S()) {
            return this.worker.func_110144_aD() != null && this.worker.func_70685_l((Entity)this.worker.func_110144_aD());
        }
        this.worker.func_130011_c(null);
        return false;
    }

    private AxisAlignedBB getTargetableArea(double range) {
        return this.worker.func_174813_aQ().func_72314_b(range, 10.0, range);
    }

    private double getMaxVision() {
        AbstractBuildingGuards guardTower = (AbstractBuildingGuards)this.worker.getWorkBuilding();
        return guardTower == null ? 0.0 : 20.0 + (double)guardTower.getBonusVision();
    }

    protected int getMaxAttacksUntilRestock() {
        AbstractBuildingGuards guardTower = (AbstractBuildingGuards)this.worker.getWorkBuilding();
        return guardTower == null ? 0 : 25 + guardTower.getBuildingLevel() * 5;
    }

    protected AIState patrol() {
        this.worker.func_70659_e(1.0f);
        AbstractBuildingWorker building = this.getOwnBuilding();
        if (this.worker.func_180425_c().equals((Object)this.lastPos)) {
            ++this.ticksAtSamePos;
        } else {
            this.ticksAtSamePos = 0;
            this.lastPos = this.worker.func_180425_c();
        }
        if (building instanceof AbstractBuildingGuards) {
            if (this.currentPathTarget == null || BlockPosUtil.getDistance2D(building.getColony().getCenter(), this.currentPathTarget) > (long)(Configurations.Gameplay.workingRangeTownHall + Configurations.Gameplay.townHallPadding) || this.currentPathTarget.func_177956_o() < 2) {
                return this.getNextPatrollingTarget((AbstractBuildingGuards)building);
            }
            if (this.worker.isWorkerAtSiteWithMove(this.currentPathTarget, 2) || ((AbstractBuildingGuards)building).getTask().equals((Object)AbstractBuildingGuards.Task.FOLLOW) || this.ticksAtSamePos >= 10) {
                return this.getNextPatrollingTarget((AbstractBuildingGuards)building);
            }
        }
        return AIState.GUARD_SEARCH_TARGET;
    }

    private AIState getNextPatrollingTarget(AbstractBuildingGuards building) {
        if (building.shallPatrolManually() && building.getTask().equals((Object)AbstractBuildingGuards.Task.PATROL)) {
            this.worker.setLatestStatus(new ITextComponent[]{new TextComponentTranslation("com.minecolonies.coremod.status.patrolling", new Object[0])});
            BlockPos pos = building.getNextPatrolTarget(this.currentPathTarget);
            if (pos != null) {
                this.currentPathTarget = pos;
                return AIState.GUARD_SEARCH_TARGET;
            }
        } else {
            if (building.getTask().equals((Object)AbstractBuildingGuards.Task.GUARD)) {
                this.worker.setLatestStatus(new ITextComponent[]{new TextComponentTranslation("com.minecolonies.coremod.status.guarding", new Object[0])});
                BlockPos pos = building.getGuardPos();
                if (pos == null) {
                    pos = building.getLocation();
                }
                this.currentPathTarget = pos;
                return AIState.GUARD_SEARCH_TARGET;
            }
            if (building.getTask().equals((Object)AbstractBuildingGuards.Task.FOLLOW)) {
                this.worker.setLatestStatus(new ITextComponent[]{new TextComponentTranslation("com.minecolonies.coremod.status.following", new Object[0])});
                BlockPos pos = building.getPlayerToFollow();
                if (pos == null || BlockPosUtil.getDistance2D(pos, building.getColony().getCenter()) > (long)(Configurations.Gameplay.workingRangeTownHall + Configurations.Gameplay.townHallPadding)) {
                    EntityPlayer player;
                    if (pos != null) {
                        Log.getLogger().info((Object)BlockPosUtil.getDistance2D(pos, building.getColony().getCenter()));
                    }
                    if ((player = building.getPlayer()) != null) {
                        LanguageHandler.sendPlayerMessage(building.getPlayer(), "com.minecolonies.coremod.job.guard.switch", new Object[0]);
                    }
                    pos = building.getLocation();
                    building.setTask(AbstractBuildingGuards.Task.GUARD);
                }
                this.currentPathTarget = pos;
                return AIState.GUARD_SEARCH_TARGET;
            }
        }
        this.worker.setLatestStatus(new ITextComponent[]{new TextComponentTranslation("com.minecolonies.coremod.status.patrolling", new Object[0])});
        this.currentPathTarget = this.getRandomBuilding();
        return AIState.GUARD_SEARCH_TARGET;
    }

    private BlockPos getRandomBuilding() {
        if (this.worker.getColony() == null || this.getOwnBuilding() == null) {
            return this.worker.func_180425_c();
        }
        Random random = new Random();
        int tries = 0;
        BlockPos pos = null;
        while (pos == null || this.world.func_180495_p(pos).func_185904_a().func_76224_d() || !this.world.func_180495_p(pos.func_177977_b()).func_185904_a().func_76220_a() || !this.world.func_175623_d(pos) && !this.world.func_175623_d(pos.func_177984_a())) {
            Tuple<EnumFacing, EnumFacing> direction = this.getRandomDirectionTuple(random);
            pos = new BlockPos((Vec3i)this.worker.func_180425_c()).func_177967_a((EnumFacing)direction.func_76341_a(), random.nextInt(10)).func_177967_a((EnumFacing)direction.func_76340_b(), random.nextInt(10)).func_177981_b(random.nextInt(4)).func_177979_c(random.nextInt(4));
            this.lastDirection = direction;
            if (tries >= 20) {
                return this.getOwnBuilding().getLocation();
            }
            ++tries;
        }
        if (BlockPosUtil.getDistance2D(pos, this.getOwnBuilding().getLocation()) > (long)((AbstractBuildingGuards)this.getOwnBuilding()).getPatrolDistance()) {
            return this.getOwnBuilding().getLocation();
        }
        return pos;
    }

    private Tuple<EnumFacing, EnumFacing> getRandomDirectionTuple(Random random) {
        if (this.lastDirection != null && random.nextInt(10) < 5) {
            return this.lastDirection;
        }
        return new Tuple((Object)EnumFacing.func_176741_a((Random)random), (Object)EnumFacing.func_176741_a((Random)random));
    }

    public boolean shouldReturnToTarget(BlockPos target, double range) {
        AbstractBuildingWorker building = this.getOwnBuilding();
        if (this.currentPathTarget == null) {
            this.getNextPatrollingTarget((AbstractBuildingGuards)building);
        }
        return building instanceof AbstractBuildingGuards && (double)BlockPosUtil.getDistance2D(target, this.currentPathTarget) > (double)((AbstractBuildingGuards)building).getPatrolDistance() + range;
    }

    protected void onKilledEntity(EntityLivingBase killedEntity) {
        Colony colony = this.getOwnBuilding().getColony();
        colony.getStatsManager().incrementStatistic("mobs");
        this.incrementActionsDone();
        this.worker.getNavigator().func_75499_g();
    }

    private AIState gathering() {
        this.worker.setLatestStatus(new ITextComponent[]{new TextComponentTranslation("com.minecolonies.coremod.status.gathering", new Object[0])});
        if (this.getItemsForPickUp() == null) {
            this.fillItemsList();
        }
        if (this.getItemsForPickUp() != null && !this.getItemsForPickUp().isEmpty()) {
            this.gatherItems();
            return this.getState();
        }
        this.resetGatheringItems();
        return AIState.GUARD_PATROL;
    }
}

