/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.citizen.farmer;

import com.minecolonies.api.compatibility.Compatibility;
import com.minecolonies.api.util.BlockUtils;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.constant.ToolType;
import com.minecolonies.coremod.blocks.BlockHutField;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.buildings.BuildingFarmer;
import com.minecolonies.coremod.colony.jobs.JobFarmer;
import com.minecolonies.coremod.entity.EntityCitizen;
import com.minecolonies.coremod.entity.ai.basic.AbstractEntityAIInteract;
import com.minecolonies.coremod.entity.ai.util.AIState;
import com.minecolonies.coremod.entity.ai.util.AITarget;
import com.minecolonies.coremod.tileentities.ScarecrowTileEntity;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.BlockStem;
import net.minecraft.block.IGrowable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityAIWorkFarmer
extends AbstractEntityAIInteract<JobFarmer> {
    private static final int STANDARD_DELAY = 40;
    private static final int SMALLEST_DELAY = 1;
    private static final double DELAY_DIVIDER = 1.0;
    private static final double XP_PER_HARVEST = 0.5;
    private boolean shouldDumpInventory = false;
    @Nullable
    private BlockPos workingOffset;
    @Nullable
    private BlockPos prevPos;
    private int totalDis;
    private int dist;
    private boolean horizontal;

    public EntityAIWorkFarmer(@NotNull JobFarmer job) {
        super(job);
        super.registerTargets(new AITarget(AIState.IDLE, () -> AIState.START_WORKING), new AITarget(AIState.START_WORKING, this::startWorkingAtOwnBuilding), new AITarget(AIState.PREPARING, this::prepareForFarming), new AITarget(AIState.FARMER_HOE, this::workAtField), new AITarget(AIState.FARMER_PLANT, this::workAtField), new AITarget(AIState.FARMER_HARVEST, this::workAtField));
        this.worker.setSkillModifier(2 * this.worker.getCitizenData().getEndurance() + this.worker.getCitizenData().getCharisma());
        this.worker.func_98053_h(true);
    }

    private AIState startWorkingAtOwnBuilding() {
        if (this.walkToBuilding()) {
            return this.getState();
        }
        return AIState.PREPARING;
    }

    @NotNull
    private AIState prepareForFarming() {
        BuildingFarmer building = this.getOwnBuilding();
        if (building == null || building.getBuildingLevel() < 1) {
            return AIState.PREPARING;
        }
        building.syncWithColony(this.world);
        if (building.getFarmerFields().size() < this.getOwnBuilding().getBuildingLevel() && !building.assignManually()) {
            this.searchAndAddFields();
        }
        if (building.hasNoFields()) {
            this.chatSpamFilter.talkWithoutSpam("entity.farmer.noFreeFields", new Object[0]);
            return AIState.PREPARING;
        }
        if (building.getCurrentField() == null && building.getFieldToWorkOn(this.world) == null) {
            building.resetFields();
            return AIState.IDLE;
        }
        BlockPos currentField = building.getCurrentField();
        TileEntity entity = this.world.func_175625_s(currentField);
        if (entity instanceof ScarecrowTileEntity && ((ScarecrowTileEntity)entity).needsWork()) {
            if (((ScarecrowTileEntity)entity).getFieldStage() == ScarecrowTileEntity.FieldStage.PLANTED && this.checkIfShouldExecute((ScarecrowTileEntity)entity, this::shouldHarvest)) {
                return AIState.FARMER_HARVEST;
            }
            if (((ScarecrowTileEntity)entity).getFieldStage() == ScarecrowTileEntity.FieldStage.HOED) {
                return this.canGoPlanting((ScarecrowTileEntity)entity, building);
            }
            if (((ScarecrowTileEntity)entity).getFieldStage() == ScarecrowTileEntity.FieldStage.EMPTY && this.checkIfShouldExecute((ScarecrowTileEntity)entity, this::shouldHoe)) {
                return AIState.FARMER_HOE;
            }
            ((ScarecrowTileEntity)entity).nextState();
        } else {
            this.getOwnBuilding().setCurrentField(null);
        }
        return AIState.PREPARING;
    }

    @Override
    public BuildingFarmer getOwnBuilding() {
        return (BuildingFarmer)this.worker.getWorkBuilding();
    }

    private void searchAndAddFields() {
        ScarecrowTileEntity newField;
        Colony colony = this.worker.getColony();
        if (colony != null && (newField = colony.getBuildingManager().getFreeField(this.worker.getCitizenData().getId(), this.world)) != null && this.getOwnBuilding() != null) {
            newField.setOwner(this.worker.getCitizenData().getId());
            newField.setTaken(true);
            newField.func_70296_d();
            this.getOwnBuilding().addFarmerFields(newField.func_174877_v());
        }
    }

    private boolean checkIfShouldExecute(@NotNull ScarecrowTileEntity field, @NotNull Predicate<BlockPos> predicate) {
        if (this.workingOffset == null) {
            this.handleOffset(field);
        }
        BlockPos position = field.func_174877_v().func_177977_b().func_177970_e(this.workingOffset.func_177952_p()).func_177965_g(this.workingOffset.func_177958_n());
        while (!predicate.test(position)) {
            if (!this.handleOffset(field)) {
                return false;
            }
            position = field.func_174877_v().func_177977_b().func_177970_e(this.workingOffset.func_177952_p()).func_177965_g(this.workingOffset.func_177958_n());
        }
        return true;
    }

    private AIState canGoPlanting(@NotNull ScarecrowTileEntity currentField, @NotNull BuildingFarmer buildingFarmer) {
        if (currentField.getSeed() == null) {
            this.chatSpamFilter.talkWithoutSpam("entity.farmer.noSeedSet", new Object[0]);
            buildingFarmer.setCurrentField(null);
            return AIState.PREPARING;
        }
        ItemStack seeds = currentField.getSeed();
        int slot = this.worker.findFirstSlotInInventoryWith(seeds.func_77973_b(), seeds.func_77952_i());
        if (slot != -1) {
            return AIState.FARMER_PLANT;
        }
        if (this.walkToBuilding()) {
            return AIState.PREPARING;
        }
        this.checkIfRequestForItemExistOrCreateAsynch(seeds);
        currentField.nextState();
        return AIState.PREPARING;
    }

    private boolean handleOffset(@NotNull ScarecrowTileEntity field) {
        if (this.workingOffset == null) {
            this.workingOffset = new BlockPos(0, 0, 0);
            this.totalDis = 1;
            this.dist = 0;
            this.horizontal = true;
        } else {
            if (this.workingOffset.func_177952_p() >= field.getWidthPlusZ() && this.workingOffset.func_177958_n() <= -field.getLengthMinusX()) {
                this.workingOffset = null;
                return false;
            }
            if (this.totalDis == this.dist) {
                this.horizontal = !this.horizontal;
                this.dist = 0;
                if (this.horizontal) {
                    ++this.totalDis;
                }
            }
            this.workingOffset = this.horizontal ? new BlockPos((double)this.workingOffset.func_177958_n(), 0.0, (double)this.workingOffset.func_177952_p() - Math.pow(-1.0, this.totalDis)) : new BlockPos((double)this.workingOffset.func_177958_n() - Math.pow(-1.0, this.totalDis), 0.0, (double)this.workingOffset.func_177952_p());
            ++this.dist;
        }
        return true;
    }

    @Override
    protected boolean wantInventoryDumped() {
        if (this.shouldDumpInventory) {
            this.shouldDumpInventory = false;
            return true;
        }
        return false;
    }

    private AIState workAtField() {
        BuildingFarmer buildingFarmer = this.getOwnBuilding();
        if (buildingFarmer == null || this.checkForToolOrWeapon(ToolType.HOE) || buildingFarmer.getCurrentField() == null) {
            return AIState.PREPARING;
        }
        BlockPos field = buildingFarmer.getCurrentField();
        TileEntity entity = this.world.func_175625_s(field);
        if (entity instanceof ScarecrowTileEntity) {
            if (this.workingOffset != null) {
                BlockPos position = field.func_177977_b().func_177970_e(this.workingOffset.func_177952_p()).func_177965_g(this.workingOffset.func_177958_n());
                if (this.walkToBlock(position.func_177984_a())) {
                    return this.getState();
                }
                switch (this.getState()) {
                    case FARMER_HOE: {
                        this.worker.setLatestStatus(new ITextComponent[]{new TextComponentTranslation("com.minecolonies.coremod.status.hoeing", new Object[0])});
                        if (this.hoeIfAble(position)) break;
                        return this.getState();
                    }
                    case FARMER_PLANT: {
                        this.worker.setLatestStatus(new ITextComponent[]{new TextComponentTranslation("com.minecolonies.coremod.status.planting", new Object[0])});
                        if (this.tryToPlant((ScarecrowTileEntity)entity, position)) break;
                        return AIState.PREPARING;
                    }
                    case FARMER_HARVEST: {
                        this.worker.setLatestStatus(new ITextComponent[]{new TextComponentTranslation("com.minecolonies.coremod.status.harvesting", new Object[0])});
                        if (this.harvestIfAble(position)) break;
                        return this.getState();
                    }
                    default: {
                        return AIState.PREPARING;
                    }
                }
                this.prevPos = position;
            }
            this.setDelay(this.getLevelDelay());
            if (!this.handleOffset((ScarecrowTileEntity)entity)) {
                this.shouldDumpInventory = true;
                ((ScarecrowTileEntity)entity).nextState();
                this.prevPos = null;
                return AIState.IDLE;
            }
        }
        return this.getState();
    }

    private boolean hoeIfAble(BlockPos position) {
        if (this.shouldHoe(position) && !this.checkForToolOrWeapon(ToolType.HOE)) {
            if (this.mineBlock(position.func_177984_a())) {
                this.equipHoe();
                this.worker.func_184609_a(this.worker.func_184600_cs());
                this.world.func_175656_a(position, Blocks.field_150458_ak.func_176223_P());
                this.worker.damageItemInHand(1);
                return true;
            }
            return false;
        }
        return true;
    }

    private boolean tryToPlant(ScarecrowTileEntity field, BlockPos position) {
        return !this.shouldPlant(position, field) || this.plantCrop(field.getSeed(), position);
    }

    private boolean harvestIfAble(BlockPos position) {
        if (this.shouldHarvest(position)) {
            this.worker.addExperience(0.5);
            if (Compatibility.isPamsInstalled()) {
                this.harvestCrop(position.func_177984_a());
                return true;
            }
            return this.mineBlock(position.func_177984_a());
        }
        return true;
    }

    @Override
    protected int getLevelDelay() {
        return (int)Math.max(1.0, 40.0 - (double)this.worker.getLevel() * 1.0);
    }

    private boolean shouldHoe(@NotNull BlockPos position) {
        return !BlockUtils.isBlockSeed(this.world, position.func_177984_a()) && !(this.world.func_180495_p(position.func_177984_a()).func_177230_c() instanceof BlockHutField) && (this.world.func_180495_p(position).func_177230_c() == Blocks.field_150346_d || this.world.func_180495_p(position).func_177230_c() == Blocks.field_150349_c);
    }

    private void equipHoe() {
        this.worker.setHeldItem(this.getHoeSlot());
    }

    private boolean shouldPlant(@NotNull BlockPos position, @NotNull ScarecrowTileEntity field) {
        return !field.isNoPartOfField(this.world, position) && !(this.world.func_180495_p(position.func_177984_a()).func_177230_c() instanceof BlockCrops) && !(this.world.func_180495_p(position.func_177984_a()).func_177230_c() instanceof BlockStem) && !(this.world.func_180495_p(position).func_177230_c() instanceof BlockHutField) && this.world.func_180495_p(position).func_177230_c() == Blocks.field_150458_ak;
    }

    private boolean plantCrop(ItemStack item, @NotNull BlockPos position) {
        int slot = this.worker.findFirstSlotInInventoryWith(item.func_77973_b(), item.func_77952_i());
        if (slot == -1) {
            return false;
        }
        IPlantable seed = (IPlantable)item.func_77973_b();
        if (!(seed != Items.field_151081_bc && seed != Items.field_151080_bb || this.prevPos == null || this.world.func_175623_d(this.prevPos.func_177984_a()))) {
            return true;
        }
        this.world.func_175656_a(position.func_177984_a(), seed.getPlant((IBlockAccess)this.world, position));
        new InvWrapper((IInventory)this.getInventory()).extractItem(slot, 1, false);
        return true;
    }

    private boolean shouldHarvest(@NotNull BlockPos position) {
        IBlockState state = this.world.func_180495_p(position.func_177984_a());
        Block block = state.func_177230_c();
        if (block == Blocks.field_150423_aK || block == Blocks.field_150440_ba) {
            return true;
        }
        if (block instanceof IGrowable && block instanceof BlockCrops && !(block instanceof BlockStem)) {
            BlockCrops crop = (BlockCrops)block;
            return crop.func_185525_y(state);
        }
        return false;
    }

    private void harvestCrop(@NotNull BlockPos pos) {
        ItemStack tool = this.worker.func_184614_ca();
        int fortune = ItemStackUtils.getFortuneOf(tool);
        IBlockState state = this.world.func_180495_p(pos);
        List drops = state.func_177230_c().getDrops((IBlockAccess)this.world, pos, state, fortune);
        for (ItemStack item : drops) {
            InventoryUtils.addItemStackToItemHandler((IItemHandler)new InvWrapper((IInventory)this.worker.getInventoryCitizen()), item);
        }
        if (state.func_177230_c() instanceof BlockCrops) {
            BlockCrops crops = (BlockCrops)state.func_177230_c();
            this.world.func_175656_a(pos, crops.func_185528_e(0));
        }
        this.worker.addExperience(0.05);
        this.incrementActionsDone();
    }

    private int getHoeSlot() {
        return InventoryUtils.getFirstSlotOfItemHandlerContainingTool((IItemHandler)new InvWrapper((IInventory)this.getInventory()), ToolType.HOE, 0, this.getOwnBuilding().getMaxToolLevel());
    }

    @Nullable
    public EntityCitizen getCitizen() {
        return this.worker;
    }
}

