/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.citizen.cook;

import com.google.common.reflect.TypeToken;
import com.minecolonies.api.colony.requestsystem.requestable.Burnable;
import com.minecolonies.api.colony.requestsystem.requestable.Food;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.coremod.colony.buildings.BuildingCook;
import com.minecolonies.coremod.colony.jobs.JobCook;
import com.minecolonies.coremod.entity.EntityCitizen;
import com.minecolonies.coremod.entity.ai.basic.AbstractEntityAISkill;
import com.minecolonies.coremod.entity.ai.util.AIState;
import com.minecolonies.coremod.entity.ai.util.AITarget;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;

public class EntityAIWorkCook
extends AbstractEntityAISkill<JobCook> {
    private static final int CHARISMA_MULTIPLIER = 2;
    private static final int INTELLIGENCE_MULTIPLIER = 1;
    private static final int LEAST_KEEP_FOOD_MULTIPLIER = 64;
    private static final int AMOUNT_OF_FOOD_TO_SERVE = 3;
    private static final int SERVE_DELAY = 30;
    private static final int STANDARD_DELAY = 5;
    private static final int WAIT_AFTER_REQUEST = 400;
    private static final int RESULT_SLOT = 2;
    private static final int COOK_SLOT = 0;
    private static final int FUEL_SLOT = 1;
    private final List<EntityCitizen> citizenToServe = new ArrayList<EntityCitizen>();
    private BlockPos walkTo = null;
    private AxisAlignedBB range = null;
    private Predicate<ItemStack> needsCurrently = null;

    public EntityAIWorkCook(@NotNull JobCook job) {
        super(job);
        super.registerTargets(new AITarget(AIState.IDLE, AIState.START_WORKING), new AITarget(AIState.START_WORKING, this::startWorking), new AITarget(AIState.COOK_GATHERING, this::gatherFoodFromBuilding), new AITarget(AIState.COOK_COOK_FOOD, this::cookFood), new AITarget(AIState.COOK_SERVE, this::serveFood), new AITarget(AIState.COOK_RETRIEVE_FOOD, this::retrieve), new AITarget(AIState.COOK_GET_FIREWOOD, this::getBurnableMaterial));
        this.worker.setSkillModifier(2 * this.worker.getCitizenData().getCharisma() + 1 * this.worker.getCitizenData().getIntelligence());
        this.worker.func_98053_h(true);
    }

    private AIState getBurnableMaterial() {
        if (this.walkTo == null && this.walkToBuilding()) {
            return this.getState();
        }
        if (this.getOwnBuilding().getCountOfPredicateInHut(TileEntityFurnace::func_145954_b, 1, this.world) < 1) {
            if (!this.getOwnBuilding().hasWorkerOpenRequestsOfType(this.worker.getCitizenData(), TypeToken.of(Burnable.class))) {
                this.worker.getCitizenData().createRequestAsync(new Burnable(64));
            }
            this.setDelay(400);
        } else {
            if (this.walkTo == null) {
                BlockPos pos = this.getOwnBuilding().getTileEntity().getPositionOfChestWithItemStack(TileEntityFurnace::func_145954_b);
                if (pos == null) {
                    return AIState.START_WORKING;
                }
                this.walkTo = pos;
            }
            if (this.walkToBlock(this.walkTo)) {
                return this.getState();
            }
            boolean transfered = this.tryTransferFromPosToWorker(this.walkTo, TileEntityFurnace::func_145954_b);
            if (!transfered) {
                this.walkTo = null;
                return AIState.START_WORKING;
            }
            this.walkTo = null;
        }
        return AIState.COOK_COOK_FOOD;
    }

    private AIState retrieve() {
        if (this.walkTo == null) {
            return AIState.START_WORKING;
        }
        if (this.walkToBlock(this.walkTo)) {
            return this.getState();
        }
        TileEntity entity = this.world.func_175625_s(this.walkTo);
        if (!(entity instanceof TileEntityFurnace) || ((TileEntityFurnace)entity).func_145950_i() || ItemStackUtils.isEmpty(((TileEntityFurnace)entity).func_70301_a(2)).booleanValue() && ItemStackUtils.isEmpty(((TileEntityFurnace)entity).func_70301_a(0)).booleanValue()) {
            this.walkTo = null;
            return AIState.START_WORKING;
        }
        this.walkTo = null;
        InventoryUtils.transferItemStackIntoNextFreeSlotInItemHandlers((IItemHandler)new InvWrapper((IInventory)((TileEntityFurnace)entity)), 2, (IItemHandler)new InvWrapper((IInventory)this.worker.getInventoryCitizen()));
        if (!ItemStackUtils.isEmpty(((TileEntityFurnace)entity).func_70301_a(0)).booleanValue()) {
            if (!InventoryUtils.hasItemInItemHandler((IItemHandler)new InvWrapper((IInventory)this.worker.getInventoryCitizen()), TileEntityFurnace::func_145954_b)) {
                this.walkTo = null;
                return AIState.COOK_GET_FIREWOOD;
            }
            InventoryUtils.transferItemStackIntoNextFreeSlotInItemHandlers((IItemHandler)new InvWrapper((IInventory)this.worker.getInventoryCitizen()), InventoryUtils.findFirstSlotInItemHandlerWith((IItemHandler)new InvWrapper((IInventory)this.worker.getInventoryCitizen()), TileEntityFurnace::func_145954_b), (IItemHandler)new InvWrapper((IInventory)((TileEntityFurnace)entity)));
        }
        this.incrementActionsDone();
        this.setDelay(5);
        return AIState.START_WORKING;
    }

    private AIState gatherFoodFromBuilding() {
        if (this.needsCurrently == null) {
            this.needsCurrently = ItemStackUtils.ISFOOD;
        }
        if (InventoryUtils.hasItemInItemHandler((IItemHandler)new InvWrapper((IInventory)this.worker.getInventoryCitizen()), this.needsCurrently)) {
            return AIState.COOK_SERVE;
        }
        BlockPos pos = this.getOwnBuilding().getTileEntity().getPositionOfChestWithItemStack(this.needsCurrently);
        if (pos == null) {
            return AIState.START_WORKING;
        }
        if (this.walkToBlock(pos)) {
            return this.getState();
        }
        boolean transfered = this.tryTransferFromPosToWorker(pos, this.needsCurrently);
        if (transfered) {
            return AIState.COOK_SERVE;
        }
        this.setDelay(5);
        return AIState.START_WORKING;
    }

    private AIState serveFood() {
        if (this.citizenToServe.isEmpty()) {
            return AIState.START_WORKING;
        }
        if (this.walkToBlock(this.citizenToServe.get(0).func_180425_c())) {
            this.setDelay(2);
            return this.getState();
        }
        InventoryUtils.transferXOfFirstSlotInItemHandlerWithIntoNextFreeSlotInItemHandler((IItemHandler)new InvWrapper((IInventory)this.worker.getInventoryCitizen()), ItemStackUtils.ISFOOD, 3, (IItemHandler)new InvWrapper((IInventory)this.citizenToServe.get(0).getInventoryCitizen()));
        this.citizenToServe.remove(0);
        this.setDelay(30);
        return this.getState();
    }

    private AIState cookFood() {
        if (((BuildingCook)this.getOwnBuilding()).getFurnaces().isEmpty()) {
            this.chatSpamFilter.talkWithoutSpam("com.minecolonies.coremod.baker.noFurnace", new Object[0]);
            return AIState.START_WORKING;
        }
        if (!(InventoryUtils.hasItemInItemHandler((IItemHandler)new InvWrapper((IInventory)this.worker.getInventoryCitizen()), ItemStackUtils.ISCOOKABLE) || this.walkTo != null && this.world.func_180495_p(this.walkTo).func_177230_c() == Blocks.field_150460_al)) {
            this.walkTo = null;
            this.needsCurrently = ItemStackUtils.ISCOOKABLE;
            return AIState.COOK_GATHERING;
        }
        if (this.walkTo == null) {
            for (BlockPos pos : ((BuildingCook)this.getOwnBuilding()).getFurnaces()) {
                TileEntity entity = this.world.func_175625_s(pos);
                if (!ItemStackUtils.isEmpty(((TileEntityFurnace)entity).func_70301_a(0)).booleanValue()) continue;
                this.walkTo = pos;
            }
        }
        if (this.walkTo == null) {
            return AIState.START_WORKING;
        }
        if (this.walkToBlock(this.walkTo)) {
            this.setDelay(2);
            return this.getState();
        }
        TileEntity entity = this.world.func_175625_s(this.walkTo);
        if (entity instanceof TileEntityFurnace) {
            InventoryUtils.transferXOfFirstSlotInItemHandlerWithIntoInItemHandler((IItemHandler)new InvWrapper((IInventory)this.worker.getInventoryCitizen()), ItemStackUtils.ISCOOKABLE, 64, (IItemHandler)new InvWrapper((IInventory)((TileEntityFurnace)entity)), 0);
            if (ItemStackUtils.isEmpty(((TileEntityFurnace)entity).func_70301_a(1)).booleanValue()) {
                if (!InventoryUtils.hasItemInItemHandler((IItemHandler)new InvWrapper((IInventory)this.worker.getInventoryCitizen()), TileEntityFurnace::func_145954_b)) {
                    this.walkTo = null;
                    return AIState.COOK_GET_FIREWOOD;
                }
                InventoryUtils.transferXOfFirstSlotInItemHandlerWithIntoInItemHandler((IItemHandler)new InvWrapper((IInventory)this.worker.getInventoryCitizen()), TileEntityFurnace::func_145954_b, 64, (IItemHandler)new InvWrapper((IInventory)((TileEntityFurnace)entity)), 1);
            }
            ((BuildingCook)this.getOwnBuilding()).setIsSomethingInOven(true);
            this.walkTo = null;
            return AIState.START_WORKING;
        }
        this.walkTo = null;
        this.setDelay(5);
        return AIState.COOK_COOK_FOOD;
    }

    private BlockPos getPositionOfOvenToRetrieveFrom() {
        for (BlockPos pos : ((BuildingCook)this.getOwnBuilding()).getFurnaces()) {
            TileEntity entity = this.world.func_175625_s(pos);
            if (!(entity instanceof TileEntityFurnace) || ((TileEntityFurnace)entity).func_145950_i() || ItemStackUtils.isEmpty(((TileEntityFurnace)entity).func_70301_a(2)).booleanValue() && ItemStackUtils.isEmpty(((TileEntityFurnace)entity).func_70301_a(0)).booleanValue()) continue;
            this.worker.setLatestStatus(new ITextComponent[]{new TextComponentTranslation("com.minecolonies.coremod.status.retrieving", new Object[0])});
            return pos;
        }
        ((BuildingCook)this.getOwnBuilding()).setIsSomethingInOven(false);
        return null;
    }

    @Override
    protected int getActionsDoneUntilDumping() {
        return 1;
    }

    private AIState startWorking() {
        BlockPos posOfOven;
        if (((BuildingCook)this.getOwnBuilding()).isSomethingInOven() && (posOfOven = this.getPositionOfOvenToRetrieveFrom()) != null) {
            this.walkTo = posOfOven;
            return AIState.COOK_RETRIEVE_FOOD;
        }
        int amountOfFood = this.getOwnBuilding().getCountOfPredicateInHut(ItemStackUtils.ISFOOD, this.getOwnBuilding().getBuildingLevel() * 64, this.world) + InventoryUtils.getItemCountInItemHandler((IItemHandler)new InvWrapper((IInventory)this.worker.getInventoryCitizen()), ItemStackUtils.ISFOOD);
        if (amountOfFood <= 0) {
            this.worker.setLatestStatus(new ITextComponent[]{new TextComponentTranslation("com.minecolonies.coremod.status.gathering", new Object[0])});
            if (!this.getOwnBuilding().hasWorkerOpenRequestsOfType(this.worker.getCitizenData(), TypeToken.of(Food.class))) {
                this.worker.getCitizenData().createRequestAsync(new Food(64));
            }
            return this.getState();
        }
        if (this.range == null) {
            this.range = this.getOwnBuilding().getTargetableArea(this.world);
        }
        this.citizenToServe.clear();
        List citizenList = this.world.func_175647_a(EntityCitizen.class, this.range, cit -> !(cit.getColonyJob() instanceof JobCook) && cit.getCitizenData() != null && cit.getCitizenData().getSaturation() <= 0.0);
        if (!citizenList.isEmpty()) {
            this.citizenToServe.addAll(citizenList);
            this.worker.setLatestStatus(new ITextComponent[]{new TextComponentTranslation("com.minecolonies.coremod.status.serving", new Object[0])});
            if (InventoryUtils.hasItemInItemHandler((IItemHandler)new InvWrapper((IInventory)this.worker.getInventoryCitizen()), ItemStackUtils.ISFOOD)) {
                return AIState.COOK_SERVE;
            }
            return AIState.COOK_GATHERING;
        }
        if (amountOfFood < this.getOwnBuilding().getBuildingLevel() * 64) {
            if (!this.getOwnBuilding().hasWorkerOpenRequestsOfType(this.worker.getCitizenData(), TypeToken.of(Food.class))) {
                this.worker.getCitizenData().createRequestAsync(new Food(64));
            }
            return this.getState();
        }
        if (this.getOwnBuilding().getCountOfPredicateInHut(ItemStackUtils.ISCOOKABLE, 1, this.world) >= 1 || InventoryUtils.getItemCountInItemHandler((IItemHandler)new InvWrapper((IInventory)this.worker.getInventoryCitizen()), ItemStackUtils.ISCOOKABLE) >= 1) {
            this.worker.setLatestStatus(new ITextComponent[]{new TextComponentTranslation("com.minecolonies.coremod.status.cooking", new Object[0])});
            return AIState.COOK_COOK_FOOD;
        }
        return this.checkForAdditionalJobs();
    }

    private AIState checkForAdditionalJobs() {
        for (BlockPos pos : ((BuildingCook)this.getOwnBuilding()).getFurnaces()) {
            TileEntity entity = this.world.func_175625_s(pos);
            if (!(entity instanceof TileEntityFurnace) || ((TileEntityFurnace)entity).func_145950_i()) continue;
            this.walkTo = pos;
            if (!ItemStackUtils.isEmpty(((TileEntityFurnace)entity).func_70301_a(2)).booleanValue()) {
                this.worker.setLatestStatus(new ITextComponent[]{new TextComponentTranslation("com.minecolonies.coremod.status.retrieving", new Object[0])});
                return AIState.COOK_RETRIEVE_FOOD;
            }
            if (ItemStackUtils.isEmpty(((TileEntityFurnace)entity).func_70301_a(0)).booleanValue()) continue;
            this.worker.setLatestStatus(new ITextComponent[]{new TextComponentTranslation("com.minecolonies.coremod.status.cooking", new Object[0])});
            return AIState.COOK_COOK_FOOD;
        }
        this.worker.setLatestStatus(new ITextComponent[]{new TextComponentTranslation("com.minecolonies.coremod.status.idling", new Object[0])});
        this.setDelay(5);
        return AIState.START_WORKING;
    }
}

