/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.citizen.builder;

import com.minecolonies.api.configuration.Configurations;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.BlockUtils;
import com.minecolonies.api.util.EntityUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.Log;
import com.minecolonies.coremod.blocks.AbstractBlockHut;
import com.minecolonies.coremod.blocks.BlockSolidSubstitution;
import com.minecolonies.coremod.blocks.ModBlocks;
import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingWorker;
import com.minecolonies.coremod.colony.buildings.BuildingBuilder;
import com.minecolonies.coremod.colony.buildings.utils.BuildingBuilderResource;
import com.minecolonies.coremod.colony.jobs.JobBuilder;
import com.minecolonies.coremod.colony.workorders.WorkOrderBuild;
import com.minecolonies.coremod.colony.workorders.WorkOrderBuildDecoration;
import com.minecolonies.coremod.entity.ai.basic.AbstractEntityAIStructure;
import com.minecolonies.coremod.entity.ai.util.AIState;
import com.minecolonies.coremod.entity.ai.util.AITarget;
import com.minecolonies.coremod.util.StructureWrapper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBed;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityArmorStand;
import net.minecraft.entity.item.EntityItemFrame;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFlowerPot;
import net.minecraft.tileentity.TileEntityLockable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.template.Template;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityAIStructureBuilder
extends AbstractEntityAIStructure<JobBuilder> {
    private static final int INTELLIGENCE_MULTIPLIER = 2;
    private static final int STRENGTH_MULTIPLIER = 1;
    private static final int STAND_OFFSET = 3;
    private static final int BASE_Y_HEIGHT = 70;
    private static final int ACTIONS_UNTIL_DUMP = 1024;
    @Nullable
    private BlockPos workFrom = null;

    public EntityAIStructureBuilder(@NotNull JobBuilder job) {
        super(job);
        super.registerTargets(new AITarget(AIState.IDLE, AIState.START_WORKING), new AITarget(this::checkIfExecute, this::getState), new AITarget(AIState.START_WORKING, this::startWorkingAtOwnBuilding));
        this.worker.setSkillModifier(2 * this.worker.getCitizenData().getIntelligence() + 1 * this.worker.getCitizenData().getStrength());
        this.worker.func_98053_h(true);
    }

    private boolean checkIfExecute() {
        this.setDelay(1);
        if (!((JobBuilder)this.job).hasWorkOrder()) {
            return true;
        }
        WorkOrderBuildDecoration wo = ((JobBuilder)this.job).getWorkOrder();
        if (((JobBuilder)this.job).getColony().getBuildingManager().getBuilding(wo.getBuildingLocation()) == null && wo instanceof WorkOrderBuild) {
            ((JobBuilder)this.job).complete();
            return true;
        }
        if (!((JobBuilder)this.job).hasStructure()) {
            this.initiate();
        }
        return false;
    }

    private void initiate() {
        if (!((JobBuilder)this.job).hasStructure()) {
            this.workFrom = null;
            this.loadStructure();
            WorkOrderBuildDecoration wo = ((JobBuilder)this.job).getWorkOrder();
            if (wo == null) {
                Log.getLogger().error(String.format("Builder (%d:%d) ERROR - Starting and missing work order(%d)", this.worker.getColony().getID(), this.worker.getCitizenData().getId(), ((JobBuilder)this.job).getWorkOrderId()));
                return;
            }
            if (wo instanceof WorkOrderBuild) {
                AbstractBuilding building = ((JobBuilder)this.job).getColony().getBuildingManager().getBuilding(wo.getBuildingLocation());
                if (building == null) {
                    Log.getLogger().error(String.format("Builder (%d:%d) ERROR - Starting and missing building(%s)", this.worker.getColony().getID(), this.worker.getCitizenData().getId(), wo.getBuildingLocation()));
                    return;
                }
                this.worker.sendLocalizedChat("entity.builder.messageBuildStart", ((JobBuilder)this.job).getStructure().getName());
                if (building.getBuildingLevel() > 0) {
                    wo.setCleared(true);
                }
            } else {
                this.worker.sendLocalizedChat("entity.builder.messageBuildStart", wo.getName());
            }
        }
    }

    private void loadStructure() {
        WorkOrderBuildDecoration workOrder = null;
        workOrder = ((JobBuilder)this.job).getWorkOrder();
        if (workOrder == null) {
            return;
        }
        BlockPos pos = workOrder.getBuildingLocation();
        if (workOrder instanceof WorkOrderBuild && this.worker.getColony().getBuildingManager().getBuilding(pos) == null) {
            Log.getLogger().warn("AbstractBuilding does not exist - removing build request");
            this.worker.getColony().getWorkManager().removeWorkOrder(workOrder);
            return;
        }
        int tempRotation = workOrder.getRotation(this.world);
        this.loadStructure(workOrder.getStructureName(), tempRotation, pos, workOrder.isMirrored());
        workOrder.setCleared(false);
        workOrder.setRequested(false);
        this.requestMaterialsIfRequired();
    }

    private void requestMaterials() {
        if (((JobBuilder)this.job).getWorkOrder().isRequested()) {
            return;
        }
        AbstractBuildingWorker buildingWorker = this.getOwnBuilding();
        if (buildingWorker instanceof BuildingBuilder) {
            ((BuildingBuilder)buildingWorker).resetNeededResources();
        }
        while (((JobBuilder)this.job).getStructure().findNextBlock()) {
            Template.BlockInfo blockInfo = ((JobBuilder)this.job).getStructure().getBlockInfo();
            Template.EntityInfo entityInfo = ((JobBuilder)this.job).getStructure().getEntityinfo();
            if (entityInfo != null) {
                this.requestEntityToBuildingIfRequired(entityInfo);
            }
            if (blockInfo == null) continue;
            IBlockState blockState = blockInfo.field_186243_b;
            Block block = blockState.func_177230_c();
            if (((JobBuilder)this.job).getStructure().isStructureBlockEqualWorldBlock() || blockState.func_177230_c() instanceof BlockBed && ((BlockBed.EnumPartType)blockState.func_177229_b((IProperty)BlockBed.field_176472_a)).equals((Object)BlockBed.EnumPartType.FOOT) || blockState.func_177230_c() instanceof BlockDoor && ((BlockDoor.EnumDoorHalf)blockState.func_177229_b((IProperty)BlockDoor.field_176523_O)).equals((Object)BlockDoor.EnumDoorHalf.UPPER)) continue;
            if (block instanceof BlockSolidSubstitution) {
                blockState = this.getSolidSubstitution(((JobBuilder)this.job).getStructure().getBlockPosition());
                block = blockState.func_177230_c();
            }
            Block worldBlock = BlockPosUtil.getBlock(this.world, ((JobBuilder)this.job).getStructure().getBlockPosition());
            if (block == null || block == Blocks.field_150350_a || worldBlock == Blocks.field_150357_h || worldBlock instanceof AbstractBlockHut || EntityAIStructureBuilder.isBlockFree(block, 0)) continue;
            this.requestBlockToBuildingIfRequired((BuildingBuilder)this.getOwnBuilding(), blockState);
        }
        ((JobBuilder)this.job).getWorkOrder().setRequested(true);
    }

    private void requestEntityToBuildingIfRequired(Template.EntityInfo entityInfo) {
        Entity entity;
        if (entityInfo != null && (entity = this.getEntityFromEntityInfoOrNull(entityInfo)) != null) {
            ArrayList<ItemStack> request = new ArrayList<ItemStack>();
            if (entity instanceof EntityItemFrame) {
                ItemStack stack = ((EntityItemFrame)entity).func_82335_i();
                if (!ItemStackUtils.isEmpty(stack).booleanValue()) {
                    ItemStackUtils.setSize(stack, 1);
                    request.add(stack);
                }
                request.add(new ItemStack(Items.field_151160_bD, 1));
            } else if (entity instanceof EntityArmorStand) {
                request.add(entity.getPickedResult(new RayTraceResult((Entity)this.worker)));
                entity.func_184193_aE().forEach(request::add);
                entity.func_184214_aD().forEach(request::add);
            } else if (!(entity instanceof EntityMob)) {
                request.add(entity.getPickedResult(new RayTraceResult((Entity)this.worker)));
            }
            for (ItemStack stack : request) {
                BuildingBuilder building = (BuildingBuilder)this.getOwnBuilding();
                if (ItemStackUtils.isEmpty(stack).booleanValue()) continue;
                building.addNeededResource(stack, 1);
            }
        }
    }

    private void requestBlockToBuildingIfRequired(BuildingBuilder building, IBlockState blockState) {
        if (((JobBuilder)this.job).getStructure().getBlockInfo().field_186244_c != null) {
            ArrayList<ItemStack> itemList = new ArrayList<ItemStack>();
            itemList.addAll(this.getItemsFromTileEntity());
            for (ItemStack stack : itemList) {
                building.addNeededResource(stack, 1);
            }
        }
        building.addNeededResource(BlockUtils.getItemStackFromBlockState(blockState), 1);
    }

    private List<ItemStack> getItemStacksOfTileEntity(NBTTagCompound compound) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        TileEntity tileEntity = TileEntity.func_190200_a((World)this.world, (NBTTagCompound)compound);
        if (tileEntity instanceof TileEntityFlowerPot) {
            items.add(((TileEntityFlowerPot)tileEntity).func_184403_b());
        } else if (tileEntity instanceof TileEntityLockable) {
            for (int i = 0; i < ((TileEntityLockable)tileEntity).func_70302_i_(); ++i) {
                ItemStack stack = ((TileEntityLockable)tileEntity).func_70301_a(i);
                if (stack == null) continue;
                items.add(stack);
            }
        }
        return items;
    }

    private AIState startWorkingAtOwnBuilding() {
        if (this.walkToBuilding()) {
            return this.getState();
        }
        return AIState.START_BUILDING;
    }

    @Override
    public void executeSpecificCompleteActions() {
        if (((JobBuilder)this.job).getStructure() == null && ((JobBuilder)this.job).hasWorkOrder()) {
            ((JobBuilder)this.job).complete();
        }
        if (((JobBuilder)this.job).getStructure() == null) {
            return;
        }
        String structureName = ((JobBuilder)this.job).getStructure().getName();
        this.worker.sendLocalizedChat("entity.builder.messageBuildComplete", structureName);
        WorkOrderBuildDecoration wo = ((JobBuilder)this.job).getWorkOrder();
        if (wo == null) {
            Log.getLogger().error(String.format("Builder (%d:%d) ERROR - Finished, but missing work order(%d)", this.worker.getColony().getID(), this.worker.getCitizenData().getId(), ((JobBuilder)this.job).getWorkOrderId()));
        } else {
            WorkOrderBuild woh;
            WorkOrderBuild workOrderBuild = woh = wo instanceof WorkOrderBuild ? (WorkOrderBuild)wo : null;
            if (woh != null) {
                AbstractBuilding building = ((JobBuilder)this.job).getColony().getBuildingManager().getBuilding(wo.getBuildingLocation());
                if (building == null) {
                    Log.getLogger().error(String.format("Builder (%d:%d) ERROR - Finished, but missing building(%s)", this.worker.getColony().getID(), this.worker.getCitizenData().getId(), woh.getBuildingLocation()));
                } else {
                    building.setBuildingLevel(woh.getUpgradeLevel());
                }
            }
            ((JobBuilder)this.job).complete();
        }
        BuildingBuilder workerBuilding = (BuildingBuilder)this.getOwnBuilding();
        workerBuilding.resetNeededResources();
        this.func_75251_c();
    }

    @Override
    public BlockPos getWorkingPosition(BlockPos targetPosition) {
        BlockPos[] edges;
        StructureWrapper wrapper = ((JobBuilder)this.job).getStructure();
        int x1 = wrapper.getPosition().func_177958_n() - wrapper.getOffset().func_177958_n() - 3;
        int z1 = wrapper.getPosition().func_177952_p() - wrapper.getOffset().func_177952_p() - 3;
        int x3 = wrapper.getPosition().func_177958_n() + (wrapper.getWidth() - wrapper.getOffset().func_177958_n()) + 3;
        int z3 = wrapper.getPosition().func_177952_p() + (wrapper.getLength() - wrapper.getOffset().func_177952_p() + 3);
        for (BlockPos pos : edges = new BlockPos[]{new BlockPos(x1, 70, z1), new BlockPos(x3, 70, z1), new BlockPos(x1, 70, z3), new BlockPos(x3, 70, z3)}) {
            BlockPos basePos = this.world.func_175672_r(pos);
            if (!EntityUtils.checkForFreeSpace(this.world, basePos.func_177977_b()) || this.world.func_180495_p(basePos).func_177230_c() == Blocks.field_150345_g || !this.world.func_180495_p(basePos.func_177977_b()).func_185904_a().func_76220_a()) continue;
            return basePos;
        }
        return targetPosition;
    }

    @Override
    public void connectBlockToBuildingIfNecessary(@NotNull Block block, @NotNull BlockPos pos) {
        BlockPos buildingLocation = ((JobBuilder)this.job).getWorkOrder().getBuildingLocation();
        AbstractBuilding building = this.getOwnBuilding().getColony().getBuildingManager().getBuilding(buildingLocation);
        if (building != null) {
            building.registerBlockPosition(block, pos, this.world);
        }
        if (block == ModBlocks.blockWayPoint) {
            this.worker.getColony().addWayPoint(pos, this.world.func_180495_p(pos));
        }
    }

    @Override
    public List<ItemStack> getItemsFromTileEntity() {
        if (((JobBuilder)this.job).getStructure() != null && ((JobBuilder)this.job).getStructure().getBlockInfo() != null && ((JobBuilder)this.job).getStructure().getBlockInfo().field_186244_c != null) {
            return this.getItemStacksOfTileEntity(((JobBuilder)this.job).getStructure().getBlockInfo().field_186244_c);
        }
        return Collections.emptyList();
    }

    @Override
    public void reduceNeededResources(ItemStack stack) {
        ((BuildingBuilder)this.getOwnBuilding()).reduceNeededResource(stack, 1);
    }

    @Override
    public boolean shallReplaceSolidSubstitutionBlock(Block worldBlock, IBlockState worldMetadata) {
        return false;
    }

    @Override
    public IBlockState getSolidSubstitution(@NotNull BlockPos location) {
        return BlockUtils.getSubstitutionBlockAtWorld(this.world, location);
    }

    @Override
    public void requestMaterialsIfRequired() {
        if (!Configurations.Gameplay.builderInfiniteResources) {
            this.requestMaterials();
        }
    }

    @Override
    protected boolean checkIfCanceled() {
        if (((JobBuilder)this.job).getWorkOrder() == null) {
            super.func_75251_c();
            this.workFrom = null;
            ((JobBuilder)this.job).setStructure(null);
            ((JobBuilder)this.job).setWorkOrder(null);
            this.resetCurrentStructure();
            return true;
        }
        return false;
    }

    @Override
    protected boolean isAlreadyCleared() {
        return ((JobBuilder)this.job).getWorkOrder() != null && ((JobBuilder)this.job).getWorkOrder().isCleared();
    }

    @Override
    protected void onStartWithoutStructure() {
        if (((JobBuilder)this.job).getWorkOrder() != null) {
            this.loadStructure();
        }
    }

    @Override
    public Template.EntityInfo getEntityInfo() {
        if (((JobBuilder)this.job).getStructure() != null && ((JobBuilder)this.job).getStructure().getEntityinfo() != null) {
            return ((JobBuilder)this.job).getStructure().getEntityinfo();
        }
        return null;
    }

    @Override
    @Nullable
    public ItemStack getTotalAmount(@Nullable ItemStack stack) {
        AbstractBuildingWorker buildingWorker = this.getOwnBuilding();
        if (ItemStackUtils.isEmpty(stack).booleanValue()) {
            return null;
        }
        BuildingBuilderResource resource = ((BuildingBuilder)buildingWorker).getNeededResources().get(stack.func_77977_a());
        return resource == null ? stack : new ItemStack(resource.getItem(), Math.min(64, resource.getAmount()), resource.getDamageValue());
    }

    @Override
    public void handleTileEntityPlacement(@NotNull BlockPos pos) {
        if (((JobBuilder)this.job).getStructure().getBlockInfo().field_186244_c != null) {
            TileEntity tileentityflowerpot = this.world.func_175625_s(pos);
            tileentityflowerpot.func_145839_a(((JobBuilder)this.job).getStructure().getBlockInfo().field_186244_c);
            this.world.func_175690_a(pos, tileentityflowerpot);
        }
    }

    @Override
    protected int getActionsDoneUntilDumping() {
        return 1024;
    }
}

