/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.basic;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.reflect.TypeToken;
import com.minecolonies.api.colony.requestsystem.request.IRequest;
import com.minecolonies.api.colony.requestsystem.requestable.IDeliverable;
import com.minecolonies.api.colony.requestsystem.requestable.Stack;
import com.minecolonies.api.colony.requestsystem.requestable.Tool;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.entity.ai.pathfinding.IWalkToProxy;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.EntityUtils;
import com.minecolonies.api.util.InventoryFunctions;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.constant.IToolType;
import com.minecolonies.api.util.constant.ToolType;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingWorker;
import com.minecolonies.coremod.colony.jobs.AbstractJob;
import com.minecolonies.coremod.colony.jobs.JobDeliveryman;
import com.minecolonies.coremod.entity.ai.basic.AbstractAISkeleton;
import com.minecolonies.coremod.entity.ai.util.AIState;
import com.minecolonies.coremod.entity.ai.util.AITarget;
import com.minecolonies.coremod.entity.pathfinding.EntityCitizenWalkToProxy;
import com.minecolonies.coremod.inventory.InventoryCitizen;
import com.minecolonies.coremod.util.WorkerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentBase;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractEntityAIBasic<J extends AbstractJob>
extends AbstractAISkeleton<J> {
    public static final int EXCEPTION_TIMEOUT = 100;
    protected static final int ATTACK_TIME_BUFFER = 50;
    private static final int MAX_ADDITIONAL_RANGE_TO_BUILD = 25;
    private static final int DELAY_RECHECK = 10;
    private static final int DEFAULT_RANGE_FOR_DELAY = 4;
    private static final int ACTIONS_UNTIL_DUMP = 32;
    private static final int HIT_EVERY_X_TICKS = 5;
    @Nullable
    protected BlockPos currentWorkingLocation = null;
    @Nullable
    protected BlockPos currentStandingLocation = null;
    private int delay = 0;
    private boolean hasDelayed = false;
    private int actionsDone = 0;
    private IWalkToProxy proxy;
    private int exceptionTimer = 1;
    private BlockPos restaurant = null;

    protected AbstractEntityAIBasic(@NotNull J job) {
        super(job);
        super.registerTargets(new AITarget(this::initSafetyChecks), new AITarget(this::updateVisualState), new AITarget(this::waitingForSomething, this::getState), new AITarget(() -> this.getState() == AIState.NEEDS_ITEM || this.getOwnBuilding().hasWorkerOpenRequestsFiltered(this.worker.getCitizenData(), r -> !this.worker.getCitizenData().isRequestAsync((IToken<?>)r.getToken())) || this.getOwnBuilding().hasCitizenCompletedRequests(this.worker.getCitizenData()), this::waitForRequests), new AITarget(AIState.INVENTORY_FULL, this::dumpInventory), new AITarget(this::inventoryNeedsDump, AIState.INVENTORY_FULL), new AITarget(() -> this.getState() == AIState.NEEDS_TOOL && this.getOwnBuilding().getOpenRequestsOfType(this.worker.getCitizenData(), TypeToken.of(Tool.class)).isEmpty(), AIState.IDLE), new AITarget(this::shouldGetFood, this::searchForFood));
    }

    private boolean shouldGetFood() {
        return this.worker.getCitizenData().getSaturation() <= 7.0 && !this.job.hasCheckedForFoodToday() || this.worker.getCitizenData().getSaturation() <= 0.0;
    }

    @Nullable
    public AbstractBuildingWorker getOwnBuilding() {
        return this.worker.getWorkBuilding();
    }

    @Override
    protected void onException(RuntimeException e) {
        try {
            int timeout = 100 * this.exceptionTimer;
            this.setDelay(timeout);
            this.exceptionTimer *= 2;
            if (this.worker != null) {
                String name = this.worker.func_70005_c_();
                BlockPos workerPosition = this.worker.func_180425_c();
                AbstractJob colonyJob = this.worker.getColonyJob();
                String jobName = colonyJob == null ? "null" : colonyJob.getName();
                Log.getLogger().error("Pausing Entity " + name + " (" + jobName + ") at " + workerPosition + " for " + timeout + " Seconds because of error:");
            } else {
                Log.getLogger().error("Pausing Entity that is null for " + timeout + " Seconds because of error:");
            }
            e.printStackTrace();
        }
        catch (RuntimeException exp) {
            Log.getLogger().error("Welp reporting crashed:");
            exp.printStackTrace();
            Log.getLogger().error("Caused by ai exception:");
            e.printStackTrace();
        }
    }

    private AIState searchForFood() {
        if (!this.job.hasCheckedForFoodToday()) {
            if (this.walkToBuilding()) {
                return AIState.IDLE;
            }
            this.job.setCheckedForFood();
            if (this.isInHut((ItemStack itemStack) -> ItemStackUtils.isEmpty(itemStack) == false && itemStack.func_77973_b() instanceof ItemFood || this.worker.getCitizenData().getSaturation() > 0.0)) {
                return AIState.IDLE;
            }
        }
        if (this.restaurant == null) {
            BlockPos goodCook = this.worker.getColony().getBuildingManager().getBestRestaurant(this.worker);
            if (goodCook == null) {
                this.chatSpamFilter.talkWithoutSpam("com.minecolonies.coremod.ai.noRestaurant", new Object[0]);
                return this.getState();
            }
            this.restaurant = goodCook;
        }
        this.walkToBlock(this.restaurant);
        return AIState.IDLE;
    }

    protected final void setDelay(int timeout) {
        this.delay = timeout;
    }

    private boolean inventoryNeedsDump() {
        return (this.worker.isInventoryFull() || this.actionsDone >= this.getActionsDoneUntilDumping() || this.wantInventoryDumped()) && !(this.job instanceof JobDeliveryman);
    }

    protected int getActionsDoneUntilDumping() {
        return 32;
    }

    protected boolean wantInventoryDumped() {
        return false;
    }

    @Nullable
    private AIState initSafetyChecks() {
        if (null == this.getOwnBuilding()) {
            if (this.getState() == AIState.INIT) {
                return AIState.INIT;
            }
            return AIState.IDLE;
        }
        if (this.getState() == AIState.INIT) {
            return AIState.IDLE;
        }
        return null;
    }

    private AIState updateVisualState() {
        this.job.setNameTag(this.getState().toString());
        this.updateRenderMetaData();
        return null;
    }

    protected void updateRenderMetaData() {
        this.worker.setRenderMetadata("");
    }

    private boolean waitingForSomething() {
        if (this.delay > 0) {
            if (this.currentStandingLocation != null && !this.worker.isWorkerAtSiteWithMove(this.currentStandingLocation, 4)) {
                return true;
            }
            if (this.delay % 5 == 0) {
                this.worker.hitBlockWithToolInHand(this.currentWorkingLocation);
            }
            --this.delay;
            return true;
        }
        this.clearWorkTarget();
        return false;
    }

    private void clearWorkTarget() {
        this.currentStandingLocation = null;
        this.currentWorkingLocation = null;
        this.delay = 0;
    }

    @NotNull
    private AIState waitForRequests() {
        this.delay = 10;
        this.updateWorkerStatusFromRequests();
        return this.lookForRequests();
    }

    private void updateWorkerStatusFromRequests() {
        if (!this.getOwnBuilding().hasWorkerOpenRequests(this.worker.getCitizenData()) && !this.getOwnBuilding().hasCitizenCompletedRequests(this.worker.getCitizenData())) {
            this.worker.setLatestStatus(new ITextComponent[0]);
            return;
        }
        IRequest request = this.getOwnBuilding().getCompletedRequests(this.worker.getCitizenData()).stream().findFirst().orElse(null);
        if (request == null) {
            request = this.getOwnBuilding().getOpenRequests(this.worker.getCitizenData()).stream().findFirst().orElse(null);
        }
        this.worker.setLatestStatus(new ITextComponent[]{new TextComponentTranslation("com.minecolonies.coremod.status.waiting", new Object[0]), request.getShortDisplayString()});
    }

    @NotNull
    private AIState lookForRequests() {
        if (!this.getOwnBuilding().hasWorkerOpenRequests(this.worker.getCitizenData()) && !this.getOwnBuilding().hasCitizenCompletedRequests(this.worker.getCitizenData())) {
            return AIState.IDLE;
        }
        if (!this.walkToBuilding() && this.getOwnBuilding().hasCitizenCompletedRequests(this.worker.getCitizenData())) {
            this.delay += 10;
            ImmutableList<IRequest> completedRequests = this.getOwnBuilding().getCompletedRequests(this.worker.getCitizenData());
            completedRequests.stream().filter(r -> !r.canBeDelivered()).forEach(r -> this.getOwnBuilding().markRequestAsAccepted(this.worker.getCitizenData(), (IToken<?>)r.getToken()));
            IRequest firstDeliverableRequest = completedRequests.stream().filter(IRequest::canBeDelivered).findFirst().orElse(null);
            if (firstDeliverableRequest != null) {
                boolean async = false;
                if (this.worker.getCitizenData().isRequestAsync((IToken<?>)firstDeliverableRequest.getToken())) {
                    async = true;
                    this.job.getAsyncRequests().remove(firstDeliverableRequest.getToken());
                }
                this.getOwnBuilding().markRequestAsAccepted(this.worker.getCitizenData(), (IToken<?>)firstDeliverableRequest.getToken());
                ItemStack deliveredItemStack = firstDeliverableRequest.getDelivery();
                if (InventoryUtils.getItemCountInItemHandler((IItemHandler)new InvWrapper((IInventory)this.worker.getInventoryCitizen()), arg_0 -> ((ItemStack)deliveredItemStack).func_185136_b(arg_0)) >= deliveredItemStack.field_77994_a) {
                    return AIState.NEEDS_ITEM;
                }
                if (InventoryUtils.getItemCountInProvider(this.getOwnBuilding(), arg_0 -> ((ItemStack)deliveredItemStack).func_185136_b(arg_0)) >= deliveredItemStack.field_77994_a) {
                    if (InventoryUtils.transferXOfFirstSlotInProviderWithIntoNextFreeSlotInItemHandler(this.getOwnBuilding(), arg_0 -> ((ItemStack)deliveredItemStack).func_185136_b(arg_0), deliveredItemStack.field_77994_a, (IItemHandler)new InvWrapper((IInventory)this.worker.getInventoryCitizen()))) {
                        return AIState.NEEDS_ITEM;
                    }
                }
                if (!async) {
                    this.worker.getCitizenData().createRequest(firstDeliverableRequest.getRequest());
                } else {
                    this.worker.getCitizenData().createRequestAsync(firstDeliverableRequest.getRequest());
                }
            }
        }
        return AIState.NEEDS_ITEM;
    }

    protected final boolean walkToBuilding() {
        AbstractBuildingWorker ownBuilding = this.getOwnBuilding();
        return ownBuilding == null || this.walkToBlock(ownBuilding.getLocation());
    }

    public boolean isInHut(@Nullable Predicate<ItemStack> is) {
        AbstractBuildingWorker building = this.getOwnBuilding();
        if (building != null) {
            boolean hasItem = this.isInTileEntity(building.getTileEntity(), is);
            if (hasItem) {
                return true;
            }
            for (BlockPos pos : building.getAdditionalCountainers()) {
                TileEntity entity = this.world.func_175625_s(pos);
                if (!(entity instanceof TileEntityChest) || !(hasItem = this.isInTileEntity((TileEntityChest)entity, is))) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isInHut(@Nullable ItemStack is) {
        AbstractBuildingWorker building = this.getOwnBuilding();
        if (building != null) {
            boolean hasItem = this.isInTileEntity((TileEntity)building.getTileEntity(), is);
            if (hasItem) {
                return true;
            }
            for (BlockPos pos : building.getAdditionalCountainers()) {
                TileEntity entity = this.world.func_175625_s(pos);
                if (!(entity instanceof TileEntityChest) || !(hasItem = this.isInTileEntity(entity, is))) continue;
                return true;
            }
        }
        return false;
    }

    protected final boolean walkToBlock(@NotNull BlockPos stand) {
        return this.walkToBlock(stand, 4);
    }

    public boolean isInTileEntity(TileEntity entity, ItemStack is) {
        return is != null && InventoryFunctions.matchFirstInProviderWithAction((ICapabilityProvider)entity, stack -> ItemStackUtils.isEmpty(stack) == false && is.func_185136_b(stack), this::takeItemStackFromProvider);
    }

    protected final boolean walkToBlock(@NotNull BlockPos stand, int range) {
        if (this.proxy == null) {
            this.proxy = new EntityCitizenWalkToProxy(this.worker);
        }
        if (this.proxy.walkToBlock(stand, range)) {
            this.workOnBlock(null, stand, 10);
            return true;
        }
        return false;
    }

    private void workOnBlock(@Nullable BlockPos target, @Nullable BlockPos stand, int timeout) {
        this.currentWorkingLocation = target;
        this.currentStandingLocation = stand;
        this.delay = timeout;
    }

    public boolean isInTileEntity(TileEntityChest entity, @NotNull Predicate<ItemStack> itemStackSelectionPredicate) {
        return InventoryFunctions.matchFirstInProviderWithAction((ICapabilityProvider)entity, itemStackSelectionPredicate, this::takeItemStackFromProvider);
    }

    private void requestWithoutSpam(@NotNull TextComponentBase chat) {
        this.chatSpamFilter.requestTextComponentWithoutSpam(chat);
    }

    public boolean retrieveToolInTileEntity(TileEntity entity, IToolType toolType, int minLevel, int maxLevel) {
        if (ToolType.NONE.equals(toolType)) {
            return false;
        }
        return InventoryFunctions.matchFirstInProviderWithAction((ICapabilityProvider)entity, stack -> ItemStackUtils.hasToolLevel(stack, toolType, minLevel, maxLevel), this::takeItemStackFromProvider);
    }

    public void takeItemStackFromProvider(@NotNull ICapabilityProvider provider, int slotIndex) {
        InventoryUtils.transferItemStackIntoNextFreeSlotFromProvider(provider, slotIndex, (IItemHandler)new InvWrapper((IInventory)this.worker.getInventoryCitizen()));
    }

    protected boolean checkForToolOrWeapon(@NotNull IToolType toolType) {
        return this.checkForToolOrWeapon(toolType, 0);
    }

    protected boolean checkForToolOrWeapon(@NotNull IToolType toolType, int minimalLevel) {
        ImmutableList openToolRequests = this.getOwnBuilding().getOpenRequestsOfTypeFiltered(this.worker.getCitizenData(), TypeToken.of(Tool.class), r -> ((Tool)r.getRequest()).getToolClass().equals(toolType) && ((Tool)r.getRequest()).getMinLevel() >= minimalLevel);
        ImmutableList completedToolRequests = this.getOwnBuilding().getCompletedRequestsOfTypeFiltered(this.worker.getCitizenData(), TypeToken.of(Tool.class), r -> ((Tool)r.getRequest()).getToolClass().equals(toolType) && ((Tool)r.getRequest()).getMinLevel() >= minimalLevel);
        if (this.checkForNeededTool(toolType, minimalLevel)) {
            if (openToolRequests.isEmpty() && completedToolRequests.isEmpty()) {
                Tool request = new Tool(toolType, minimalLevel, this.getOwnBuilding().getMaxToolLevel() < minimalLevel ? minimalLevel : this.getOwnBuilding().getMaxToolLevel());
                this.worker.getCitizenData().createRequest(request);
            }
            return true;
        }
        return false;
    }

    private boolean checkForNeededTool(@NotNull IToolType toolType, int minimalLevel) {
        int maxToolLevel = this.worker.getWorkBuilding().getMaxToolLevel();
        InventoryCitizen inventory = this.worker.getInventoryCitizen();
        if (InventoryUtils.isToolInItemHandler((IItemHandler)new InvWrapper((IInventory)inventory), toolType, minimalLevel, maxToolLevel)) {
            return false;
        }
        this.delay += 10;
        if (this.walkToBuilding()) {
            return true;
        }
        return !this.retrieveToolInHut(toolType, minimalLevel);
    }

    public boolean retrieveToolInHut(IToolType toolType, int minimalLevel) {
        AbstractBuildingWorker building = this.getOwnBuilding();
        if (building != null) {
            if (this.retrieveToolInTileEntity((TileEntity)building.getTileEntity(), toolType, minimalLevel, this.getOwnBuilding().getMaxToolLevel())) {
                return true;
            }
            for (BlockPos pos : building.getAdditionalCountainers()) {
                TileEntity entity = this.world.func_175625_s(pos);
                if (!(entity instanceof TileEntityChest) || !this.retrieveToolInTileEntity((TileEntity)((TileEntityChest)entity), toolType, minimalLevel, this.getOwnBuilding().getMaxToolLevel())) continue;
                return true;
            }
        }
        return false;
    }

    @NotNull
    private AIState dumpInventory() {
        if (!this.worker.isWorkerAtSiteWithMove(this.getOwnBuilding().getLocation(), 4)) {
            return AIState.INVENTORY_FULL;
        }
        if (this.dumpOneMoreSlot()) {
            this.delay += 10;
            return AIState.INVENTORY_FULL;
        }
        if (this.isInventoryAndChestFull()) {
            this.chatSpamFilter.talkWithoutSpam("entity.worker.inventoryFullChestFull", new Object[0]);
        }
        this.itemsNiceToHave().forEach(this::isInHut);
        this.clearActionsDone();
        return AIState.IDLE;
    }

    private boolean dumpOneMoreSlot() {
        ArrayList alreadyKept = new ArrayList();
        AbstractBuildingWorker buildingWorker = this.getOwnBuilding();
        return buildingWorker != null && (this.walkToBuilding() || InventoryFunctions.matchFirstInHandlerWithAction((IItemHandler)new InvWrapper((IInventory)this.worker.getInventoryCitizen()), itemStack -> ItemStackUtils.isEmpty(itemStack) == false && !buildingWorker.buildingRequiresCertainAmountOfItem((ItemStack)itemStack, alreadyKept), (handler, slot) -> InventoryUtils.transferItemStackIntoNextFreeSlotInItemHandlers((IItemHandler)new InvWrapper((IInventory)this.worker.getInventoryCitizen()), slot, (IItemHandler)new InvWrapper((IInventory)buildingWorker.getTileEntity()))));
    }

    private boolean isInventoryAndChestFull() {
        AbstractBuildingWorker buildingWorker = this.getOwnBuilding();
        return InventoryUtils.isProviderFull((ICapabilityProvider)this.worker) && buildingWorker != null && InventoryUtils.isProviderFull((ICapabilityProvider)buildingWorker.getTileEntity());
    }

    @NotNull
    protected List<ItemStack> itemsNiceToHave() {
        return new ArrayList<ItemStack>();
    }

    private void clearActionsDone() {
        this.actionsDone = 0;
    }

    @NotNull
    protected InventoryCitizen getInventory() {
        return this.worker.getInventoryCitizen();
    }

    public final boolean holdEfficientTool(@NotNull Block target) {
        int bestSlot = this.getMostEfficientTool(target);
        if (bestSlot >= 0) {
            this.worker.setHeldItem(bestSlot);
            return true;
        }
        this.requestTool(target);
        return false;
    }

    private void requestTool(@NotNull Block target) {
        IToolType toolType = WorkerUtil.getBestToolForBlock(target);
        int required = WorkerUtil.getCorrectHavestLevelForBlock(target);
        this.updateToolFlag(toolType, required);
    }

    private void updateToolFlag(@NotNull IToolType toolType, int required) {
        if (ToolType.PICKAXE.equals(toolType)) {
            this.checkForToolOrWeapon(toolType, required);
        } else {
            this.checkForToolOrWeapon(toolType);
        }
    }

    private int getMostEfficientTool(@NotNull Block target) {
        IToolType toolType = WorkerUtil.getBestToolForBlock(target);
        int required = WorkerUtil.getCorrectHavestLevelForBlock(target);
        int bestSlot = -1;
        int bestLevel = Integer.MAX_VALUE;
        InventoryCitizen inventory = this.worker.getInventoryCitizen();
        int maxToolLevel = this.worker.getWorkBuilding().getMaxToolLevel();
        for (int i = 0; i < new InvWrapper((IInventory)this.worker.getInventoryCitizen()).getSlots(); ++i) {
            ItemStack item = inventory.func_70301_a(i);
            int level = ItemStackUtils.getMiningLevel(item, toolType);
            if (level < required || level >= bestLevel || toolType != ToolType.NONE && !ItemStackUtils.verifyToolLevel(item, level, required, maxToolLevel)) continue;
            bestSlot = i;
            bestLevel = level;
        }
        return bestSlot;
    }

    protected final boolean hasNotDelayed(int time) {
        if (!this.hasDelayed) {
            this.setDelay(time);
            this.hasDelayed = true;
            return true;
        }
        this.hasDelayed = false;
        return false;
    }

    protected final void incrementActionsDone() {
        ++this.actionsDone;
    }

    public BlockPos getWorkingPosition(BlockPos targetPosition) {
        return targetPosition;
    }

    public BlockPos getWorkingPosition(int distance, BlockPos targetPos, int offset) {
        EnumFacing[] directions;
        if (offset > 25) {
            return targetPos;
        }
        for (EnumFacing direction : directions = new EnumFacing[]{EnumFacing.EAST, EnumFacing.WEST, EnumFacing.NORTH, EnumFacing.SOUTH}) {
            BlockPos positionInDirection = this.getPositionInDirection(direction, distance + offset, targetPos);
            if (!EntityUtils.checkForFreeSpace(this.world, positionInDirection) || this.world.func_180495_p(positionInDirection.func_177984_a()).func_177230_c() == Blocks.field_150345_g) continue;
            return positionInDirection;
        }
        return this.getWorkingPosition(distance, targetPos, offset + 1);
    }

    @NotNull
    private BlockPos getPositionInDirection(EnumFacing facing, int distance, BlockPos targetPos) {
        return BlockPosUtil.getFloor(targetPos.func_177967_a(facing, distance), this.world);
    }

    public boolean checkIfRequestForItemExistOrCreate(ItemStack ... stacks) {
        return this.checkIfRequestForItemExistOrCreate(Lists.newArrayList((Object[])stacks));
    }

    public boolean checkIfRequestForItemExistOrCreate(@NotNull Collection<ItemStack> stacks) {
        return stacks.stream().allMatch(s -> this.checkIfRequestForItemExistOrCreate((ItemStack)s));
    }

    public boolean checkIfRequestForItemExistOrCreate(@NotNull ItemStack stack) {
        if (InventoryUtils.hasItemInItemHandler((IItemHandler)new InvWrapper((IInventory)this.worker.getInventoryCitizen()), s -> ItemStackUtils.compareItemStacksIgnoreStackSize(s, stack))) {
            return true;
        }
        if (this.getOwnBuilding().getOpenRequestsOfTypeFiltered(this.worker.getCitizenData(), TypeToken.of(IDeliverable.class), r -> ((IDeliverable)r.getRequest()).matches(stack)).isEmpty()) {
            Stack stackRequest = new Stack(stack);
            this.worker.getCitizenData().createRequest(stackRequest);
        }
        return false;
    }

    public boolean checkIfRequestForItemExistOrCreateAsynch(ItemStack ... stacks) {
        return this.checkIfRequestForItemExistOrCreateAsynch(Lists.newArrayList((Object[])stacks));
    }

    public boolean checkIfRequestForItemExistOrCreateAsynch(@NotNull Collection<ItemStack> stacks) {
        return stacks.stream().allMatch(s -> this.checkIfRequestForItemExistOrCreateAsynch((ItemStack)s));
    }

    public boolean checkIfRequestForItemExistOrCreateAsynch(@NotNull ItemStack stack) {
        if (InventoryUtils.hasItemInItemHandler((IItemHandler)new InvWrapper((IInventory)this.worker.getInventoryCitizen()), s -> ItemStackUtils.compareItemStacksIgnoreStackSize(s, stack) != false && s.field_77994_a >= stack.field_77994_a)) {
            return true;
        }
        if (InventoryUtils.getItemCountInProvider(this.getOwnBuilding(), arg_0 -> ((ItemStack)stack).func_185136_b(arg_0)) >= stack.field_77994_a) {
            if (InventoryUtils.transferXOfFirstSlotInProviderWithIntoNextFreeSlotInItemHandler(this.getOwnBuilding(), arg_0 -> ((ItemStack)stack).func_185136_b(arg_0), stack.field_77994_a, (IItemHandler)new InvWrapper((IInventory)this.worker.getInventoryCitizen()))) {
                return true;
            }
        }
        if (this.getOwnBuilding().getOpenRequestsOfTypeFiltered(this.worker.getCitizenData(), TypeToken.of(IDeliverable.class), r -> ((IDeliverable)r.getRequest()).matches(stack)).isEmpty()) {
            Stack stackRequest = new Stack(stack);
            this.worker.getCitizenData().createRequestAsync(stackRequest);
        }
        return false;
    }

    public boolean tryTransferFromPosToWorker(BlockPos pos, @NotNull Predicate<ItemStack> predicate) {
        TileEntity entity = this.world.func_175625_s(pos);
        if (entity.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.DOWN)) {
            return InventoryUtils.transferXOfFirstSlotInItemHandlerWithIntoNextFreeSlotInItemHandler((IItemHandler)new InvWrapper((IInventory)entity), predicate, 64, (IItemHandler)new InvWrapper((IInventory)this.worker.getInventoryCitizen()));
        }
        return false;
    }
}

