/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity;

import com.minecolonies.api.util.CompatibilityUtils;
import com.minecolonies.api.util.MathUtils;
import com.minecolonies.coremod.entity.EntityCitizen;
import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.init.Enchantments;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class EntityFishHook
extends Entity {
    private static final int TTL = 360;
    private static final float ENTITY_SIZE = 0.25f;
    private static final double HALF_CIRCLE = 180.0;
    private static final double RANDOM_MOVEMENT_OFFSET = (double)0.0075f;
    private static final double INITIAL_MOVEMENT_LIMITER = 0.16;
    private static final double SUNKEN_OFFSET = (double)0.1f;
    private static final double NUM_BOUNDING_BOX_EDGES = 4.0;
    private static final double DISTANCE_FACTOR = 64.0;
    private static final double BOUNCE_MOVEMENT_LIMITER = 0.2;
    private static final float AIR_MOVEMENT_LIMITER = 0.92f;
    private static final double GROUND_MOVEMENT_LIMITER = 0.5;
    private static final double WATER_MOVEMENT_LIMITER = (double)0.04f;
    private static final double NO_CLEAR_SKY_CHANCE = 0.5;
    private static final int INCREASE_RARENESS_MODIFIER = 200;
    private final long creationTime;
    private EntityCitizen citizen;
    private int fishingSpeedEnchantment;
    private int fishingLootEnchantment;
    private boolean inGround;
    private int shake;
    private int countdownNoFish;
    private int countdownFishNear;
    private int countdownFishBites;
    private double relativeRotation;
    private boolean isFishCaugth = false;

    public EntityFishHook(World world, @NotNull EntityCitizen citizen) {
        this(world);
        this.citizen = citizen;
        this.func_70012_b(citizen.field_70165_t, citizen.field_70163_u + 1.62 - citizen.func_70033_W(), citizen.field_70161_v, citizen.field_70177_z, citizen.field_70125_A);
        this.field_70165_t -= Math.cos((double)this.field_70177_z / 180.0 * Math.PI) * 0.16;
        this.field_70163_u -= (double)0.1f;
        this.field_70161_v -= Math.sin((double)this.field_70177_z / 180.0 * Math.PI) * 0.16;
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        double f = 0.4;
        this.field_70159_w = -Math.sin((double)this.field_70177_z / 180.0 * Math.PI) * Math.cos((double)this.field_70125_A / 180.0 * Math.PI) * 0.4;
        this.field_70179_y = Math.cos((double)this.field_70177_z / 180.0 * Math.PI) * Math.cos((double)this.field_70125_A / 180.0 * Math.PI) * 0.4;
        this.field_70181_x = -Math.sin((double)this.field_70125_A / 180.0 * Math.PI) * 0.4;
        this.setPosition(this.field_70159_w, this.field_70181_x, this.field_70179_y, 1.5, 1.0);
        this.fishingSpeedEnchantment = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_151369_A, (ItemStack)citizen.func_184614_ca());
        this.fishingLootEnchantment = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_151370_z, (ItemStack)citizen.func_184614_ca());
    }

    public EntityFishHook(World world) {
        super(world);
        this.func_70105_a(0.25f, 0.25f);
        this.field_70158_ak = true;
        this.creationTime = System.nanoTime();
        this.fishingLootEnchantment = 0;
        this.fishingSpeedEnchantment = 0;
    }

    private void setPosition(double x, double y, double z, double yaw, double pitch) {
        double squareRootXYZ = MathHelper.func_76133_a((double)(x * x + y * y + z * z));
        double newX = x / squareRootXYZ;
        double newY = y / squareRootXYZ;
        double newZ = z / squareRootXYZ;
        newX += this.field_70146_Z.nextGaussian() * (double)0.0075f * pitch;
        newY += this.field_70146_Z.nextGaussian() * (double)0.0075f * pitch;
        newZ += this.field_70146_Z.nextGaussian() * (double)0.0075f * pitch;
        this.field_70159_w = newX *= yaw;
        this.field_70181_x = newY *= yaw;
        this.field_70179_y = newZ *= yaw;
        this.field_70126_B = this.field_70177_z = (float)(Math.atan2(newX, newZ) * 180.0 / Math.PI);
        this.field_70127_C = this.field_70125_A = (float)(Math.atan2(newY, Math.sqrt(newX * newX + newZ * newZ)) * 180.0 / Math.PI);
    }

    public EntityCitizen getCitizen() {
        return this.citizen;
    }

    protected void func_70088_a() {
    }

    public boolean equals(@Nullable Object o) {
        return o != null && ((Object)((Object)this)).getClass() == o.getClass() && super.equals(o);
    }

    public int hashCode() {
        return this.func_145782_y();
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.fishHookIsOverTimeToLive()) {
            this.func_70106_y();
        }
        this.bounceFromGround();
        if (this.inGround) {
            return;
        }
        this.moveSomeStuff();
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_70112_a(double range) {
        double maxLength = this.func_174813_aQ().func_72320_b() * 4.0;
        return range < (maxLength *= 64.0) * maxLength;
    }

    public void func_70037_a(NBTTagCompound unused) {
        this.func_70106_y();
    }

    public void func_70014_b(NBTTagCompound unused) {
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70016_h(double vectorX, double vectorY, double vectorZ) {
        this.field_70159_w = vectorX;
        this.field_70181_x = vectorY;
        this.field_70179_y = vectorZ;
    }

    public boolean fishHookIsOverTimeToLive() {
        return MathUtils.nanoSecondsToSeconds(System.nanoTime() - this.creationTime) > 360L;
    }

    private void bounceFromGround() {
        if (this.shake > 0) {
            --this.shake;
        }
        if (!this.inGround) {
            return;
        }
        this.inGround = false;
        this.field_70159_w *= this.field_70146_Z.nextDouble() * 0.2;
        this.field_70181_x *= this.field_70146_Z.nextDouble() * 0.2;
        this.field_70179_y *= this.field_70146_Z.nextDouble() * 0.2;
    }

    private void moveSomeStuff() {
        this.updateMotionAndRotation();
        double movementLimiter = 0.92f;
        if (this.field_70122_E || this.field_70123_F) {
            movementLimiter = 0.5;
        }
        int numSteps = 5;
        double waterDensity = 0.0;
        for (int j = 0; j < 5; ++j) {
            double d3 = this.func_174813_aQ().field_72338_b + (this.func_174813_aQ().field_72337_e - this.func_174813_aQ().field_72338_b) * (double)j / 5.0;
            double d4 = this.func_174813_aQ().field_72338_b + (this.func_174813_aQ().field_72337_e - this.func_174813_aQ().field_72338_b) * (double)(j + 1) / 5.0;
            AxisAlignedBB axisAlignedBB1 = new AxisAlignedBB(this.func_174813_aQ().field_72340_a, d3, this.func_174813_aQ().field_72339_c, this.func_174813_aQ().field_72336_d, d4, this.func_174813_aQ().field_72334_f);
            if (!CompatibilityUtils.getWorld(this).func_72875_a(axisAlignedBB1, Material.field_151586_h)) continue;
            waterDensity += 0.2;
        }
        this.checkIfFishBites(waterDensity);
        double currentDistance = waterDensity * 2.0 - 1.0;
        this.field_70181_x += (double)0.04f * currentDistance;
        if (waterDensity > 0.0) {
            movementLimiter *= 0.9;
            this.field_70181_x *= 0.8;
        }
        this.field_70159_w *= movementLimiter;
        this.field_70181_x *= movementLimiter;
        this.field_70179_y *= movementLimiter;
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
    }

    private void updateMotionAndRotation() {
        this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
        double motion = Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y);
        this.field_70177_z = (float)(Math.atan2(this.field_70181_x, this.field_70179_y) * 180.0 / Math.PI);
        this.field_70125_A = (float)(Math.atan2(this.field_70181_x, motion) * 180.0 / Math.PI);
        while ((double)this.field_70125_A - (double)this.field_70127_C < -180.0) {
            this.field_70127_C = (float)((double)this.field_70127_C - 360.0);
        }
        while ((double)this.field_70125_A - (double)this.field_70127_C >= 180.0) {
            this.field_70127_C = (float)((double)this.field_70127_C + 360.0);
        }
        while ((double)this.field_70177_z - (double)this.field_70126_B < -180.0) {
            this.field_70126_B = (float)((double)this.field_70126_B - 360.0);
        }
        while ((double)this.field_70177_z - (double)this.field_70126_B >= 180.0) {
            this.field_70126_B = (float)((double)this.field_70126_B + 360.0);
        }
        this.field_70125_A = (float)((double)this.field_70127_C + ((double)this.field_70125_A - (double)this.field_70127_C) * 0.2);
        this.field_70177_z = (float)((double)this.field_70126_B + ((double)this.field_70177_z - (double)this.field_70126_B) * 0.2);
    }

    private void checkIfFishBites(double waterDensity) {
        if (!CompatibilityUtils.getWorld((Entity)this).field_72995_K && waterDensity > 0.0) {
            int fishingProgressStep = 1;
            if (this.field_70146_Z.nextDouble() < 0.5 && !CompatibilityUtils.getWorld(this).func_175710_j(new BlockPos(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.field_70163_u) + 1, MathHelper.func_76128_c((double)this.field_70161_v)))) {
                --fishingProgressStep;
            }
            if (this.countdownNoFish > 0) {
                this.updateNoFishCounter();
                return;
            }
            WorldServer worldServer = (WorldServer)CompatibilityUtils.getWorld(this);
            if (this.countdownFishNear > 0) {
                this.renderBubble(fishingProgressStep, worldServer);
                return;
            }
            if (this.countdownFishBites > 0) {
                this.countdownFishBites -= fishingProgressStep;
                this.renderFishBiteOrSwim(worldServer);
            } else {
                this.countdownFishNear = MathHelper.func_76136_a((Random)this.field_70146_Z, (int)100, (int)900);
                this.countdownFishNear -= this.fishingSpeedEnchantment * 20 * 5;
            }
        }
    }

    private void updateNoFishCounter() {
        --this.countdownNoFish;
        if (this.countdownNoFish <= 0) {
            this.countdownFishNear = 0;
            this.countdownFishBites = 0;
        } else {
            this.field_70181_x -= this.field_70146_Z.nextDouble() * this.field_70146_Z.nextDouble() * this.field_70146_Z.nextDouble() * 0.2;
        }
    }

    private void renderBubble(int fishingProgressStep, @NotNull WorldServer worldServer) {
        this.countdownFishNear -= fishingProgressStep;
        double bubbleY = 0.15;
        if (this.countdownFishNear < 20) {
            bubbleY += (double)(20 - this.countdownFishNear) * 0.05;
        } else if (this.countdownFishNear < 40) {
            bubbleY += (double)(40 - this.countdownFishNear) * 0.02;
        } else if (this.countdownFishNear < 60) {
            bubbleY += (double)(60 - this.countdownFishNear) * 0.01;
        }
        if (this.field_70146_Z.nextDouble() < bubbleY) {
            this.renderLittleSplash(worldServer);
        }
        if (this.countdownFishNear <= 0) {
            this.relativeRotation = MathHelper.func_151240_a((Random)this.field_70146_Z, (float)0.0f, (float)360.0f);
            this.countdownFishBites = MathHelper.func_76136_a((Random)this.field_70146_Z, (int)20, (int)80);
        }
    }

    private void renderFishBiteOrSwim(@NotNull WorldServer worldServer) {
        if (this.countdownFishBites <= 0) {
            this.showFishBiteAnimation(worldServer);
        } else {
            this.showFishSwimmingTowardsHookAnimation(worldServer);
        }
    }

    private void renderLittleSplash(@NotNull WorldServer worldServer) {
        double sinYPosition = (double)MathHelper.func_151240_a((Random)this.field_70146_Z, (float)0.0f, (float)360.0f) * 0.017453292;
        double cosYPosition = MathHelper.func_151240_a((Random)this.field_70146_Z, (float)25.0f, (float)60.0f);
        double bubbleX = this.field_70165_t + Math.sin(sinYPosition) * cosYPosition * 0.1;
        double increasedYPosition = Math.floor(this.func_174813_aQ().field_72338_b) + 1.0;
        double bubbleZ = this.field_70161_v + Math.cos(sinYPosition) * cosYPosition * 0.1;
        worldServer.func_175739_a(EnumParticleTypes.WATER_SPLASH, bubbleX, increasedYPosition, bubbleZ, 2 + this.field_70146_Z.nextInt(2), (double)0.1f, 0.0, (double)0.1f, 0.0, new int[0]);
    }

    private void showFishBiteAnimation(@NotNull WorldServer worldServer) {
        this.field_70181_x -= (double)0.2f;
        this.func_184185_a(SoundEvents.field_187609_F, 0.25f, (float)(1.0 + this.field_70146_Z.nextGaussian() * 0.4));
        double bubbleY = Math.floor(this.func_174813_aQ().field_72338_b);
        worldServer.func_175739_a(EnumParticleTypes.WATER_BUBBLE, this.field_70165_t, bubbleY + 1.0, this.field_70161_v, (int)(1.0 + (double)this.field_70130_N * 20.0), (double)this.field_70130_N, 0.0, (double)this.field_70130_N, (double)0.2f, new int[0]);
        worldServer.func_175739_a(EnumParticleTypes.WATER_WAKE, this.field_70165_t, bubbleY + 1.0, this.field_70161_v, (int)(1.0 + (double)this.field_70130_N * 20.0), (double)this.field_70130_N, 0.0, (double)this.field_70130_N, (double)0.2f, new int[0]);
        this.countdownNoFish = MathHelper.func_76136_a((Random)this.field_70146_Z, (int)10, (int)30);
        this.isFishCaugth = true;
    }

    private void showFishSwimmingTowardsHookAnimation(@NotNull WorldServer worldServer) {
        this.relativeRotation += this.field_70146_Z.nextGaussian() * 4.0;
        double bubbleY = this.relativeRotation * 0.017453292;
        double sinYPosition = Math.sin(bubbleY);
        double cosYPosition = Math.cos(bubbleY);
        double bubbleX = this.field_70165_t + sinYPosition * (double)this.countdownFishBites * 0.1;
        double increasedYPosition = Math.floor(this.func_174813_aQ().field_72338_b) + 1.0;
        double bubbleZ = this.field_70161_v + cosYPosition * (double)this.countdownFishBites * 0.1;
        if (this.field_70146_Z.nextDouble() < 0.15) {
            worldServer.func_175739_a(EnumParticleTypes.WATER_BUBBLE, bubbleX, increasedYPosition - (double)0.1f, bubbleZ, 1, sinYPosition, 0.1, cosYPosition, 0.0, new int[0]);
        }
        double f3 = sinYPosition * 0.04;
        double f4 = cosYPosition * 0.04;
        worldServer.func_175739_a(EnumParticleTypes.WATER_WAKE, bubbleX, increasedYPosition, bubbleZ, 0, f4, 0.01, -f3, 1.0, new int[0]);
        worldServer.func_175739_a(EnumParticleTypes.WATER_WAKE, bubbleX, increasedYPosition, bubbleZ, 0, -f4, 0.01, f3, 1.0, new int[0]);
    }

    public int getDamage(@NotNull EntityCitizen citizen) {
        if (CompatibilityUtils.getWorld((Entity)this).field_72995_K) {
            this.func_70106_y();
            return 0;
        }
        int itemDamage = 0;
        if (this.isFishCaugth) {
            if (this.countdownNoFish > 0) {
                this.spawnLootAndExp(citizen);
                itemDamage = 1;
            }
            if (this.inGround) {
                itemDamage = 0;
            }
        }
        this.func_70106_y();
        return itemDamage;
    }

    private void spawnLootAndExp(@NotNull EntityCitizen citizen) {
        double citizenPosX = citizen.field_70165_t;
        double citizenPosY = citizen.field_70163_u;
        double citizenPosZ = citizen.field_70161_v;
        EntityItem entityitem = new EntityItem(CompatibilityUtils.getWorld(this), this.field_70165_t, this.field_70163_u, this.field_70161_v, this.getFishingLoot(citizen));
        double distanceX = citizenPosX - this.field_70165_t;
        double distanceY = citizenPosY - this.field_70163_u;
        double distanceZ = citizenPosZ - this.field_70161_v;
        entityitem.field_70159_w = distanceX * 0.1;
        entityitem.field_70181_x = distanceY * 0.1 + Math.sqrt(Math.sqrt(distanceX * distanceX + distanceY * distanceY + distanceZ * distanceZ)) * 0.08;
        entityitem.field_70179_y = distanceZ * 0.1;
        CompatibilityUtils.getWorld(this).func_72838_d((Entity)entityitem);
        CompatibilityUtils.getWorld((Entity)citizen).func_72838_d((Entity)new EntityXPOrb(CompatibilityUtils.getWorld((Entity)citizen), citizenPosX, citizenPosY + 0.0, citizenPosZ + 0.5, this.field_70146_Z.nextInt(6) + 1));
    }

    private ItemStack getFishingLoot(EntityCitizen citizen) {
        int lootBonus;
        int buildingLevel;
        int random = CompatibilityUtils.getWorld((Entity)this).field_73012_v.nextInt(200);
        if (random >= (buildingLevel = citizen.getWorkBuilding().getBuildingLevel()) * ((lootBonus = MathHelper.func_76125_a((int)(this.fishingLootEnchantment - this.fishingSpeedEnchantment), (int)0, (int)Integer.MAX_VALUE)) + 1) || buildingLevel == 1) {
            if (random >= 200 - buildingLevel * (lootBonus + 1) && buildingLevel >= 2) {
                return this.getLootForLootTable(LootTableList.field_186388_am);
            }
            return this.getLootForLootTable(LootTableList.field_186390_ao);
        }
        return this.getLootForLootTable(LootTableList.field_186389_an);
    }

    private ItemStack getLootForLootTable(ResourceLocation lootTable) {
        LootContext.Builder lootContextBuilder = new LootContext.Builder((WorldServer)CompatibilityUtils.getWorld(this));
        return CompatibilityUtils.getWorld(this).func_184146_ak().func_186521_a(lootTable).func_186462_a(this.field_70146_Z, lootContextBuilder.func_186471_a()).stream().findFirst().orElse(null);
    }

    public boolean caughtFish() {
        return this.isFishCaugth;
    }
}

