/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.commands.generalcommands;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.util.Log;
import com.minecolonies.coremod.colony.ColonyManager;
import com.minecolonies.coremod.commands.AbstractSingleCommand;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import org.jetbrains.annotations.NotNull;

public class WhoAmICommand
extends AbstractSingleCommand {
    public static final String DESC = "whoami";
    public static final String TELL_HIM = "You are %s, your colony is %s at position %s";

    public WhoAmICommand(String ... parents) {
        super(parents);
    }

    @Override
    public void execute(@NotNull MinecraftServer server, @NotNull ICommandSender sender, String ... args) throws CommandException {
        if (!(sender instanceof EntityPlayer)) {
            Log.getLogger().info("Very funny, you're a console!");
            return;
        }
        IColony colony = ColonyManager.getIColonyByOwner(server.func_130014_f_(), ((EntityPlayer)sender).func_110124_au());
        BlockPos pos = colony.getCenter();
        String colonyName = colony.getName();
        String playerName = sender.func_145748_c_().func_150254_d();
        String posString = "x: " + pos.func_177958_n() + " y: " + pos.func_177956_o() + " z: " + pos.func_177952_p();
        sender.func_145747_a((ITextComponent)new TextComponentString(String.format(TELL_HIM, playerName, colonyName, posString)));
    }

    @Override
    @NotNull
    public List<String> getTabCompletionOptions(@NotNull MinecraftServer server, @NotNull ICommandSender sender, @NotNull String[] args, @Nullable BlockPos pos) {
        return Collections.emptyList();
    }

    @Override
    public boolean isUsernameIndex(@NotNull String[] args, int index) {
        return false;
    }
}

