/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.commands.generalcommands;

import com.minecolonies.api.configuration.Configurations;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.ColonyManager;
import com.minecolonies.coremod.commands.AbstractSingleCommand;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import org.jetbrains.annotations.NotNull;

public class CheckForAutoDeletesCommand
extends AbstractSingleCommand {
    public static final String DESC = "check";

    public CheckForAutoDeletesCommand(String ... parents) {
        super(parents);
    }

    @Override
    public boolean canRankUseCommand(@NotNull Colony colony, @NotNull EntityPlayer player) {
        return false;
    }

    @Override
    public void execute(@NotNull MinecraftServer server, @NotNull ICommandSender sender, String ... args) throws CommandException {
        if (sender instanceof EntityPlayer && !CheckForAutoDeletesCommand.isPlayerOpped(sender)) {
            sender.func_145747_a((ITextComponent)new TextComponentString("Must be OP to use command"));
            return;
        }
        if (sender instanceof TileEntity) {
            return;
        }
        List<Colony> colonies = ColonyManager.getColonies();
        ArrayList<Colony> coloniesToDelete = new ArrayList<Colony>();
        for (int index = 0; colonies.size() - 1 >= index; ++index) {
            Colony colony = colonies.get(index);
            if (!colony.canBeAutoDeleted() || Configurations.Gameplay.autoDeleteColoniesInHours == 0 || colony.getLastContactInHours() < Configurations.Gameplay.autoDeleteColoniesInHours) continue;
            coloniesToDelete.add(colony);
        }
        if (args.length != 0) {
            if ("true".equalsIgnoreCase(args[0])) {
                sender.func_145747_a((ITextComponent)new TextComponentString("Successful"));
                for (Colony col : coloniesToDelete) {
                    server.func_152344_a(() -> ColonyManager.deleteColony(col.getID(), Configurations.Gameplay.autoDestroyColonyBlocks));
                }
            }
        } else {
            ITextComponent deleteButton = new TextComponentString("[DELETE]").func_150255_a(new Style().func_150227_a(Boolean.valueOf(true)).func_150238_a(TextFormatting.GOLD).func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/mc check true")));
            sender.func_145747_a((ITextComponent)new TextComponentString("There are: " + coloniesToDelete.size() + " of a total of " + colonies.size() + " to delete."));
            sender.func_145747_a((ITextComponent)new TextComponentString("Click [DELETE] to confirm"));
            sender.func_145747_a(deleteButton);
        }
    }

    @Override
    @NotNull
    public List<String> getTabCompletionOptions(@NotNull MinecraftServer server, @NotNull ICommandSender sender, @NotNull String[] args, @Nullable BlockPos pos) {
        return Collections.emptyList();
    }

    @Override
    public boolean isUsernameIndex(@NotNull String[] args, int index) {
        return index == 0 && args.length > 0 && !args[0].isEmpty() && CheckForAutoDeletesCommand.getIthArgument(args, 0, Integer.MAX_VALUE) == Integer.MAX_VALUE;
    }
}

