/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.commands.colonycommands;

import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.ColonyManager;
import com.minecolonies.coremod.commands.AbstractSingleCommand;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import org.jetbrains.annotations.NotNull;

public class MakeNotAutoDeletable
extends AbstractSingleCommand {
    public static final String DESC = "deletable";
    private static final String NO_COLONY_FOUND_MESSAGE_ID = "Colony with ID %d not found.";
    private static final String MARKED = "Marking succesful!";
    private static final String NOT_ENOUGH_ARGUMENTS = "You must have 2 Arguments: <ColonyId> <true|false> ";
    private static final int NUMBER_OR_ARGS_REQUIRED = 2;

    public MakeNotAutoDeletable(String ... parents) {
        super(parents);
    }

    @Override
    @NotNull
    public String getCommandUsage(@NotNull ICommandSender sender) {
        return super.getCommandUsage(sender) + "<ColonyId> <true|false>";
    }

    @Override
    public boolean canRankUseCommand(@NotNull Colony colony, @NotNull EntityPlayer player) {
        return false;
    }

    @Override
    public void execute(@NotNull MinecraftServer server, @NotNull ICommandSender sender, String ... args) throws CommandException {
        if (sender instanceof EntityPlayer && !MakeNotAutoDeletable.isPlayerOpped(sender)) {
            sender.func_145747_a((ITextComponent)new TextComponentString("Must be OP to use command"));
            return;
        }
        if (sender instanceof TileEntity) {
            return;
        }
        if (args.length < 2) {
            sender.func_145747_a((ITextComponent)new TextComponentString(NOT_ENOUGH_ARGUMENTS));
            return;
        }
        sender.func_145747_a((ITextComponent)new TextComponentString(Arrays.toString(args)));
        int colonyId = Integer.parseInt(args[0]);
        Colony colony = ColonyManager.getColony(colonyId);
        boolean canBeDeleted = Boolean.parseBoolean(args[1]);
        if (colony == null) {
            sender.func_145747_a((ITextComponent)new TextComponentString(String.format(NO_COLONY_FOUND_MESSAGE_ID, colonyId)));
            return;
        }
        sender.func_145747_a((ITextComponent)new TextComponentString(MARKED));
        colony.setCanBeAutoDeleted(canBeDeleted);
    }

    @Override
    @NotNull
    public List<String> getTabCompletionOptions(@NotNull MinecraftServer server, @NotNull ICommandSender sender, @NotNull String[] args, @Nullable BlockPos pos) {
        return Collections.emptyList();
    }

    @Override
    public boolean isUsernameIndex(@NotNull String[] args, int index) {
        return index == 0 && args.length > 0 && !args[0].isEmpty() && MakeNotAutoDeletable.getIthArgument(args, 0, Integer.MAX_VALUE) == Integer.MAX_VALUE;
    }
}

