/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.commands.colonycommands;

import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.ColonyManager;
import com.minecolonies.coremod.commands.AbstractSingleCommand;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import org.jetbrains.annotations.NotNull;

public class DoRaidTonightCommand
extends AbstractSingleCommand {
    public static final String DESC = "raid-tonight";
    private static final TextComponentString NO_COLONY_FOUND_MESSAGE_ID = new TextComponentString("No Colony found.");
    private static final TextComponentString NO_ARGUMENTS = new TextComponentString("Please define a colony to raid tonight.");
    private static final TextComponentString SUCCESSFUL = new TextComponentString("Command Successful");

    public DoRaidTonightCommand(String ... parents) {
        super(parents);
    }

    @Override
    @NotNull
    public String getCommandUsage(@NotNull ICommandSender sender) {
        return super.getCommandUsage(sender) + "<ColonyId>";
    }

    @Override
    public void execute(@NotNull MinecraftServer server, @NotNull ICommandSender sender, String ... args) throws CommandException {
        if (sender instanceof EntityPlayer && !DoRaidTonightCommand.isPlayerOpped(sender)) {
            sender.func_145747_a((ITextComponent)new TextComponentString("Must be OP to use command"));
            return;
        }
        if (args.length != 0) {
            Colony colony = ColonyManager.getColony(Integer.parseInt(args[0]));
            if (colony == null) {
                sender.func_145747_a((ITextComponent)NO_COLONY_FOUND_MESSAGE_ID);
                return;
            }
            colony.getBarbManager().setWillRaidTonight(true);
            sender.func_145747_a((ITextComponent)SUCCESSFUL);
        } else {
            sender.func_145747_a((ITextComponent)NO_ARGUMENTS);
        }
    }

    @Override
    @NotNull
    public List<String> getTabCompletionOptions(@NotNull MinecraftServer server, @NotNull ICommandSender sender, @NotNull String[] args, @Nullable BlockPos pos) {
        return Collections.emptyList();
    }

    @Override
    public boolean isUsernameIndex(@NotNull String[] args, int index) {
        return index == 0 && args.length > 0 && !args[0].isEmpty() && DoRaidTonightCommand.getIthArgument(args, 0, Integer.MAX_VALUE) == Integer.MAX_VALUE;
    }
}

