/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.commands.colonycommands;

import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.ColonyManager;
import com.minecolonies.coremod.commands.AbstractSingleCommand;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import org.jetbrains.annotations.NotNull;

public class DisableBarbarianSpawnsCommand
extends AbstractSingleCommand {
    public static final String DESC = "barbarians";
    private static final String NO_ARGUMENTS = "Please define a colony";
    private static final String NO_COLONY_FOUND_MESSAGE_ID = "Colony with ID %d not found.";

    public DisableBarbarianSpawnsCommand(String ... parents) {
        super(parents);
    }

    @Override
    @NotNull
    public String getCommandUsage(@NotNull ICommandSender sender) {
        return super.getCommandUsage(sender) + "<ColonyId> <true|false>";
    }

    @Override
    public void execute(@NotNull MinecraftServer server, @NotNull ICommandSender sender, String ... args) throws CommandException {
        int colonyId;
        Colony colony;
        if (sender instanceof EntityPlayer && !DisableBarbarianSpawnsCommand.isPlayerOpped(sender)) {
            sender.func_145747_a((ITextComponent)new TextComponentString("Must be OP to use this command"));
        }
        if (args.length == 0) {
            sender.func_145747_a((ITextComponent)new TextComponentString(NO_ARGUMENTS));
        }
        if ((colony = ColonyManager.getColony(colonyId = DisableBarbarianSpawnsCommand.getIthArgument(args, 0, -1))) == null) {
            sender.func_145747_a((ITextComponent)new TextComponentString(NO_COLONY_FOUND_MESSAGE_ID));
            return;
        }
        boolean setBarbsTo = Boolean.parseBoolean(args[1]);
        colony.getBarbManager().setCanHaveBarbEvents(setBarbsTo);
        sender.func_145747_a((ITextComponent)new TextComponentString("Colony \" Can have Barbarian Events \" now set to: " + colony.isCanHaveBarbEvents()));
    }

    @Override
    @NotNull
    public List<String> getTabCompletionOptions(@NotNull MinecraftServer server, @NotNull ICommandSender sender, @NotNull String[] args, @Nullable BlockPos pos) {
        return Collections.emptyList();
    }

    @Override
    public boolean isUsernameIndex(@NotNull String[] args, int index) {
        return false;
    }
}

