/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.commands.colonycommands;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.permissions.Rank;
import com.minecolonies.api.util.CompatibilityUtils;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.ColonyManager;
import com.minecolonies.coremod.commands.AbstractSingleCommand;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import org.jetbrains.annotations.NotNull;

public class DeleteColonyCommand
extends AbstractSingleCommand {
    public static final String DESC = "delete";
    private static final String NO_COLONY_FOUND_MESSAGE_ID = "Colony with ID %d not found.";
    private static final String NO_ARGUMENTS = "Please define a colony to delete";

    public DeleteColonyCommand(String ... parents) {
        super(parents);
    }

    @Override
    @NotNull
    public String getCommandUsage(@NotNull ICommandSender sender) {
        return super.getCommandUsage(sender) + "<ColonyId|OwnerName>";
    }

    @Override
    public boolean canRankUseCommand(@NotNull Colony colony, @NotNull EntityPlayer player) {
        return colony.getPermissions().getRank(player).equals((Object)Rank.OWNER);
    }

    @Override
    public void execute(@NotNull MinecraftServer server, @NotNull ICommandSender sender, String ... args) throws CommandException {
        EntityPlayer player;
        int colonyId;
        IColony colony;
        boolean canDestroy = true;
        boolean canDelete = false;
        if (args.length == 0) {
            colony = null;
            if (sender instanceof EntityPlayer) {
                colony = ColonyManager.getIColonyByOwner(CompatibilityUtils.getWorld((Entity)((EntityPlayer)sender)), (EntityPlayer)sender);
            }
            if (colony == null) {
                sender.func_145747_a((ITextComponent)new TextComponentString(NO_ARGUMENTS));
                return;
            }
            colonyId = colony.getID();
        } else {
            colonyId = DeleteColonyCommand.getIthArgument(args, 0, -1);
            if (args.length > 1) {
                canDestroy = Boolean.parseBoolean(args[1]);
            }
            if (args.length > 2) {
                canDelete = Boolean.parseBoolean(args[2]);
            }
        }
        if (!canDelete) {
            ITextComponent deleteButton = new TextComponentString("[DELETE]").func_150255_a(new Style().func_150227_a(Boolean.valueOf(true)).func_150238_a(TextFormatting.GOLD).func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/mc colony delete " + colonyId + " " + canDestroy + " true")));
            sender.func_145747_a((ITextComponent)new TextComponentString("Click [DELETE] to confirm the deletion of colony: " + colonyId));
            sender.func_145747_a(deleteButton);
            return;
        }
        colony = ColonyManager.getColony(colonyId);
        if (colony == null) {
            sender.func_145747_a((ITextComponent)new TextComponentString(NO_COLONY_FOUND_MESSAGE_ID));
            return;
        }
        Entity senderEntity = sender.func_174793_f();
        if (senderEntity instanceof EntityPlayer && !this.canPlayerUseCommand(player = (EntityPlayer)sender, AbstractSingleCommand.Commands.DELETECOLONY, colonyId)) {
            senderEntity.func_145747_a((ITextComponent)new TextComponentString("You are not allowed to do that!"));
            return;
        }
        boolean shouldDestroy = canDestroy;
        server.func_152344_a(() -> DeleteColonyCommand.lambda$execute$0((Colony)colony, shouldDestroy));
    }

    @Override
    @NotNull
    public List<String> getTabCompletionOptions(@NotNull MinecraftServer server, @NotNull ICommandSender sender, @NotNull String[] args, @Nullable BlockPos pos) {
        return Collections.emptyList();
    }

    @Override
    public boolean isUsernameIndex(@NotNull String[] args, int index) {
        return index == 0 && args.length > 0 && !args[0].isEmpty() && DeleteColonyCommand.getIthArgument(args, 0, Integer.MAX_VALUE) == Integer.MAX_VALUE;
    }

    private static /* synthetic */ void lambda$execute$0(Colony colony, boolean shouldDestroy) {
        ColonyManager.deleteColony(colony.getID(), shouldDestroy);
    }
}

