/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.commands.citizencommands;

import com.minecolonies.api.colony.permissions.Rank;
import com.minecolonies.coremod.colony.CitizenData;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.ColonyManager;
import com.minecolonies.coremod.commands.AbstractSingleCommand;
import com.minecolonies.coremod.commands.citizencommands.AbstractCitizensCommands;
import com.minecolonies.coremod.entity.EntityCitizen;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import org.jetbrains.annotations.NotNull;

public class KillCitizenCommand
extends AbstractCitizensCommands {
    public static final String DESC = "kill";
    private static final String CITIZEN_DESCRIPTION = "\u00a72ID: \u00a7f %d \u00a72 Name: \u00a7f %s";
    private static final String REMOVED_MESSAGE = "Has been removed";
    private static final String COORDINATES_XYZ = "\u00a74x=\u00a7f%s \u00a74y=\u00a7f%s \u00a74z=\u00a7f%s";
    private static final DamageSource CONSOLE_DAMAGE_SOURCE = new DamageSource("Console");

    public KillCitizenCommand(String ... parents) {
        super(parents);
    }

    @Override
    @NotNull
    public String getCommandUsage(@NotNull ICommandSender sender) {
        return super.getCommandUsage(sender) + "<ColonyId> <CitizenId>";
    }

    @Override
    void executeSpecializedCode(@NotNull MinecraftServer server, ICommandSender sender, Colony colony, int citizenId) {
        CitizenData citizenData = colony.getCitizenManager().getCitizen(citizenId);
        EntityCitizen entityCitizen = citizenData.getCitizenEntity();
        sender.func_145747_a((ITextComponent)new TextComponentString(String.format(CITIZEN_DESCRIPTION, citizenData.getId(), citizenData.getName())));
        BlockPos position = entityCitizen.func_180425_c();
        sender.func_145747_a((ITextComponent)new TextComponentString(String.format(COORDINATES_XYZ, position.func_177958_n(), position.func_177956_o(), position.func_177952_p())));
        sender.func_145747_a((ITextComponent)new TextComponentString(REMOVED_MESSAGE));
        server.func_152344_a(() -> entityCitizen.func_70645_a(CONSOLE_DAMAGE_SOURCE));
    }

    @Override
    @NotNull
    public List<String> getTabCompletionOptions(@NotNull MinecraftServer server, @NotNull ICommandSender sender, @NotNull String[] args, @Nullable BlockPos pos) {
        return Collections.emptyList();
    }

    @Override
    public boolean isUsernameIndex(@NotNull String[] args, int index) {
        return false;
    }

    @Override
    public AbstractSingleCommand.Commands getCommand() {
        return AbstractSingleCommand.Commands.KILLCITIZENS;
    }

    @Override
    public boolean canPlayerUseCommand(EntityPlayer player, AbstractSingleCommand.Commands theCommand, int colonyId) {
        return super.canPlayerUseCommand(player, theCommand, colonyId) && ColonyManager.getColony(colonyId) != null && ColonyManager.getColony(colonyId).getPermissions().getRank(player).equals((Object)Rank.OWNER);
    }
}

