/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.commands.citizencommands;

import com.minecolonies.coremod.colony.CitizenData;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.commands.AbstractSingleCommand;
import com.minecolonies.coremod.commands.citizencommands.AbstractCitizensCommands;
import com.minecolonies.coremod.entity.EntityCitizen;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import org.jetbrains.annotations.NotNull;

public class CitizenInfoCommand
extends AbstractCitizensCommands {
    public static final String DESC = "info";
    private static final String CITIZEN_DESCRIPTION = "\u00a72ID: \u00a7f %d \u00a72 Name: \u00a7f %s";
    private static final String CITIZEN_LEVEL_AND_AGE = "\u00a72Level: \u00a7f%s \u00a72Age: \u00a7f%s \u00a72Experience: \u00a7f%s";
    private static final String CITIZEN_SKILLS = "\u00a72Charisma: \u00a7f%s \u00a72Dexterity: \u00a7f%s \u00a72Endurance: \u00a7f%s\n\u00a72Intelligence: \u00a7f%s \u00a72Strength: \u00a7f%s";
    private static final String CITIZEN_JOB = "\u00a72Job: \u00a7f%s";
    private static final String CITIZEN_JOB_NULL = "\u00a72Job: \u00a7fUnemployed";
    private static final String CITIZEN_HEALTH = "\u00a72Health: \u00a7f%s \u00a72Max Health: \u00a7f%s";
    private static final String CITIZEN_DESIRED_ACTIVITY = "\u00a72Desired activity: \u00a7f%s \u00a72Current Activity: \u00a7f%s";
    private static final String CITIZEN_HOME_POSITION = "\u00a72Home position: \u00a74x=\u00a7f%s \u00a74y=\u00a7f%s \u00a74z=\u00a7f%s";
    private static final String CITIZEN_WORK_POSITION = "\u00a72Work position: \u00a74x=\u00a7f%s \u00a74y=\u00a7f%s \u00a74z=\u00a7f%s";
    private static final String CITIZEN_POSITION = "\u00a72Citizen position: \u00a74x=\u00a7f%s \u00a74y=\u00a7f%s \u00a74z=\u00a7f%s";
    private static final String CITIZEN_WORK_POSITION_NULL = "\u00a72Work position: \u00a74No work position found!";
    private static final String CITIZEN_NO_ACTIVITY = "\u00a74No activity is being desired or executed!";
    private static final String CITIZEN_NOT_LOADED = "Citizen entity not loaded!";

    public CitizenInfoCommand(String ... parents) {
        super(parents);
    }

    @Override
    @NotNull
    public String getCommandUsage(@NotNull ICommandSender sender) {
        return super.getCommandUsage(sender) + "<ColonyId> <CitizenId>";
    }

    @Override
    void executeSpecializedCode(@NotNull MinecraftServer server, ICommandSender sender, Colony colony, int citizenId) {
        CitizenData citizenData = colony.getCitizenManager().getCitizen(citizenId);
        EntityCitizen entityCitizen = citizenData.getCitizenEntity();
        sender.func_145747_a((ITextComponent)new TextComponentString(String.format(CITIZEN_DESCRIPTION, citizenData.getId(), citizenData.getName())));
        if (entityCitizen == null) {
            sender.func_145747_a((ITextComponent)new TextComponentTranslation(CITIZEN_NOT_LOADED, new Object[0]));
            return;
        }
        BlockPos citizenPosition = entityCitizen.func_180425_c();
        sender.func_145747_a((ITextComponent)new TextComponentString(String.format(CITIZEN_POSITION, citizenPosition.func_177958_n(), citizenPosition.func_177956_o(), citizenPosition.func_177952_p())));
        BlockPos homePosition = entityCitizen.func_180486_cf();
        sender.func_145747_a((ITextComponent)new TextComponentString(String.format(CITIZEN_HOME_POSITION, homePosition.func_177958_n(), homePosition.func_177956_o(), homePosition.func_177952_p())));
        if (entityCitizen.getWorkBuilding() == null) {
            sender.func_145747_a((ITextComponent)new TextComponentString(String.format(CITIZEN_WORK_POSITION_NULL, new Object[0])));
        } else {
            BlockPos workingPosition = entityCitizen.getWorkBuilding().getLocation();
            sender.func_145747_a((ITextComponent)new TextComponentString(String.format(CITIZEN_WORK_POSITION, workingPosition.func_177958_n(), workingPosition.func_177956_o(), workingPosition.func_177952_p())));
        }
        sender.func_145747_a((ITextComponent)new TextComponentString(String.format(CITIZEN_HEALTH, Float.valueOf(entityCitizen.func_110143_aJ()), Float.valueOf(entityCitizen.func_110138_aP()))));
        sender.func_145747_a((ITextComponent)new TextComponentString(String.format(CITIZEN_LEVEL_AND_AGE, entityCitizen.getLevel(), entityCitizen.func_70874_b(), citizenData.getLevel())));
        sender.func_145747_a((ITextComponent)new TextComponentString(String.format(CITIZEN_SKILLS, citizenData.getCharisma(), citizenData.getDexterity(), citizenData.getEndurance(), citizenData.getIntelligence(), citizenData.getStrength())));
        if (entityCitizen.getColonyJob() == null) {
            sender.func_145747_a((ITextComponent)new TextComponentString(String.format(CITIZEN_JOB_NULL, new Object[0])));
            sender.func_145747_a((ITextComponent)new TextComponentString(String.format(CITIZEN_NO_ACTIVITY, new Object[0])));
        } else if (entityCitizen.getWorkBuilding() != null) {
            sender.func_145747_a((ITextComponent)new TextComponentString(String.format(CITIZEN_JOB, entityCitizen.getWorkBuilding().getJobName())));
            sender.func_145747_a((ITextComponent)new TextComponentString(String.format(CITIZEN_DESIRED_ACTIVITY, new Object[]{entityCitizen.getDesiredActivity(), entityCitizen.getColonyJob().getNameTagDescription()})));
        }
    }

    @Override
    @NotNull
    public List<String> getTabCompletionOptions(@NotNull MinecraftServer server, @NotNull ICommandSender sender, @NotNull String[] args, @Nullable BlockPos pos) {
        return Collections.emptyList();
    }

    @Override
    public boolean isUsernameIndex(@NotNull String[] args, int index) {
        return false;
    }

    @Override
    public AbstractSingleCommand.Commands getCommand() {
        return AbstractSingleCommand.Commands.CITIZENINFO;
    }
}

