/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.workorders;

import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.LanguageHandler;
import com.minecolonies.api.util.Log;
import com.minecolonies.coremod.colony.CitizenData;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.StructureName;
import com.minecolonies.coremod.colony.Structures;
import com.minecolonies.coremod.colony.jobs.JobBuilder;
import com.minecolonies.coremod.colony.workorders.AbstractWorkOrder;
import com.minecolonies.coremod.entity.ai.citizen.builder.ConstructionTapeHelper;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

public class WorkOrderBuildDecoration
extends AbstractWorkOrder {
    private static final String TAG_BUILDING = "building";
    private static final String TAG_WORKORDER_NAME = "workOrderName";
    private static final String TAG_IS_CLEARED = "cleared";
    private static final String TAG_IS_REQUESTED = "requested";
    private static final String TAG_IS_MIRRORED = "mirrored";
    private static final String TAG_SCHEMATIC_NAME = "structureName";
    private static final String TAG_SCHEMATIC_MD5 = "schematicMD5";
    private static final String TAG_BUILDING_ROTATION = "buildingRotation";
    protected boolean isMirrored;
    protected BlockPos buildingLocation;
    protected int buildingRotation;
    protected String structureName;
    protected String md5;
    protected boolean cleared;
    protected String workOrderName;
    protected boolean hasSentMessageForThisWorkOrder = false;
    private boolean requested;

    public WorkOrderBuildDecoration() {
    }

    public WorkOrderBuildDecoration(String structureName, String workOrderName, int rotation, BlockPos location, boolean mirror) {
        StructureName sn = new StructureName(structureName);
        this.structureName = sn.toString();
        this.workOrderName = workOrderName;
        this.buildingRotation = rotation;
        this.buildingLocation = location;
        this.cleared = false;
        this.isMirrored = mirror;
        this.requested = false;
    }

    public String getName() {
        return this.workOrderName;
    }

    @Override
    public void readFromNBT(@NotNull NBTTagCompound compound) {
        super.readFromNBT(compound);
        this.buildingLocation = BlockPosUtil.readFromNBT(compound, TAG_BUILDING);
        StructureName sn = new StructureName(compound.func_74779_i(TAG_SCHEMATIC_NAME));
        this.structureName = sn.toString();
        this.workOrderName = compound.func_74779_i(TAG_WORKORDER_NAME);
        this.cleared = compound.func_74767_n(TAG_IS_CLEARED);
        this.md5 = compound.func_74779_i(TAG_SCHEMATIC_MD5);
        if (!Structures.hasMD5(this.structureName)) {
            StructureName newSN = Structures.getStructureNameByMD5(this.md5);
            if (newSN == null) {
                Log.getLogger().error("WorkOrderBuildDecoration.readFromNBT: Could not find " + this.structureName);
            } else {
                Log.getLogger().warn("WorkOrderBuildDecoration.readFromNBT: replace " + sn + " by " + newSN);
                this.structureName = newSN.toString();
            }
        }
        this.buildingRotation = compound.func_74762_e(TAG_BUILDING_ROTATION);
        this.requested = compound.func_74767_n(TAG_IS_REQUESTED);
        this.isMirrored = compound.func_74767_n(TAG_IS_MIRRORED);
    }

    @Override
    public void writeToNBT(@NotNull NBTTagCompound compound) {
        super.writeToNBT(compound);
        BlockPosUtil.writeToNBT(compound, TAG_BUILDING, this.buildingLocation);
        if (this.workOrderName != null) {
            compound.func_74778_a(TAG_WORKORDER_NAME, this.workOrderName);
        }
        compound.func_74757_a(TAG_IS_CLEARED, this.cleared);
        if (this.md5 != null) {
            compound.func_74778_a(TAG_SCHEMATIC_MD5, this.md5);
        }
        if (this.structureName == null) {
            Log.getLogger().error("WorkOrderBuild.writeToNBT: structureName should not be null!!!");
        } else {
            compound.func_74778_a(TAG_SCHEMATIC_NAME, this.structureName);
        }
        compound.func_74768_a(TAG_BUILDING_ROTATION, this.buildingRotation);
        compound.func_74757_a(TAG_IS_REQUESTED, this.requested);
        compound.func_74757_a(TAG_IS_MIRRORED, this.isMirrored);
    }

    @Override
    public boolean isValid(Colony colony) {
        return true;
    }

    @Override
    public void attemptToFulfill(@NotNull Colony colony) {
        boolean sendMessage = true;
        boolean hasBuilder = false;
        double distanceToBuilder = 0.0;
        CitizenData claimedBy = null;
        for (CitizenData citizen : colony.getCitizenManager().getCitizens()) {
            JobBuilder job = citizen.getJob(JobBuilder.class);
            if (job == null || citizen.getWorkBuilding() == null) continue;
            hasBuilder = true;
            if (this.canBuild(citizen)) {
                sendMessage = false;
            }
            if (job.hasWorkOrder() || !this.canBuild(citizen)) continue;
            double distance = citizen.getWorkBuilding().getID().func_177951_i((Vec3i)this.buildingLocation);
            if (claimedBy != null && !(distance < distanceToBuilder)) continue;
            claimedBy = citizen;
            distanceToBuilder = distance;
        }
        if (claimedBy != null) {
            JobBuilder job = claimedBy.getJob(JobBuilder.class);
            job.setWorkOrder(this);
            this.setClaimedBy(claimedBy);
            return;
        }
        this.sendBuilderMessage(colony, hasBuilder, sendMessage);
    }

    protected boolean canBuild(@NotNull CitizenData citizen) {
        return true;
    }

    protected void sendBuilderMessage(@NotNull Colony colony, boolean hasBuilder, boolean sendMessage) {
        if (this.hasSentMessageForThisWorkOrder || hasBuilder) {
            return;
        }
        this.hasSentMessageForThisWorkOrder = true;
        LanguageHandler.sendPlayersMessage(colony.getMessageEntityPlayers(), "entity.builder.messageNoBuilder", new Object[0]);
    }

    @Override
    @NotNull
    protected AbstractWorkOrder.WorkOrderType getType() {
        return AbstractWorkOrder.WorkOrderType.BUILD;
    }

    @Override
    protected String getValue() {
        return this.workOrderName;
    }

    @Override
    public void onAdded(Colony colony) {
        super.onAdded(colony);
        if (colony != null && colony.getWorld() != null) {
            ConstructionTapeHelper.placeConstructionTape(this, colony.getWorld());
        }
    }

    @Override
    public void onRemoved(Colony colony) {
        super.onRemoved(colony);
        ConstructionTapeHelper.removeConstructionTape(this, colony.getWorld());
    }

    public BlockPos getBuildingLocation() {
        return this.buildingLocation;
    }

    public String getStructureName() {
        return this.structureName;
    }

    public int getRotation(World world) {
        return this.buildingRotation;
    }

    public boolean isCleared() {
        return this.cleared;
    }

    public void setCleared(boolean cleared) {
        this.cleared = cleared;
    }

    public boolean isRequested() {
        return this.requested;
    }

    public void setRequested(boolean requested) {
        this.requested = requested;
    }

    public boolean isMirrored() {
        return this.isMirrored;
    }
}

