/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.workorders;

import com.minecolonies.api.util.BlockUtils;
import com.minecolonies.api.util.LanguageHandler;
import com.minecolonies.api.util.Log;
import com.minecolonies.coremod.blocks.AbstractBlockHut;
import com.minecolonies.coremod.colony.CitizenData;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.StructureName;
import com.minecolonies.coremod.colony.Structures;
import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import com.minecolonies.coremod.colony.workorders.WorkOrderBuildDecoration;
import com.minecolonies.coremod.entity.ai.citizen.builder.ConstructionTapeHelper;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

public class WorkOrderBuild
extends WorkOrderBuildDecoration {
    private static final String TAG_UPGRADE_LEVEL = "upgradeLevel";
    private static final String TAG_UPGRADE_NAME = "upgrade";
    private int upgradeLevel;
    private String upgradeName;

    public WorkOrderBuild() {
    }

    public WorkOrderBuild(@NotNull AbstractBuilding building, int level) {
        this.buildingLocation = building.getID();
        this.upgradeLevel = level;
        this.upgradeName = building.getSchematicName() + level;
        this.buildingRotation = building.getRotation();
        this.isMirrored = building.getTileEntity() == null ? building.isMirrored() : building.getTileEntity().isMirrored();
        this.cleared = level > 1;
        StructureName sn = new StructureName("schematics", building.getStyle(), this.getUpgradeName());
        if (building.getTileEntity() != null && !building.getTileEntity().getStyle().isEmpty()) {
            String previousStructureName = sn.toString();
            sn = new StructureName("schematics", building.getTileEntity().getStyle(), this.getUpgradeName());
            Log.getLogger().info("WorkOrderBuild at location " + this.buildingLocation + " is using " + sn + " instead of " + previousStructureName);
        }
        this.workOrderName = this.structureName = sn.toString();
        this.md5 = Structures.getMD5(this.structureName);
    }

    public String getUpgradeName() {
        return this.upgradeName;
    }

    @Override
    public void readFromNBT(@NotNull NBTTagCompound compound) {
        super.readFromNBT(compound);
        this.upgradeLevel = compound.func_74762_e(TAG_UPGRADE_LEVEL);
        this.upgradeName = compound.func_74779_i(TAG_UPGRADE_NAME);
    }

    @Override
    public void writeToNBT(@NotNull NBTTagCompound compound) {
        super.writeToNBT(compound);
        compound.func_74768_a(TAG_UPGRADE_LEVEL, this.upgradeLevel);
        compound.func_74778_a(TAG_UPGRADE_NAME, this.upgradeName);
    }

    @Override
    protected void sendBuilderMessage(@NotNull Colony colony, boolean hasBuilder, boolean sendMessage) {
        if (this.hasSentMessageForThisWorkOrder) {
            return;
        }
        if (hasBuilder && sendMessage) {
            this.hasSentMessageForThisWorkOrder = true;
            LanguageHandler.sendPlayersMessage(colony.getMessageEntityPlayers(), "entity.builder.messageBuilderNecessary", Integer.toString(this.upgradeLevel));
        }
        if (!hasBuilder) {
            this.hasSentMessageForThisWorkOrder = true;
            LanguageHandler.sendPlayersMessage(colony.getMessageEntityPlayers(), "entity.builder.messageNoBuilder", new Object[0]);
        }
    }

    @Override
    protected boolean canBuild(@NotNull CitizenData citizen) {
        int builderLevel = citizen.getWorkBuilding().getBuildingLevel();
        return builderLevel >= this.upgradeLevel || builderLevel == 5 || citizen.getWorkBuilding() != null && citizen.getWorkBuilding().getID().equals((Object)this.buildingLocation) || WorkOrderBuild.isLocationTownhall(citizen.getColony(), this.buildingLocation);
    }

    @Override
    public boolean isValid(@NotNull Colony colony) {
        return colony.getBuildingManager().getBuilding(this.buildingLocation) != null;
    }

    @Override
    protected String getValue() {
        return this.upgradeName;
    }

    @Override
    public int getRotation(World world) {
        IBlockState blockState;
        if (this.buildingRotation == 0 && world != null && (blockState = world.func_180495_p(this.buildingLocation)).func_177230_c() instanceof AbstractBlockHut) {
            return BlockUtils.getRotationFromFacing((EnumFacing)blockState.func_177229_b((IProperty)AbstractBlockHut.FACING));
        }
        return this.buildingRotation;
    }

    @Override
    public void onAdded(Colony colony) {
        AbstractBuilding building;
        if (colony != null && colony.getWorld() != null && (building = colony.getBuildingManager().getBuilding(this.getBuildingLocation())) != null) {
            ConstructionTapeHelper.placeConstructionTape(building.getLocation(), building.getCorners(), colony.getWorld());
        }
    }

    @Override
    public void onRemoved(Colony colony) {
        AbstractBuilding building = colony.getBuildingManager().getBuilding(this.getBuildingLocation());
        if (building != null) {
            building.markDirty();
            ConstructionTapeHelper.removeConstructionTape(building.getCorners(), colony.getWorld());
        }
    }

    private static boolean isLocationTownhall(@NotNull Colony colony, BlockPos buildingLocation) {
        return colony.hasTownHall() && colony.getBuildingManager().getTownHall() != null && colony.getBuildingManager().getTownHall().getID().equals((Object)buildingLocation);
    }

    @Override
    public void onCompleted(Colony colony) {
        BlockPos buildingLocation = this.getBuildingLocation();
        AbstractBuilding building = colony.getBuildingManager().getBuilding(buildingLocation);
        colony.onBuildingUpgradeComplete(building, this.getUpgradeLevel());
    }

    public int getUpgradeLevel() {
        return this.upgradeLevel;
    }
}

