/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.requestsystem.resolvers;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.reflect.TypeToken;
import com.minecolonies.api.colony.requestsystem.location.ILocation;
import com.minecolonies.api.colony.requestsystem.manager.IRequestManager;
import com.minecolonies.api.colony.requestsystem.request.IRequest;
import com.minecolonies.api.colony.requestsystem.request.RequestState;
import com.minecolonies.api.colony.requestsystem.requestable.Delivery;
import com.minecolonies.api.colony.requestsystem.requestable.IDeliverable;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.constant.TypeConstants;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.buildings.BuildingWareHouse;
import com.minecolonies.coremod.colony.requestsystem.resolvers.AbstractRequestResolver;
import com.minecolonies.coremod.tileentities.TileEntityWareHouse;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WarehouseRequestResolver
extends AbstractRequestResolver<IDeliverable> {
    public WarehouseRequestResolver(@NotNull ILocation location, @NotNull IToken<?> token) {
        super(location, token);
    }

    @Override
    public TypeToken<? extends IDeliverable> getRequestType() {
        return TypeToken.of(IDeliverable.class);
    }

    @Override
    public boolean canResolve(@NotNull IRequestManager manager, IRequest<? extends IDeliverable> requestToCheck) {
        if (!manager.getColony().getWorld().field_72995_K) {
            Colony colony = (Colony)manager.getColony();
            Set<TileEntityWareHouse> wareHouses = WarehouseRequestResolver.getWareHousesInColony(colony);
            wareHouses.removeIf(Objects::isNull);
            return wareHouses.stream().anyMatch(wareHouse -> wareHouse.hasMatchinItemStackInWarehouse(itemStack -> ItemStackUtils.isEmpty(itemStack) == false && ((IDeliverable)requestToCheck.getRequest()).matches((ItemStack)itemStack)));
        }
        return false;
    }

    @Override
    @Nullable
    public List<IToken<?>> attemptResolve(@NotNull IRequestManager manager, @NotNull IRequest<? extends IDeliverable> request) {
        if (manager.getColony().getWorld().field_72995_K) {
            return null;
        }
        Colony colony = (Colony)manager.getColony();
        Set<TileEntityWareHouse> wareHouses = WarehouseRequestResolver.getWareHousesInColony(colony);
        for (TileEntityWareHouse wareHouse : wareHouses) {
            ItemStack matchingStack = wareHouse.getFirstMatchingItemStackInWarehouse(itemStack -> ((IDeliverable)request.getRequest()).matches((ItemStack)itemStack));
            if (ItemStackUtils.isEmpty(matchingStack).booleanValue()) continue;
            matchingStack = matchingStack.func_77946_l();
            matchingStack.field_77994_a = Math.min(request.getRequest().getCount(), matchingStack.field_77994_a);
            ItemStack deliveryStack = matchingStack.func_77946_l();
            request.setDelivery(deliveryStack.func_77946_l());
            BlockPos itemStackPos = wareHouse.getPositionOfChestWithItemStack(itemStack -> ItemStack.func_179545_c((ItemStack)itemStack, (ItemStack)deliveryStack));
            ILocation itemStackLocation = manager.getFactoryController().getNewInstance(TypeConstants.ILOCATION, itemStackPos, wareHouse.func_145831_w().field_73011_w.getDimension());
            Delivery delivery = new Delivery(itemStackLocation, request.getRequester().getRequesterLocation(), deliveryStack.func_77946_l());
            IToken<?> requestToken = manager.createRequest(new WarehouseRequestResolver(request.getRequester().getRequesterLocation(), (IToken<?>)request.getToken()), delivery);
            return ImmutableList.of(requestToken);
        }
        return Lists.newArrayList();
    }

    @Override
    public void resolve(@NotNull IRequestManager manager, @NotNull IRequest<? extends IDeliverable> request) {
        manager.updateRequestState((IToken<?>)request.getToken(), RequestState.COMPLETED);
    }

    @Override
    @Nullable
    public IRequest<?> getFollowupRequestForCompletion(@NotNull IRequestManager manager, @NotNull IRequest<? extends IDeliverable> completedRequest) {
        return null;
    }

    @Override
    @Nullable
    public IRequest<?> onRequestCancelledOrOverruled(@NotNull IRequestManager manager, @NotNull IRequest<? extends IDeliverable> request) {
        return null;
    }

    private static Set<TileEntityWareHouse> getWareHousesInColony(Colony colony) {
        return colony.getBuildingManager().getBuildings().values().stream().filter(building -> building instanceof BuildingWareHouse).map(building -> (TileEntityWareHouse)building.getTileEntity()).collect(Collectors.toSet());
    }

    @Override
    public void onRequestComplete(@NotNull IToken<?> token) {
    }

    @Override
    public void onRequestCancelled(@NotNull IToken<?> token) {
    }

    @Override
    @NotNull
    public ITextComponent getDisplayName(@NotNull IToken<?> token) {
        return new TextComponentTranslation("com.minecolonies.coremod.buildings.warehouse.name", new Object[0]);
    }

    @Override
    public int getPriority() {
        return 150;
    }
}

