/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.requestsystem.resolvers;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.reflect.TypeToken;
import com.minecolonies.api.colony.requestsystem.factory.IFactoryController;
import com.minecolonies.api.colony.requestsystem.location.ILocation;
import com.minecolonies.api.colony.requestsystem.manager.IRequestManager;
import com.minecolonies.api.colony.requestsystem.request.IRequest;
import com.minecolonies.api.colony.requestsystem.requestable.IRetryable;
import com.minecolonies.api.colony.requestsystem.resolver.retrying.IRetryingRequestResolver;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.configuration.Configurations;
import com.minecolonies.api.util.constant.TypeConstants;
import com.minecolonies.coremod.colony.requestsystem.management.handlers.LogHandler;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StandardRetryingRequestResolver
implements IRetryingRequestResolver {
    private static final Integer CONST_RETRYING_ID_SCALE = -20000;
    private IRequestManager manager;
    private ILocation location;
    private IToken<?> id;
    private IToken<?> current;
    private HashMap<IToken<?>, Integer> delays = new HashMap();
    private HashMap<IToken<?>, Integer> assignedRequests = new HashMap();

    public StandardRetryingRequestResolver(IFactoryController factoryController, IRequestManager manager) {
        this.updateManager(manager);
        this.id = factoryController.getNewInstance(TypeConstants.ITOKEN, manager.getColony().getID() * CONST_RETRYING_ID_SCALE, new Object[0]);
        this.location = factoryController.getNewInstance(TypeConstants.ILOCATION, manager.getColony().getCenter(), manager.getColony().getWorld().field_73011_w.getDimension());
    }

    @Override
    public void updateManager(IRequestManager manager) {
        this.manager = manager;
    }

    @Override
    public int getMaximalTries() {
        return Configurations.RequestSystem.maximalRetries;
    }

    @Override
    public int getMaximalDelayBetweenRetriesInTicks() {
        return Configurations.RequestSystem.delayBetweenRetries;
    }

    @Override
    public int getCurrentReassignmentAttempt() {
        return this.isReassigning() ? -1 : this.assignedRequests.get(this.getCurrentlyBeingReassignedRequest()) + 1;
    }

    @Override
    @Nullable
    public IToken<?> getCurrentlyBeingReassignedRequest() {
        return this.current;
    }

    public StandardRetryingRequestResolver(IToken<?> id, ILocation location) {
        this.id = id;
        this.location = location;
    }

    @Override
    public TypeToken<? extends IRetryable> getRequestType() {
        return TypeConstants.RETRYABLE;
    }

    @Override
    public boolean canResolve(@NotNull IRequestManager manager, IRequest<? extends IRetryable> requestToCheck) {
        return this.getCurrentlyBeingReassignedRequest() == null || requestToCheck.getToken() != this.getCurrentlyBeingReassignedRequest() || this.getCurrentReassignmentAttempt() < this.getMaximalTries();
    }

    @Override
    @Nullable
    public List<IToken<?>> attemptResolve(@NotNull IRequestManager manager, @NotNull IRequest<? extends IRetryable> request) {
        return ImmutableList.of();
    }

    @Override
    public void resolve(@NotNull IRequestManager manager, @NotNull IRequest<? extends IRetryable> request) throws RuntimeException {
        this.delays.put((IToken<?>)request.getToken(), this.getMaximalDelayBetweenRetriesInTicks());
        this.assignedRequests.put((IToken<?>)request.getToken(), this.assignedRequests.containsKey(request.getToken()) ? this.assignedRequests.get(request.getToken()) + 1 : 1);
    }

    @Override
    @Nullable
    public IRequest getFollowupRequestForCompletion(@NotNull IRequestManager manager, @NotNull IRequest<? extends IRetryable> completedRequest) {
        return null;
    }

    @Override
    @Nullable
    public IRequest onRequestCancelledOrOverruled(@NotNull IRequestManager manager, @NotNull IRequest<? extends IRetryable> request) {
        if (this.assignedRequests.containsKey(request.getToken())) {
            this.delays.remove(request.getToken());
            this.assignedRequests.remove(request.getToken());
        }
        return null;
    }

    @Override
    public int getPriority() {
        return 50;
    }

    public void func_73660_a() {
        LogHandler.log("Starting reassignment.");
        this.getAllAssignedRequests().forEach(t -> {
            Integer current = this.delays.remove(t);
            current = current - 1;
            this.delays.put((IToken<?>)t, current);
        });
        Set retryables = this.delays.keySet().stream().filter(t -> this.delays.get(t) == 0).collect(Collectors.toSet());
        Set<IToken> successfully = retryables.stream().filter(t -> {
            ImmutableSet blackList = this.assignedRequests.get(t) < this.getMaximalTries() ? ImmutableSet.of() : ImmutableSet.of(this.id);
            Integer currentAttempt = this.assignedRequests.get(t);
            this.setCurrent((IToken<?>)t);
            IToken<?> resultingResolver = this.manager.reassignRequest((IToken<?>)t, (Collection<IToken<?>>)blackList);
            this.setCurrent(null);
            currentAttempt = currentAttempt + 1;
            this.assignedRequests.put((IToken<?>)t, currentAttempt);
            if (resultingResolver != null && !resultingResolver.equals(this.getRequesterId())) {
                this.assignedRequests.remove(t);
                this.delays.remove(t);
            }
            return resultingResolver != null;
        }).collect(Collectors.toSet());
        successfully.forEach(t -> LogHandler.log("Failed to reassign a retryable request: " + this.id));
        LogHandler.log("Finished reassignment.");
    }

    @Override
    public ImmutableList<IToken<?>> getAllAssignedRequests() {
        return ImmutableList.copyOf(this.assignedRequests.keySet());
    }

    public void setCurrent(@Nullable IToken<?> token) {
        this.current = token;
    }

    @Override
    public IToken<?> getRequesterId() {
        return this.id;
    }

    @Override
    @NotNull
    public ILocation getRequesterLocation() {
        return this.location;
    }

    @Override
    public void onRequestComplete(@NotNull IToken<?> token) {
    }

    @Override
    public void onRequestCancelled(@NotNull IToken<?> token) {
    }

    @Override
    @NotNull
    public ITextComponent getDisplayName(@NotNull IToken<?> token) {
        return new TextComponentString("Player");
    }

    public void updateData(@NotNull Map<IToken<?>, Integer> newAssignedRequests, @NotNull Map<IToken<?>, Integer> newDelays) {
        this.assignedRequests.clear();
        this.assignedRequests.putAll(newAssignedRequests);
        this.delays.clear();
        this.delays.putAll(newDelays);
    }

    public HashMap<IToken<?>, Integer> getDelays() {
        return this.delays;
    }

    public HashMap<IToken<?>, Integer> getAssignedRequests() {
        return this.assignedRequests;
    }
}

