/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.requestsystem.resolvers;

import com.google.common.collect.Lists;
import com.google.common.reflect.TypeToken;
import com.minecolonies.api.colony.requestsystem.location.ILocation;
import com.minecolonies.api.colony.requestsystem.manager.IRequestManager;
import com.minecolonies.api.colony.requestsystem.request.IRequest;
import com.minecolonies.api.colony.requestsystem.request.RequestState;
import com.minecolonies.api.colony.requestsystem.requestable.IDeliverable;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import com.minecolonies.coremod.colony.buildings.views.AbstractBuildingView;
import com.minecolonies.coremod.colony.requestsystem.requesters.BuildingBasedRequester;
import com.minecolonies.coremod.colony.requestsystem.resolvers.AbstractRequestResolver;
import com.minecolonies.coremod.tileentities.TileEntityColonyBuilding;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BuildingRequestResolver
extends AbstractRequestResolver<IDeliverable> {
    public BuildingRequestResolver(@NotNull ILocation location, @NotNull IToken<?> token) {
        super(location, token);
    }

    @Override
    public int getPriority() {
        return 200;
    }

    @Override
    public TypeToken<? extends IDeliverable> getRequestType() {
        return TypeToken.of(IDeliverable.class);
    }

    @Override
    public boolean canResolve(@NotNull IRequestManager manager, IRequest<? extends IDeliverable> requestToCheck) {
        if (manager.getColony().getWorld().field_72995_K) {
            return false;
        }
        if (!(requestToCheck.getRequester() instanceof BuildingBasedRequester)) {
            return false;
        }
        if (!requestToCheck.getRequester().getRequesterLocation().equals(this.getRequesterLocation())) {
            return false;
        }
        AbstractBuilding building = this.getBuildingFromRequest(manager, requestToCheck);
        ArrayList<TileEntityColonyBuilding> tileEntities = new ArrayList<TileEntityColonyBuilding>();
        tileEntities.add(building.getTileEntity());
        tileEntities.addAll(building.getAdditionalCountainers().stream().map(arg_0 -> ((World)manager.getColony().getWorld()).func_175625_s(arg_0)).collect(Collectors.toSet()));
        tileEntities.removeIf(Objects::isNull);
        return tileEntities.stream().map(tileEntity -> InventoryUtils.filterProvider((ICapabilityProvider)tileEntity, itemStack -> ItemStackUtils.isEmpty(itemStack) == false && ((IDeliverable)requestToCheck.getRequest()).matches((ItemStack)itemStack))).anyMatch(itemStacks -> !itemStacks.isEmpty());
    }

    @Override
    @Nullable
    public List<IToken<?>> attemptResolve(@NotNull IRequestManager manager, @NotNull IRequest<? extends IDeliverable> request) {
        if (this.canResolve(manager, request)) {
            return Lists.newArrayList();
        }
        return null;
    }

    @Override
    public void resolve(@NotNull IRequestManager manager, @NotNull IRequest<? extends IDeliverable> request) throws RuntimeException {
        AbstractBuilding building = this.getBuildingFromRequest(manager, request);
        ArrayList<TileEntityColonyBuilding> tileEntities = new ArrayList<TileEntityColonyBuilding>();
        tileEntities.add(building.getTileEntity());
        tileEntities.addAll(building.getAdditionalCountainers().stream().map(arg_0 -> ((World)manager.getColony().getWorld()).func_175625_s(arg_0)).collect(Collectors.toSet()));
        request.setDelivery(tileEntities.stream().map(tileEntity -> InventoryUtils.filterProvider((ICapabilityProvider)tileEntity, itemStack -> ((IDeliverable)request.getRequest()).matches((ItemStack)itemStack))).filter(itemStacks -> !itemStacks.isEmpty()).flatMap(Collection::stream).findFirst().orElse(ItemStackUtils.EMPTY));
        manager.updateRequestState((IToken<?>)request.getToken(), RequestState.COMPLETED);
    }

    @NotNull
    private AbstractBuilding getBuildingFromRequest(@NotNull IRequestManager manager, @NotNull IRequest<? extends IDeliverable> request) throws RuntimeException {
        BuildingBasedRequester requester = (BuildingBasedRequester)request.getRequester();
        return requester.getBuilding().map(r -> {
            if (r instanceof AbstractBuildingView && manager.getColony() instanceof Colony) {
                Colony colony = (Colony)manager.getColony();
                return colony.getBuildingManager().getBuilding(((AbstractBuildingView)r).getID());
            }
            return (AbstractBuilding)r;
        }).orElseThrow(() -> new IllegalStateException("Unknown building."));
    }

    @Override
    @Nullable
    public IRequest<?> getFollowupRequestForCompletion(@NotNull IRequestManager manager, @NotNull IRequest<? extends IDeliverable> completedRequest) {
        return null;
    }

    @Override
    @Nullable
    public IRequest<?> onRequestCancelledOrOverruled(@NotNull IRequestManager manager, @NotNull IRequest<? extends IDeliverable> request) {
        return null;
    }

    @Override
    public void onRequestComplete(@NotNull IToken<?> token) {
    }

    @Override
    public void onRequestCancelled(@NotNull IToken<?> token) {
    }
}

