/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.requestsystem.requests;

import com.google.common.collect.ImmutableList;
import com.minecolonies.api.colony.requestsystem.request.RequestState;
import com.minecolonies.api.colony.requestsystem.requestable.Burnable;
import com.minecolonies.api.colony.requestsystem.requestable.Delivery;
import com.minecolonies.api.colony.requestsystem.requestable.Food;
import com.minecolonies.api.colony.requestsystem.requestable.Stack;
import com.minecolonies.api.colony.requestsystem.requestable.Tool;
import com.minecolonies.api.colony.requestsystem.requester.IRequester;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.blockout.Log;
import com.minecolonies.coremod.colony.requestable.SmeltableOre;
import com.minecolonies.coremod.colony.requestsystem.requests.AbstractRequest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import org.jetbrains.annotations.NotNull;

public final class StandardRequests {
    private StandardRequests() {
    }

    public static class BurnableRequest
    extends AbstractRequest<Burnable> {
        private static ImmutableList<ItemStack> burnableExamples;

        BurnableRequest(@NotNull IRequester requester, @NotNull IToken<?> token, @NotNull Burnable requested) {
            super(requester, token, requested);
        }

        BurnableRequest(@NotNull IRequester requester, @NotNull IToken<?> token, @NotNull RequestState state, @NotNull Burnable requested) {
            super(requester, token, state, requested);
        }

        @Override
        @NotNull
        public ITextComponent getShortDisplayString() {
            return new TextComponentTranslation("com.minecolonies.coremod.request.burnable", new Object[0]);
        }

        @Override
        @NotNull
        public List<ItemStack> getDisplayStacks() {
            if (burnableExamples == null) {
                burnableExamples = ImmutableList.copyOf((Collection)StreamSupport.stream(Spliterators.spliteratorUnknownSize(Item.field_150901_e.iterator(), 16), false).flatMap(item -> {
                    ArrayList stacks = new ArrayList();
                    try {
                        item.func_150895_a(item, null, stacks);
                    }
                    catch (Exception ex) {
                        Log.getLogger().warn("Failed to get sub items from: " + item.getRegistryName());
                    }
                    return stacks.stream().filter(TileEntityFurnace::func_145954_b);
                }).collect(Collectors.toList()));
            }
            return burnableExamples;
        }
    }

    public static class SmeltAbleOreRequest
    extends AbstractRequest<SmeltableOre> {
        private static final ImmutableList<ItemStack> oreExamples = ImmutableList.of((Object)new ItemStack(Blocks.field_150352_o), (Object)new ItemStack(Blocks.field_150366_p));

        SmeltAbleOreRequest(@NotNull IRequester requester, @NotNull IToken token, @NotNull SmeltableOre requested) {
            super(requester, token, requested);
        }

        SmeltAbleOreRequest(@NotNull IRequester requester, @NotNull IToken token, @NotNull RequestState state, @NotNull SmeltableOre requested) {
            super(requester, token, state, requested);
        }

        @Override
        @NotNull
        public ITextComponent getShortDisplayString() {
            return new TextComponentTranslation("com.minecolonies.coremod.request.smeltableore", new Object[0]);
        }

        @Override
        public List<ItemStack> getDisplayStacks() {
            return oreExamples;
        }
    }

    public static class FoodRequest
    extends AbstractRequest<Food> {
        private static ImmutableList<ItemStack> foodExamples;

        FoodRequest(@NotNull IRequester requester, @NotNull IToken<?> token, @NotNull Food requested) {
            super(requester, token, requested);
        }

        FoodRequest(@NotNull IRequester requester, @NotNull IToken<?> token, @NotNull RequestState state, @NotNull Food requested) {
            super(requester, token, state, requested);
        }

        @Override
        @NotNull
        public ITextComponent getShortDisplayString() {
            return new TextComponentTranslation("com.minecolonies.coremod.request.food", new Object[0]);
        }

        @Override
        @NotNull
        public List<ItemStack> getDisplayStacks() {
            if (foodExamples == null) {
                foodExamples = ImmutableList.copyOf((Collection)StreamSupport.stream(Spliterators.spliteratorUnknownSize(Item.field_150901_e.iterator(), 16), false).filter(item -> item instanceof ItemFood).flatMap(item -> {
                    ArrayList stacks = new ArrayList();
                    try {
                        item.func_150895_a(item, null, stacks);
                    }
                    catch (Exception ex) {
                        Log.getLogger().warn("Failed to get sub items from: " + item.getRegistryName());
                    }
                    return stacks.stream();
                }).collect(Collectors.toList()));
            }
            return foodExamples;
        }
    }

    public static class ToolRequest
    extends AbstractRequest<Tool> {
        private ImmutableList<ItemStack> toolExamples;

        public ToolRequest(@NotNull IRequester requester, @NotNull IToken<?> token, @NotNull Tool requested) {
            super(requester, token, requested);
        }

        public ToolRequest(@NotNull IRequester requester, @NotNull IToken<?> token, @NotNull RequestState state, @NotNull Tool requested) {
            super(requester, token, state, requested);
        }

        @Override
        @NotNull
        public ITextComponent getLongDisplayString() {
            TextComponentTranslation preType = new TextComponentTranslation("com.minecolonies.coremod.request.tool.pretype", new Object[0]);
            preType.func_150257_a(((Tool)this.getRequest()).getToolClass().getDisplayName());
            if (((Tool)this.getRequest()).getMinLevel() > -1) {
                preType.func_150257_a((ITextComponent)new TextComponentTranslation("com.minecolonies.coremod.request.tool.preminlevel", new Object[0]));
                preType.func_150258_a(ItemStackUtils.swapToolGrade(((Tool)this.getRequest()).getMinLevel()));
            }
            if (((Tool)this.getRequest()).getMaxLevel() < 32) {
                if (((Tool)this.getRequest()).getMinLevel() > -1) {
                    preType.func_150257_a((ITextComponent)new TextComponentTranslation("com.minecolonies.coremod.general.and", new Object[0]));
                }
                preType.func_150257_a((ITextComponent)new TextComponentTranslation("com.minecolonies.coremod.request.tool.premaxlevel", new Object[0]));
                preType.func_150258_a(ItemStackUtils.swapToolGrade(((Tool)this.getRequest()).getMaxLevel()));
            }
            return preType;
        }

        @Override
        @NotNull
        public ITextComponent getShortDisplayString() {
            return ((Tool)this.getRequest()).getToolClass().getDisplayName();
        }

        @Override
        @NotNull
        public List<ItemStack> getDisplayStacks() {
            if (this.toolExamples == null) {
                this.toolExamples = ImmutableList.copyOf((Collection)StreamSupport.stream(Spliterators.spliteratorUnknownSize(Item.field_150901_e.iterator(), 16), false).flatMap(item -> {
                    ArrayList stacks = new ArrayList();
                    try {
                        item.func_150895_a(item, null, stacks);
                    }
                    catch (Exception ex) {
                        Log.getLogger().warn("Failed to get sub items from: " + item.getRegistryName());
                    }
                    return stacks.stream().filter(((Tool)this.getRequest())::matches);
                }).collect(Collectors.toList()));
            }
            return this.toolExamples;
        }
    }

    public static class DeliveryRequest
    extends AbstractRequest<Delivery> {
        public DeliveryRequest(@NotNull IRequester requester, @NotNull IToken<?> token, @NotNull Delivery requested) {
            super(requester, token, requested);
        }

        public DeliveryRequest(@NotNull IRequester requester, @NotNull IToken<?> token, @NotNull RequestState state, @NotNull Delivery requested) {
            super(requester, token, state, requested);
        }

        @Override
        @NotNull
        public ItemStack getDelivery() {
            if (this.getResult() != null && !ItemStackUtils.isEmpty(((Delivery)this.getResult()).getStack()).booleanValue()) {
                return ((Delivery)this.getResult()).getStack();
            }
            return ItemStackUtils.EMPTY;
        }

        @Override
        @NotNull
        public ITextComponent getShortDisplayString() {
            return new TextComponentTranslation("com.minecolonies.coremod.request.delivery", new Object[0]).func_150257_a(this.getDelivery().func_151000_E());
        }

        @Override
        @NotNull
        public List<ItemStack> getDisplayStacks() {
            return ImmutableList.of();
        }

        @Override
        @NotNull
        public ResourceLocation getDisplayIcon() {
            return new ResourceLocation("minecolonies:textures/gui/citizen/colonist_button_small.png");
        }
    }

    public static class ItemStackRequest
    extends AbstractRequest<Stack> {
        public ItemStackRequest(@NotNull IRequester requester, @NotNull IToken<?> token, @NotNull Stack requested) {
            super(requester, token, requested);
        }

        public ItemStackRequest(@NotNull IRequester requester, @NotNull IToken<?> token, @NotNull RequestState state, @NotNull Stack requested) {
            super(requester, token, state, requested);
        }

        @Override
        @NotNull
        public ITextComponent getShortDisplayString() {
            return new TextComponentTranslation(((Stack)this.getRequest()).getCount() + " " + ((Stack)this.getRequest()).getStack().func_151000_E().func_150254_d(), new Object[0]);
        }

        @Override
        @NotNull
        public List<ItemStack> getDisplayStacks() {
            return ImmutableList.of((Object)((Stack)this.getRequest()).getStack().func_77946_l());
        }
    }
}

