/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.requestsystem.requesters;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.requestsystem.factory.IFactoryController;
import com.minecolonies.api.colony.requestsystem.location.ILocation;
import com.minecolonies.api.colony.requestsystem.requester.IRequester;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.colony.ColonyManager;
import java.util.Optional;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

public class BuildingBasedRequester
implements IRequester {
    private static final String NBT_LOCATION = "Location";
    private static final String NBT_ID = "Id";
    private final ILocation location;
    private final IToken<?> requesterId;
    private IRequester building = null;

    public BuildingBasedRequester(ILocation location, IToken<?> requesterId) {
        this.location = location;
        this.requesterId = requesterId;
    }

    public static BuildingBasedRequester deserialize(IFactoryController controller, NBTTagCompound compound) {
        ILocation location = (ILocation)controller.deserialize(compound.func_74775_l(NBT_LOCATION));
        IToken token = (IToken)controller.deserialize(compound.func_74775_l(NBT_ID));
        return new BuildingBasedRequester(location, token);
    }

    public NBTTagCompound serialize(IFactoryController controller) {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74782_a(NBT_LOCATION, (NBTBase)controller.serialize(this.getRequesterLocation()));
        compound.func_74782_a(NBT_ID, (NBTBase)controller.serialize(this.getRequesterId()));
        return compound;
    }

    @Override
    public IToken<?> getRequesterId() {
        return this.requesterId;
    }

    @Override
    @NotNull
    public ILocation getRequesterLocation() {
        return this.location;
    }

    @Override
    public void onRequestComplete(@NotNull IToken<?> token) {
        this.getBuilding().ifPresent(requester -> requester.onRequestComplete(token));
    }

    @Override
    public void onRequestCancelled(@NotNull IToken<?> token) {
        this.getBuilding().ifPresent(requester -> requester.onRequestCancelled(token));
    }

    @Override
    @NotNull
    public ITextComponent getDisplayName(@NotNull IToken<?> token) {
        return this.getBuilding().map(requester -> requester.getDisplayName(token)).orElseGet(() -> new TextComponentString("<UNKNOWN>"));
    }

    public Optional<IRequester> getBuilding() {
        this.updateBuilding();
        return Optional.ofNullable(this.building);
    }

    private void updateBuilding() {
        if (this.building != null) {
            return;
        }
        if (this.location == null) {
            return;
        }
        World world = MineColonies.proxy.getWorld(this.location.getDimension());
        IColony colony = ColonyManager.getClosestIColony(world, this.location.getInDimensionLocation());
        this.building = colony.getRequesterBuildingForPosition(this.location.getInDimensionLocation());
    }
}

