/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.requestsystem.management.manager.wrapped;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.requestsystem.factory.IFactoryController;
import com.minecolonies.api.colony.requestsystem.manager.IRequestManager;
import com.minecolonies.api.colony.requestsystem.request.IRequest;
import com.minecolonies.api.colony.requestsystem.request.RequestState;
import com.minecolonies.api.colony.requestsystem.requestable.IRequestable;
import com.minecolonies.api.colony.requestsystem.requester.IRequester;
import com.minecolonies.api.colony.requestsystem.resolver.IRequestResolver;
import com.minecolonies.api.colony.requestsystem.resolver.IRequestResolverProvider;
import com.minecolonies.api.colony.requestsystem.resolver.player.IPlayerRequestResolver;
import com.minecolonies.api.colony.requestsystem.resolver.retrying.IRetryingRequestResolver;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.coremod.colony.requestsystem.management.IStandardRequestManager;
import com.minecolonies.coremod.colony.requestsystem.management.handlers.RequestHandler;
import java.util.Collection;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractWrappedRequestManager
implements IRequestManager {
    @NotNull
    protected final IStandardRequestManager wrappedManager;

    public AbstractWrappedRequestManager(@NotNull IStandardRequestManager wrappedManager) {
        this.wrappedManager = wrappedManager;
    }

    @Override
    @NotNull
    public IColony getColony() {
        return this.wrappedManager.getColony();
    }

    @Override
    @NotNull
    public IFactoryController getFactoryController() {
        return this.wrappedManager.getFactoryController();
    }

    @Override
    @NotNull
    public <T extends IRequestable> IToken<?> createRequest(@NotNull IRequester requester, @NotNull T object) {
        return this.wrappedManager.createRequest(requester, object);
    }

    @Override
    public void assignRequest(@NotNull IToken<?> token) {
        this.wrappedManager.assignRequest(token);
    }

    @Override
    @NotNull
    public <T extends IRequestable> IToken<?> createAndAssignRequest(@NotNull IRequester requester, @NotNull T object) {
        IToken<?> token = this.createRequest(requester, object);
        this.assignRequest(token);
        return token;
    }

    @Override
    public IToken<?> reassignRequest(@NotNull IToken<?> token, @NotNull Collection<IToken<?>> resolverTokenBlackList) {
        return this.wrappedManager.reassignRequest(token, resolverTokenBlackList);
    }

    @Override
    @NotNull
    public IRequest getRequestForToken(@NotNull IToken<?> token) {
        return RequestHandler.getRequestOrNull(this.wrappedManager, token);
    }

    @Override
    @NotNull
    public IRequestResolver getResolverForToken(@NotNull IToken<?> token) {
        return this.wrappedManager.getResolverForToken(token);
    }

    @Override
    @Nullable
    public IRequestResolver getResolverForRequest(@NotNull IToken<?> requestToken) {
        return this.wrappedManager.getResolverForRequest(requestToken);
    }

    @Override
    public void updateRequestState(@NotNull IToken<?> token, @NotNull RequestState state) {
        this.wrappedManager.updateRequestState(token, state);
    }

    @Override
    public void overruleRequest(@NotNull IToken<?> token, @Nullable ItemStack stack) {
        this.wrappedManager.overruleRequest(token, stack);
    }

    @Override
    public void onProviderAddedToColony(@NotNull IRequestResolverProvider provider) {
        this.wrappedManager.onProviderAddedToColony(provider);
    }

    @Override
    public void onProviderRemovedFromColony(@NotNull IRequestResolverProvider provider) {
        this.wrappedManager.onProviderRemovedFromColony(provider);
    }

    @Override
    @NotNull
    public IPlayerRequestResolver getPlayerResolver() {
        return this.wrappedManager.getPlayerResolver();
    }

    @Override
    @NotNull
    public IRetryingRequestResolver getRetryingRequestResolver() {
        return this.wrappedManager.getRetryingRequestResolver();
    }

    public NBTTagCompound serializeNBT() {
        return (NBTTagCompound)this.wrappedManager.serializeNBT();
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        this.wrappedManager.deserializeNBT((NBTBase)nbt);
    }

    public void func_73660_a() {
        this.wrappedManager.func_73660_a();
    }
}

